/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.widget.attribute.BooleanTrend;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class BooleanTrendSelectionNode
extends DefaultMutableTreeNode
implements IBooleanScalarListener,
PropertyChangeListener {
    private String devname = "";
    private IBooleanScalar model;
    private int selected;
    private JLDataView data;
    private long lastErrorTime = 0L;
    static GregorianCalendar calendar = new GregorianCalendar();
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    BooleanTrend chart;

    public BooleanTrendSelectionNode(BooleanTrend booleanTrend) {
        this.devname = "Trend";
        this.model = null;
        this.data = null;
        this.chart = booleanTrend;
    }

    public BooleanTrendSelectionNode(BooleanTrend booleanTrend, String string) {
        this.devname = string;
        this.data = null;
        this.model = null;
        this.chart = booleanTrend;
    }

    public BooleanTrendSelectionNode(BooleanTrend booleanTrend, String string, IBooleanScalar iBooleanScalar, int n, Color color) {
        this.devname = string;
        this.model = iBooleanScalar;
        this.selected = n;
        this.chart = booleanTrend;
        this.data = new JLDataView();
        this.data.setColor(color);
        this.data.setMarkerColor(color);
        iBooleanScalar.addBooleanScalarListener((IBooleanScalarListener)this);
        iBooleanScalar.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        iBooleanScalar.getProperty("unit").addPresentationListener((PropertyChangeListener)this);
        iBooleanScalar.getProperty("format").addPresentationListener((PropertyChangeListener)this);
    }

    public void refreshNode() {
        this.data.setUnit(this.model.getUnit());
        this.data.setUserFormat(this.model.getFormat());
        if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
            if (this.chart.displayDeviceNames()) {
                this.data.setName(this.devname + "/" + this.model.getLabel());
            } else {
                this.data.setName(this.model.getLabel());
            }
        } else {
            this.data.setName(this.model.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.model != null) {
            this.refreshNode();
            this.chart.refreshNode(this);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int n) {
        switch (n) {
            case 0: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY1Axis().addDataView(this.data);
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY2Axis().addDataView(this.data);
            }
        }
        this.selected = n;
    }

    @Override
    public boolean isLeaf() {
        return this.model != null;
    }

    public IBooleanScalar getModel() {
        return this.model;
    }

    public JLDataView getData() {
        return this.data;
    }

    public void delItem(IBooleanScalar iBooleanScalar) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getChildCount();
        boolean bl = false;
        String string = iBooleanScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n3 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        if (bl) {
            BooleanTrendSelectionNode booleanTrendSelectionNode = (BooleanTrendSelectionNode)this.getChildAt(n);
            bl = false;
            n2 = 0;
            int n4 = booleanTrendSelectionNode.getChildCount();
            while (n2 < n4 && !bl) {
                bl = string.equals(booleanTrendSelectionNode.getChild(n2).getModelName());
                if (bl) continue;
                ++n2;
            }
            if (bl) {
                booleanTrendSelectionNode.getChild(n2).setSelected(0);
                iBooleanScalar.removeBooleanScalarListener((IBooleanScalarListener)booleanTrendSelectionNode.getChild(n2));
                booleanTrendSelectionNode.remove(n2);
                if (n4 == 1) {
                    this.remove(n);
                }
            }
        }
    }

    public BooleanTrendSelectionNode addItem(BooleanTrend booleanTrend, IBooleanScalar iBooleanScalar, Color color) {
        int n = 0;
        int n2 = this.getChildCount();
        boolean bl = false;
        String string = iBooleanScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n2 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        BooleanTrendSelectionNode booleanTrendSelectionNode = new BooleanTrendSelectionNode(booleanTrend, string2, iBooleanScalar, 0, color);
        if (bl) {
            this.getChild(n).add(booleanTrendSelectionNode);
        } else {
            BooleanTrendSelectionNode booleanTrendSelectionNode2 = new BooleanTrendSelectionNode(booleanTrend, string2);
            this.add(booleanTrendSelectionNode2);
            booleanTrendSelectionNode2.add(booleanTrendSelectionNode);
        }
        return booleanTrendSelectionNode;
    }

    public Vector getSelectableItems() {
        Vector<BooleanTrendSelectionNode> vector;
        if (this.isLeaf()) {
            vector = new Vector<BooleanTrendSelectionNode>();
            vector.add(this);
        } else {
            int n = this.getChildCount();
            vector = new Vector();
            for (int i = 0; i < n; ++i) {
                BooleanTrendSelectionNode booleanTrendSelectionNode = this.getChild(i);
                vector.addAll(booleanTrendSelectionNode.getSelectableItems());
            }
        }
        return vector;
    }

    public void showOptions() {
        if (this.data != null) {
            this.chart.getChart().showDataOptionDialog(this.data);
        }
    }

    public String getModelName() {
        if (this.model != null) {
            return this.model.getName();
        }
        return "";
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeBooleanScalarListener((IBooleanScalarListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("unit").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
        }
        this.data = null;
        this.model = null;
    }

    public BooleanTrendSelectionNode getChild(int n) {
        return (BooleanTrendSelectionNode)this.getChildAt(n);
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        if (this.model == null) {
            return;
        }
        boolean bl = true;
        DataList dataList = this.data.getLastValue();
        double d = booleanScalarEvent.getTimeStamp();
        boolean bl2 = booleanScalarEvent.getValue();
        if (dataList != null) {
            boolean bl3 = dataList.x != d || dataList.y == 1.0 != bl2 ? true : (bl = false);
        }
        if (bl) {
            this.data.add(booleanScalarEvent.getTimeStamp(), booleanScalarEvent.getValue() ? 1.0 : 0.0);
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.model == null) {
            return;
        }
        if (this.lastErrorTime != errorEvent.getTimeStamp()) {
            this.lastErrorTime = errorEvent.getTimeStamp();
            this.data.add(this.lastErrorTime, Double.NaN);
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    @Override
    public String toString() {
        if (this.model != null) {
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                return this.model.getLabel();
            }
            return this.model.getNameSansDevice();
        }
        return this.devname;
    }
}

