/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.tangoatk.core.ATKException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.tango.logconsumer.LogConsumer;
import org.tango.logconsumer.SourceSet;
import org.tango.server.ServerManager;

class TangoLoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(TangoLoggingReceiver.class);
    private static final String DYN_DEV_NAME_PREFIX = "tmp/log/";
    private String deviceName;
    private static final SourceSet mSet = SourceSet.instance();
    private boolean mRunningInStaticMode = false;
    private static final String LOG_SRC_PROPERTY = "logging_source";
    private HistoryArea mHistoryArea;
    private String instanceName;
    private static final String className = "LogConsumer";

    TangoLoggingReceiver(String[] stringArray, MyTableModel myTableModel, HistoryArea historyArea) throws Exception {
        this.setDaemon(true);
        this.mHistoryArea = historyArea;
        try {
            DbDevInfo dbDevInfo;
            boolean bl = true;
            Random random = new Random(System.currentTimeMillis());
            String string = "@" + random.nextInt(128);
            if (stringArray.length == 0 || !stringArray[0].contains("/")) {
                LOG.debug((Object)"No instance name provided.");
                bl = false;
                String string2 = InetAddress.getLocalHost().getHostName();
                dbDevInfo = string2.split(".");
                if (((String[])dbDevInfo).length != 0) {
                    string2 = dbDevInfo[0];
                }
                this.instanceName = string2 + string;
                this.deviceName = DYN_DEV_NAME_PREFIX + this.instanceName;
            } else {
                LOG.debug((Object)("Provided device name: " + stringArray[0]));
                this.deviceName = stringArray[0];
                int n = this.deviceName.lastIndexOf(47);
                if (n == -1) {
                    LOG.fatal((Object)"Invalid device name specified. Quiting");
                    JOptionPane.showMessageDialog(null, "Invalid device name specified. Quiting", "Tango Log Viewer", 0);
                    System.exit(1);
                }
                this.instanceName = this.deviceName.substring(n + 1);
                this.mRunningInStaticMode = true;
            }
            String string3 = "LogConsumer/" + this.instanceName;
            LOG.debug((Object)("Device name is " + this.deviceName));
            LOG.debug((Object)"Registering the LogConsumer into the database");
            dbDevInfo = new DbDevInfo(this.deviceName, className, string3);
            ApiUtil.get_db_obj().add_device(dbDevInfo);
            String[] stringArray2 = bl ? new String[stringArray.length] : new String[stringArray.length + 1];
            stringArray2[0] = this.instanceName;
            int n = bl ? 1 : 0;
            int n2 = 1;
            while (n < stringArray.length) {
                stringArray2[n2] = stringArray[n];
                ++n;
                ++n2;
            }
            LOG.debug((Object)"Initializing the util singleton");
            LOG.debug((Object)"Passing following args to Util.init:");
            for (n = 0; n < stringArray2.length; ++n) {
                LOG.debug((Object)("\targs[" + String.valueOf(n) + "]: " + stringArray2[n]));
            }
            LOG.debug((Object)("Starting " + string3));
            ServerManager.getInstance().start(stringArray2, LogConsumer.class);
            LogConsumer logConsumer = LogConsumer.getDeviceInstance(this.deviceName);
            logConsumer.setModel(myTableModel);
            if (this.mRunningInStaticMode) {
                this.getLoggingSourceProperty();
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void setTableModel(MyTableModel myTableModel) {
        LogConsumer.getDeviceInstance(this.deviceName).setModel(myTableModel);
    }

    public void setHistoryArea(HistoryArea historyArea) {
        this.mHistoryArea = historyArea;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public boolean isRunningInStaticMode() {
        return this.mRunningInStaticMode;
    }

    @Override
    public void run() {
        LOG.debug((Object)"Device server started");
    }

    private String[] getDeviceList(String string) {
        String[] stringArray = new String[]{};
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetDeviceExportedList", deviceData);
            stringArray = deviceData2.extractStringArray();
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
        return stringArray;
    }

    public int addLoggingSources(String string) {
        String[] stringArray;
        int n = 0;
        for (String string2 : stringArray = this.getDeviceList(string)) {
            if (this.addLoggingSource(string2) != -1) continue;
            n = -1;
        }
        return n;
    }

    public int addCoLocatedSources(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{"*", "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            String string2 = deviceProxy.adm_name().substring(deviceProxy.adm_name().indexOf(47) + 1);
            LOG.debug((Object)("TangoLoggingReceiver::addCoLocatedSources::server_name is " + string2));
            String[] stringArray2 = ApiUtil.get_db_obj().get_device_class_list(string2);
            for (int i = 0; i < stringArray2.length; i += 2) {
                LOG.debug((Object)("TangoLoggingReceiver::addCoLocatedSources::mSet adding " + stringArray2[i]));
                mSet.add(stringArray2[i]);
            }
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int addLoggingSource(String string) {
        try {
            LOG.debug((Object)("Adding " + string + " to logging sources list"));
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string, "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            mSet.add(string);
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int addTangoCoreLogger(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            LOG.debug((Object)("Adding " + deviceProxy2.get_name() + " to logging sources list"));
            String[] stringArray = new String[]{deviceProxy2.get_name(), "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            mSet.add(string);
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeLoggingSources(String string) {
        String[] stringArray;
        int n = 0;
        for (String string2 : stringArray = this.getDeviceList(string)) {
            if (this.removeLoggingSource(string2) != -1) continue;
            n = -1;
        }
        return n;
    }

    public int removeLoggingSource(String string) {
        return this.removeLoggingSource(string, true);
    }

    private int removeLoggingSource(String string, boolean bl) {
        try {
            LOG.debug((Object)("Removing " + string + " from logging sources list"));
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string, "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            if (bl) {
                mSet.remove(string);
                LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeTangoCoreLogger(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            LOG.debug((Object)("Removing " + deviceProxy2.get_name() + " from logging sources list"));
            String[] stringArray = new String[]{deviceProxy2.get_name(), "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            mSet.remove(deviceProxy2.get_name());
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeCoLocatedSources(String string) {
        return this.removeCoLocatedSources(string, true);
    }

    public int removeCoLocatedSources(String string, boolean bl) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{"*", "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            if (bl) {
                String string2 = deviceProxy.adm_name().substring(deviceProxy.adm_name().indexOf(47) + 1);
                LOG.debug((Object)("TangoLoggingReceiver::removeCoLocatedSources::server_name is " + string2));
                String[] stringArray2 = ApiUtil.get_db_obj().get_device_class_list(string2);
                for (int i = 0; i < stringArray2.length; i += 2) {
                    LOG.debug((Object)("TangoLoggingReceiver::removeCoLocatedSources::mSet removing " + stringArray2[i]));
                    mSet.remove(stringArray2[i]);
                }
                LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public boolean removeAllSources() {
        LOG.debug((Object)"Removing all logging sources");
        List<String> list = mSet.content();
        boolean bl = false;
        for (String string : list) {
            if (this.removeCoLocatedSources(string, false) != -1) continue;
            bl = true;
        }
        mSet.clear();
        return !bl;
    }

    public int getDeviceLoggingLevel(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            DeviceData deviceData2 = deviceProxy2.command_inout("GetLoggingLevel", deviceData);
            DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
            if (devVarLongStringArray.lvalue.length > 0) {
                return devVarLongStringArray.lvalue[0];
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int setDevicesLoggingLevel(String string, int n) {
        String[] stringArray;
        int n2 = 0;
        for (String string2 : stringArray = this.getDeviceList(string)) {
            if (this.setDeviceLoggingLevel(string2, n, false) != -1) continue;
            n2 = -1;
        }
        return n2;
    }

    public int setDeviceLoggingLevel(String string, int n, boolean bl) {
        try {
            DeviceData deviceData;
            String[] stringArray;
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            if (bl) {
                stringArray = new String[]{string, "device::" + this.deviceName};
                deviceData = new DeviceData();
                deviceData.insert(stringArray);
                deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            }
            stringArray = new DevVarLongStringArray();
            stringArray.lvalue = new int[1];
            stringArray.lvalue[0] = n;
            stringArray.svalue = new String[1];
            stringArray.svalue[0] = string;
            deviceData = new DeviceData();
            deviceData.insert((DevVarLongStringArray)stringArray);
            deviceProxy2.command_inout("SetLoggingLevel", deviceData);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int setCoLocatedDevicesLoggingLevel(String string, int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
            devVarLongStringArray.lvalue = new int[1];
            devVarLongStringArray.lvalue[0] = n;
            devVarLongStringArray.svalue = new String[1];
            devVarLongStringArray.svalue[0] = "*";
            DeviceData deviceData = new DeviceData();
            deviceData.insert(devVarLongStringArray);
            deviceProxy2.command_inout("SetLoggingLevel", deviceData);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public List<String> getLoggingSources() {
        return mSet.content();
    }

    protected void displayException(Exception exception) {
        LOG.error((Object)exception);
        Exception exception2 = exception instanceof DevFailed ? new ATKException((DevFailed)((Object)exception)) : exception;
        this.mHistoryArea.write(exception2);
    }

    public int setLoggingSourceProperty() {
        LOG.debug((Object)"Saving current logging source list into the TANGO database");
        List<String> list = mSet.content();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum(LOG_SRC_PROPERTY, stringArray)};
        try {
            ApiUtil.get_db_obj().put_device_property(this.deviceName, dbDatumArray);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int deleteLoggingSourceProperty() {
        try {
            ApiUtil.get_db_obj().delete_device_property(this.deviceName, LOG_SRC_PROPERTY);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int getLoggingSourceProperty() {
        try {
            DbDatum dbDatum = ApiUtil.get_db_obj().get_device_property(this.deviceName, LOG_SRC_PROPERTY);
            if (dbDatum.is_empty()) {
                LOG.debug((Object)"Restore sources::nothing to restore");
                return 0;
            }
            String[] stringArray = dbDatum.extractStringArray();
            LOG.debug((Object)("Restore sources::#source to add " + stringArray.length));
            for (String string : stringArray) {
                LOG.debug((Object)("Restore sources::adding " + string));
                this.addLoggingSource(string);
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public void cleanup() {
        int n;
        if (this.mRunningInStaticMode && mSet.size() != 0 && (n = JOptionPane.showConfirmDialog(null, "Save current source list before quitting?", "Tango LogViewer", 0)) == 0) {
            this.setLoggingSourceProperty();
        }
        this.removeAllSources();
        try {
            if (!this.mRunningInStaticMode) {
                String string = "LogConsumer/" + this.instanceName;
                LOG.debug((Object)("Deleting" + string + " server from the TANGO database"));
                ApiUtil.get_db_obj().delete_server(string);
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }
}

