/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.EventDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MyTableModel
extends AbstractTableModel {
    private static final double freeMemoryThreshold = 10.0;
    private static double lastFreeMemory = 0.0;
    private static final long nEventsThreshold = 50000L;
    private static final int filteredEventsUpdatedTimeThreshold = 100;
    private static final int pendingEventsThreshold = 4096;
    private static final double eventsPercent = 0.5;
    private static final Logger LOG = Logger.getLogger(MyTableModel.class);
    private static final String[] COL_NAMES = new String[]{"Trace", "Time", "Level", "Source", "Message"};
    private static final EventDetails[] EMPTY_LIST = new EventDetails[0];
    private final Object mLock = new Object();
    private final List<EventDetails> mAllEvents = new ArrayList<EventDetails>();
    private EventDetails[] mFilteredEvents = EMPTY_LIST;
    private final List<EventDetails> mPendingEvents = new ArrayList<EventDetails>();
    private boolean mPaused = false;
    private String mTimeStampFilter = "";
    private String mThreadFilter = "";
    private String mMessageFilter = "";
    private String mCategoryFilter = "";
    private Level mLevelFilter = Level.DEBUG;

    public MyTableModel() {
        Thread thread = new Thread(new Processor());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents.length;
        }
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COL_NAMES[n];
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            EventDetails eventDetails = this.mFilteredEvents[n];
            switch (n2) {
                case 0: {
                    return eventDetails.getThrowableStrRep() == null ? Boolean.FALSE : Boolean.TRUE;
                }
                case 1: {
                    return eventDetails.getRenderedTimeStamp();
                }
                case 2: {
                    return eventDetails.getLevel();
                }
                case 3: {
                    return eventDetails.getCategoryName();
                }
            }
            return eventDetails.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelFilter(Level level) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLevelFilter = level;
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mThreadFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMessageFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStampFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTimeStampFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCategoryFilter(String string) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCategoryFilter = string.trim();
            this.updateFilteredEvents(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventDetails eventDetails) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingEvents.add(eventDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAllEvents.clear();
            this.mFilteredEvents = new EventDetails[0];
            this.mPendingEvents.clear();
            this.fireTableDataChanged();
        }
    }

    public void clearOldEvents() {
        int n;
        int n2 = this.mAllEvents.size();
        LOG.debug((Object)("In clearOldEvents: #before:" + n2));
        int n3 = (int)((double)n2 * 0.5);
        if (n3 <= 0) {
            return;
        }
        LOG.debug((Object)("In clearOldEvents: #to-clear:" + n3));
        Iterator<EventDetails> iterator = this.mAllEvents.iterator();
        int n4 = n2 - n3;
        for (n = 0; n < n4 && iterator.hasNext(); ++n) {
            iterator.next();
        }
        for (n = 0; n < n3 && iterator.hasNext(); ++n) {
            EventDetails eventDetails = iterator.next();
            if (eventDetails.getLevel().isGreaterOrEqual((Priority)Level.WARN)) continue;
            iterator.remove();
        }
        LOG.debug((Object)("In clearOldEvents: #after:" + this.mAllEvents.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggle() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = !this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDetails getEventDetails(int n) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFilteredEvents[n];
        }
    }

    private long updateFilteredEvents(boolean bl) {
        int n;
        long l = System.currentTimeMillis();
        ArrayList<EventDetails> arrayList = new ArrayList<EventDetails>();
        for (EventDetails eventDetails : this.mAllEvents) {
            if (!this.matchFilter(eventDetails)) continue;
            arrayList.add(eventDetails);
        }
        Iterator<EventDetails> iterator = this.mFilteredEvents.length == 0 ? null : this.mFilteredEvents[0];
        this.mFilteredEvents = new EventDetails[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.mFilteredEvents[n] = (EventDetails)arrayList.get(n);
        }
        if (bl && iterator != null) {
            n = arrayList.indexOf(iterator);
            if (n < 1) {
                LOG.warn((Object)"In strange state");
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsInserted(0, n - 1);
            }
        } else {
            this.fireTableDataChanged();
        }
        long l2 = System.currentTimeMillis();
        LOG.debug((Object)("# logs: " + this.mAllEvents.size()));
        LOG.debug((Object)("Update time [ms]: " + (l2 - l)));
        return l2 - l;
    }

    private boolean matchFilter(EventDetails eventDetails) {
        if (eventDetails.getLevel().isGreaterOrEqual((Priority)this.mLevelFilter) && eventDetails.getCategoryName().contains(this.mCategoryFilter) && eventDetails.getRenderedTimeStamp().contains(this.mTimeStampFilter) && eventDetails.getThreadName().contains(this.mThreadFilter)) {
            String string = eventDetails.getMessage();
            if (string == null) {
                return this.mMessageFilter.length() == 0;
            }
            return string.contains(this.mMessageFilter);
        }
        return false;
    }

    static /* synthetic */ EventDetails[] access$602(MyTableModel myTableModel, EventDetails[] eventDetailsArray) {
        myTableModel.mFilteredEvents = eventDetailsArray;
        return eventDetailsArray;
    }

    private class Processor
    implements Runnable {
        private long lastUpdateTime = 0L;

        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = MyTableModel.this.mLock;
                synchronized (object) {
                    if (MyTableModel.this.mPaused && MyTableModel.this.mPendingEvents.size() < 4096) {
                        continue;
                    }
                    boolean bl = false;
                    Runtime runtime = Runtime.getRuntime();
                    double d = 100.0 * (double)runtime.freeMemory() / (double)runtime.totalMemory();
                    LOG.debug((Object)("Last free memory    [%]: " + lastFreeMemory));
                    LOG.debug((Object)("Current free memory [%]: " + d));
                    if (this.lastUpdateTime > 100L && (long)MyTableModel.this.mAllEvents.size() > 50000L || d - lastFreeMemory > 5.0 && d < 10.0) {
                        MyTableModel.this.clearOldEvents();
                        MyTableModel.access$602(MyTableModel.this, new EventDetails[0]);
                        Runtime.getRuntime().gc();
                        lastFreeMemory = 100.0 * (double)runtime.freeMemory() / (double)runtime.totalMemory();
                        bl = true;
                    } else {
                        lastFreeMemory = d;
                    }
                    Iterator iterator = MyTableModel.this.mPendingEvents.iterator();
                    boolean bl2 = true;
                    while (iterator.hasNext()) {
                        EventDetails eventDetails = (EventDetails)iterator.next();
                        MyTableModel.this.mAllEvents.add(eventDetails);
                        bl2 = bl2 && eventDetails == MyTableModel.this.mAllEvents.get(0);
                        bl = bl || MyTableModel.this.matchFilter(eventDetails);
                    }
                    MyTableModel.this.mPendingEvents.clear();
                    if (bl) {
                        Collections.sort(MyTableModel.this.mAllEvents, new EventComparator());
                        this.lastUpdateTime = MyTableModel.this.updateFilteredEvents(bl2);
                    }
                }
            }
        }
    }

    private class EventComparator
    implements Comparator<EventDetails> {
        private EventComparator() {
        }

        @Override
        public int compare(EventDetails eventDetails, EventDetails eventDetails2) {
            if (eventDetails == null && eventDetails2 == null) {
                return 0;
            }
            if (eventDetails == null) {
                return -1;
            }
            if (eventDetails2 == null) {
                return 1;
            }
            if (eventDetails.getTimeStamp() < eventDetails2.getTimeStamp()) {
                return 1;
            }
            return -1;
        }
    }
}

