/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import java.util.GregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetails {
    private final long mTimeStamp;
    private final String mTimeStampStr;
    private final Level mLevel;
    private final String mCategoryName;
    private final String mNDC;
    private final String mThreadName;
    private final String mMessage;
    private final String[] mThrowableStrRep;
    private final String mLocationDetails;

    public static String formatDate(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        int n = gregorianCalendar.get(5);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(1) - 2000;
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = gregorianCalendar.get(14);
        return String.format("%02d/%02d/%02d  %02d:%02d:%02d.%03d", n, n2, n3, n4, n5, n6, n7);
    }

    public EventDetails(long l, Level level, String string, String string2, String string3, String string4, String[] stringArray, String string5) {
        this.mTimeStamp = l;
        this.mTimeStampStr = EventDetails.formatDate(l);
        this.mLevel = level;
        this.mCategoryName = string;
        this.mNDC = string2;
        this.mThreadName = string3;
        this.mMessage = string4;
        this.mThrowableStrRep = stringArray;
        this.mLocationDetails = string5;
    }

    EventDetails(LoggingEvent loggingEvent) {
        this(loggingEvent.timeStamp, loggingEvent.getLevel(), loggingEvent.getLoggerName(), loggingEvent.getNDC(), loggingEvent.getThreadName(), loggingEvent.getRenderedMessage(), loggingEvent.getThrowableStrRep(), loggingEvent.getLocationInformation() == null ? null : loggingEvent.getLocationInformation().fullInfo);
    }

    long getTimeStamp() {
        return this.mTimeStamp;
    }

    String getRenderedTimeStamp() {
        return this.mTimeStampStr;
    }

    Level getLevel() {
        return this.mLevel;
    }

    String getCategoryName() {
        return this.mCategoryName;
    }

    String getNDC() {
        return this.mNDC;
    }

    String getThreadName() {
        return this.mThreadName;
    }

    String getMessage() {
        return this.mMessage;
    }

    String getLocationDetails() {
        return this.mLocationDetails;
    }

    String[] getThrowableStrRep() {
        return this.mThrowableStrRep;
    }
}

