/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.dev_panel;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JFrame;

public class DevPanel
extends DeviceProxy {
    private JFrame panel = null;
    private static Vector<JFrame> panels = new Vector();
    private static ExitThread thread = null;
    private static final String panelPackage = "fr.tango.tangopanels.classpanels";
    private static final int Shift = 20;
    private static int shift = 0;

    public DevPanel(String devname) throws DevFailed {
        super(devname);
        this.ping();
        System.out.println(devname + " is alive");
        String classname = this.get_class();
        System.out.println("Class:\t" + classname);
        this.buildTangoPanel(new DbClass(classname), devname);
    }

    public void buildTangoPanel(DbClass _class, String devname) throws DevFailed {
        DbDatum datum = _class.get_property("TangoPanel");
        if (datum.is_empty()) {
            this.panel = new MainPanel(devname, false, true);
        } else {
            String panel_name = datum.extractString();
            if (!panel_name.contains("tangopanels")) {
                panel_name = "fr.tango.tangopanels.classpanels." + panel_name;
            }
            try {
                this.panel = DevPanel.buildTangoPanel(panel_name, devname);
            }
            catch (Exception e) {
                Except.throw_exception((String)"CANNOT_BUILD_PANEL", (String)e.toString(), (String)"DevPanel.buildTangoPanel()");
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this.panel);
        Point p = this.panel.getLocation();
        p.x += shift;
        p.y += shift;
        shift += 20;
        this.panel.setLocation(p);
        panels.add(this.panel);
        if (thread == null) {
            thread = new ExitThread();
            thread.start();
        }
    }

    public static JFrame buildTangoPanel(String classname, String devname) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        System.out.println("Starting " + classname);
        Class<?> _class = Class.forName(classname);
        Class[] param = new Class[]{String.class};
        Constructor<?> constructor = _class.getConstructor(param);
        return (JFrame)constructor.newInstance(devname);
    }

    public static void main(String[] args) {
        int failed = 0;
        try {
            if (args.length == 0) {
                Except.throw_exception((String)"BAD_PARAM", (String)"Device name ?", (String)"DevPanel.DevPanel()");
            }
            for (String devname : args) {
                try {
                    new DevPanel(devname);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
                    ++failed;
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            System.exit(-1);
        }
        if (failed == args.length) {
            System.exit(-1);
        }
    }

    private class ExitThread
    extends Thread {
        private ExitThread() {
        }

        @Override
        public void run() {
            boolean exit = false;
            while (!exit) {
                exit = true;
                for (JFrame panel : panels) {
                    if (!panel.isVisible()) continue;
                    exit = false;
                }
                try {
                    ExitThread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            System.exit(0);
        }
    }
}

