/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import LogConsumer.LogConsumer;
import LogConsumer.SourceSet;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Util;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.tangoatk.core.ATKException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

class TangoLoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(TangoLoggingReceiver.class);
    final String mDYN_DEV_NAME_PREFIX = "tmp/log/";
    private String mServerName;
    private String mDevName;
    private final SourceSet mSet = SourceSet.instance();
    private boolean mRunningInStaticMode = false;
    private final String mLOG_SRC_PROPERTY = "logging_source";
    private HistoryArea mHistoryArea;
    private Util tg;

    TangoLoggingReceiver(String[] stringArray, MyTableModel myTableModel, HistoryArea historyArea) throws Exception {
        this.setDaemon(true);
        this.mHistoryArea = historyArea;
        try {
            String string;
            String string2;
            String[] stringArray2 = null;
            boolean bl = true;
            Random random = new Random(System.currentTimeMillis());
            String string3 = "@" + random.nextInt(128);
            if (stringArray.length == 0 || stringArray[0].indexOf("/") == -1) {
                LOG.debug((Object)"No instance name provided.");
                bl = false;
                String string4 = InetAddress.getLocalHost().getHostName();
                String[] stringArray3 = string4.split(".");
                if (stringArray3.length != 0) {
                    string4 = stringArray3[0];
                }
                string2 = string4 + string3;
                string = "tmp/log/" + string2;
            } else {
                LOG.debug((Object)("Provided device name: " + stringArray[0]));
                string = stringArray[0];
                int n = string.lastIndexOf(47);
                if (n == -1) {
                    LOG.fatal((Object)"Invalid device name specified. Quiting");
                    JOptionPane.showMessageDialog(null, "Invalid device name specified. Quiting", "Tango Log Viewer", 0);
                    System.exit(1);
                }
                string2 = string.substring(n + 1);
                this.mRunningInStaticMode = true;
            }
            this.mServerName = "logconsumer/" + string2;
            LOG.debug((Object)("Instance name is " + string2));
            LOG.debug((Object)("Server name is " + this.mServerName));
            LOG.debug((Object)("Device name is " + string));
            LOG.debug((Object)"Registering the LogConsumer into the database");
            DbDevInfo dbDevInfo = new DbDevInfo(string, "LogConsumer", this.mServerName);
            ApiUtil.get_db_obj().add_device(dbDevInfo);
            stringArray2 = bl ? new String[stringArray.length] : new String[stringArray.length + 1];
            stringArray2[0] = string2;
            int n = bl ? 1 : 0;
            int n2 = 1;
            while (n < stringArray.length) {
                stringArray2[n2] = stringArray[n];
                ++n;
                ++n2;
            }
            LOG.debug((Object)"Initializing the util singleton");
            LOG.debug((Object)"Passing following args to Util.init:");
            for (n = 0; n < stringArray2.length; ++n) {
                LOG.debug((Object)("\targs[" + String.valueOf(n) + "]: " + stringArray2[n]));
            }
            this.tg = Util.init((String[])stringArray2, (String)"LogConsumer");
            LOG.debug((Object)"Initializing the server");
            this.tg.server_init();
            Vector vector = this.tg.get_device_list_by_class("LogConsumer");
            ((LogConsumer)((Object)vector.elementAt(0))).setModel(myTableModel);
            this.mDevName = ((LogConsumer)((Object)vector.elementAt(0))).name();
            if (this.mRunningInStaticMode) {
                this.getLoggingSourceProperty();
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void setTableModel(MyTableModel myTableModel) {
        try {
            Vector vector = this.tg.get_device_list_by_class("LogConsumer");
            ((LogConsumer)((Object)vector.elementAt(0))).setModel(myTableModel);
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    public void setHistoryArea(HistoryArea historyArea) {
        this.mHistoryArea = historyArea;
    }

    public String getDeviceName() {
        return this.mDevName;
    }

    public boolean isRunningInStaticMode() {
        return this.mRunningInStaticMode;
    }

    public void run() {
        LOG.debug((Object)"Device thread started");
        try {
            LOG.info((Object)"Ready to accept request");
            Util.instance().server_run();
            LOG.debug((Object)"Device thread exiting");
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }

    private String[] getDeviceList(String string) {
        String[] stringArray = new String[]{};
        try {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetDeviceExportedList", deviceData);
            stringArray = deviceData2.extractStringArray();
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
        return stringArray;
    }

    public int addLoggingSources(String string) {
        int n = 0;
        String[] stringArray = this.getDeviceList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.addLoggingSource(stringArray[i]) != -1) continue;
            n = -1;
        }
        return n;
    }

    public int addColocatedSources(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{"*", "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            String string2 = deviceProxy.adm_name().substring(deviceProxy.adm_name().indexOf(47) + 1);
            LOG.debug((Object)("TangoLoggingReceiver::addColocatedSources::server_name is " + string2));
            String[] stringArray2 = ApiUtil.get_db_obj().get_device_class_list(string2);
            for (int i = 0; i < stringArray2.length; i += 2) {
                LOG.debug((Object)("TangoLoggingReceiver::addColocatedSources::mSet adding " + stringArray2[i]));
                this.mSet.add(stringArray2[i]);
            }
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int addLoggingSource(String string) {
        try {
            LOG.debug((Object)("Adding " + string + " to logging sources list"));
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string, "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            this.mSet.add(string);
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int addTangoCoreLogger(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            LOG.debug((Object)("Adding " + deviceProxy2.get_name() + " to logging sources list"));
            String[] stringArray = new String[]{deviceProxy2.get_name(), "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            this.mSet.add(string);
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeLoggingSources(String string) {
        int n = 0;
        String[] stringArray = this.getDeviceList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.removeLoggingSource(stringArray[i]) != -1) continue;
            n = -1;
        }
        return n;
    }

    public int removeLoggingSource(String string) {
        return this.removeLoggingSource(string, true);
    }

    private int removeLoggingSource(String string, boolean bl) {
        try {
            LOG.debug((Object)("Removing " + string + " from logging sources list"));
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string, "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            if (bl) {
                this.mSet.remove(string);
                LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeTangoCoreLogger(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            LOG.debug((Object)("Removing " + deviceProxy2.get_name() + " from logging sources list"));
            String[] stringArray = new String[]{deviceProxy2.get_name(), "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            this.mSet.remove(deviceProxy2.get_name());
            LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeColocatedSources(String string) {
        return this.removeColocatedSources(string, true);
    }

    public int removeColocatedSources(String string, boolean bl) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{"*", "device::" + this.mDevName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            deviceProxy2.command_inout("RemoveLoggingTarget", deviceData);
            if (bl) {
                String string2 = deviceProxy.adm_name().substring(deviceProxy.adm_name().indexOf(47) + 1);
                LOG.debug((Object)("TangoLoggingReceiver::removeColocatedSources::server_name is " + string2));
                String[] stringArray2 = ApiUtil.get_db_obj().get_device_class_list(string2);
                for (int i = 0; i < stringArray2.length; i += 2) {
                    LOG.debug((Object)("TangoLoggingReceiver::removeColocatedSources::mSet removing " + stringArray2[i]));
                    this.mSet.remove(stringArray2[i]);
                }
                LOG.debug((Object)("Logging sources set contains " + this.mSet.size() + " entries"));
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int removeAllSources() {
        LOG.debug((Object)"Removing all logging sources");
        String[] stringArray = this.mSet.content();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.removeColocatedSources(stringArray[i], false) != -1) continue;
            n = -1;
        }
        this.mSet.clear();
        return 0;
    }

    public int getDeviceLoggingLevel(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            String[] stringArray = new String[]{string};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(stringArray);
            DeviceData deviceData2 = deviceProxy2.command_inout("GetLoggingLevel", deviceData);
            DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
            if (devVarLongStringArray.lvalue.length > 0) {
                return devVarLongStringArray.lvalue[0];
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int setDevicesLoggingLevel(String string, int n) {
        int n2 = 0;
        String[] stringArray = this.getDeviceList(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.setDeviceLoggingLevel(stringArray[i], n, false) != -1) continue;
            n2 = -1;
        }
        return n2;
    }

    public int setDeviceLoggingLevel(String string, int n, boolean bl) {
        try {
            DeviceData deviceData;
            String[] stringArray;
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            if (bl) {
                stringArray = new String[]{string, "device::" + this.mDevName};
                deviceData = new DeviceData();
                deviceData.insert(stringArray);
                deviceProxy2.command_inout("AddLoggingTarget", deviceData);
            }
            stringArray = new DevVarLongStringArray();
            stringArray.lvalue = new int[1];
            stringArray.lvalue[0] = n;
            stringArray.svalue = new String[1];
            stringArray.svalue[0] = string;
            deviceData = new DeviceData();
            deviceData.insert((DevVarLongStringArray)stringArray);
            deviceProxy2.command_inout("SetLoggingLevel", deviceData);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int setColocatedDevicesLoggingLevel(String string, int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceProxy deviceProxy2 = new DeviceProxy(deviceProxy.adm_name());
            DevVarLongStringArray devVarLongStringArray = new DevVarLongStringArray();
            devVarLongStringArray.lvalue = new int[1];
            devVarLongStringArray.lvalue[0] = n;
            devVarLongStringArray.svalue = new String[1];
            devVarLongStringArray.svalue[0] = "*";
            DeviceData deviceData = new DeviceData();
            deviceData.insert(devVarLongStringArray);
            deviceProxy2.command_inout("SetLoggingLevel", deviceData);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public String[] getLoggingSources() {
        return this.mSet.content();
    }

    protected void displayException(Exception exception) {
        LOG.error((Object)exception);
        Exception exception2 = null;
        exception2 = exception instanceof DevFailed ? new ATKException((DevFailed)((Object)exception)) : exception;
        this.mHistoryArea.write(exception2);
    }

    public int setLoggingSourceProperty() {
        LOG.debug((Object)"Saving current logging source list into the TANGO database");
        String[] stringArray = new String[this.mSet.size()];
        int n = 0;
        Iterator iterator = this.mSet.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum("logging_source", stringArray)};
        try {
            ApiUtil.get_db_obj().put_device_property(this.mDevName, dbDatumArray);
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int deleteLoggingSourceProperty() {
        try {
            ApiUtil.get_db_obj().delete_device_property(this.mDevName, "logging_source");
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public int getLoggingSourceProperty() {
        try {
            DbDatum dbDatum = ApiUtil.get_db_obj().get_device_property(this.mDevName, "logging_source");
            if (dbDatum.is_empty()) {
                LOG.debug((Object)"Restore sources::nothing to restore");
                return 0;
            }
            String[] stringArray = dbDatum.extractStringArray();
            LOG.debug((Object)("Restore sources::#source to add " + stringArray.length));
            for (int i = 0; i < stringArray.length; ++i) {
                LOG.debug((Object)("Restore sources::adding " + stringArray[i]));
                this.addLoggingSource(stringArray[i]);
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
            return -1;
        }
        return 0;
    }

    public void cleanup() {
        int n;
        if (this.mRunningInStaticMode && this.mSet.size() != 0 && (n = JOptionPane.showConfirmDialog(null, "Save current source list before quitting?", "Tango LogViewer", 0)) == 0) {
            this.setLoggingSourceProperty();
        }
        this.removeAllSources();
        try {
            if (!this.mRunningInStaticMode) {
                LOG.debug((Object)"Deleting server from the TANGO database");
                ApiUtil.get_db_obj().delete_server(Util.instance().get_ds_name());
            }
        }
        catch (Exception exception) {
            this.displayException(exception);
        }
    }
}

