/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

class TableConfig
extends Vector {
    String title = "ATK Table Panel";
    String[] colnames = new String[0];
    String[] rownames = new String[0];
    int period = 1000;
    int height = -1;
    int width = -1;
    private String code;
    private int[] colwidth;
    private int row_titlewidth = 80;
    private static final String[] title_path = new String[]{"atktable"};
    private static final String[] col_path = new String[]{"atktable", "columns"};
    private static final String[] rows_path = new String[]{"atktable", "rows"};
    private static final String[] att_path = new String[]{"atktable", "attributes"};
    private static final String[] period_path = new String[]{"atktable"};
    private static final String[] size_path = new String[]{"atktable", "size"};
    private static final String title_tag = "title";
    private static final String name_tag = "name";
    private static final String period_tag = "period";
    private static final String line_tag = "line";
    private static final String width_tag = "width";
    private static final String height_tag = "height";
    private static final String title_width_tag = "title_width";

    public TableConfig() {
    }

    public TableConfig(String title, int nbrows, int nbcol) {
        int i;
        if (title != null) {
            this.title = title;
        }
        this.rownames = new String[nbrows];
        for (i = 0; i < nbrows; ++i) {
            this.rownames[i] = "Row " + (i + 1);
        }
        this.colnames = new String[nbcol];
        for (i = 0; i < nbcol; ++i) {
            this.colnames[i] = "Column " + (i + 1);
        }
        for (int row = 0; row < nbrows; ++row) {
            for (int col = 0; col < nbcol; ++col) {
                this.add(null, row, col);
            }
        }
    }

    public TableConfig(String[] rownames, String[] colnames, String[][] attnames) {
        this.rownames = rownames;
        this.colnames = colnames;
        for (int row = 0; row < rownames.length; ++row) {
            for (int col = 0; col < colnames.length; ++col) {
                this.add(attnames[row][col], row, col);
            }
        }
    }

    public TableConfig(String name, int src) throws Exception {
        if (src == 1) {
            int i;
            String devname = name;
            DeviceProxy dev = new DeviceProxy(devname);
            this.colnames = new String[1];
            this.colnames[0] = devname;
            AttributeInfo[] info = dev.get_attribute_info();
            Vector<AttributeInfo> v = new Vector<AttributeInfo>();
            for (i = 0; i < info.length; ++i) {
                if (info[i].data_format != AttrDataFormat.SCALAR) continue;
                v.add(info[i]);
            }
            this.rownames = new String[v.size()];
            for (i = 0; i < v.size(); ++i) {
                AttributeInfo attinfo = (AttributeInfo)v.get(i);
                this.rownames[i] = attinfo.label;
                this.add(devname + "/" + attinfo.name, i, 0);
            }
        } else if (src == 0) {
            String filename = name;
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            if ((nb = fid.read(inStr)) >= 0) {
                this.code = new String(inStr);
            }
            System.out.println(filename + " read.");
            this.checkHeader(this.code);
            this.parseTitle();
            this.parseColumnNames();
            this.parseColumnWidth();
            this.parseRowNames();
            this.parseAttributeNames();
            this.parsePeriod();
            this.parseSize();
        }
    }

    public void save(String filename) throws FileNotFoundException, SecurityException, IOException {
        String code = this.getXmlCode();
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(code.getBytes());
        fidout.close();
    }

    void checkSize(JTable table) {
        if (this.colwidth != null) {
            TableColumn tc;
            Enumeration<TableColumn> cenum = table.getColumnModel().getColumns();
            this.width = 0;
            if (cenum.hasMoreElements()) {
                tc = cenum.nextElement();
                tc.setPreferredWidth(this.row_titlewidth);
                this.width += this.row_titlewidth;
            }
            for (int i = 0; cenum.hasMoreElements() && i < this.colwidth.length; ++i) {
                tc = cenum.nextElement();
                if (this.colwidth[i] == 0) {
                    this.colwidth[i] = 80;
                }
                tc.setPreferredWidth(this.colwidth[i]);
                this.width += this.colwidth[i];
            }
        } else if (this.width < 0) {
            this.width = (this.nbColumns() + 1) * 180;
        }
        int h = table.getRowHeight() + 3;
        if (this.height < 0) {
            this.height = this.nbRows() * h + 10;
        }
    }

    void setColWidth(int title_width, int[] col_width) {
        this.row_titlewidth = title_width;
        this.colwidth = col_width;
    }

    int nbRows() {
        return this.rownames.length;
    }

    int nbColumns() {
        return this.colnames.length;
    }

    public Attribute attributeAt(int row, int col) {
        for (int i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.row != row || att.col != col) continue;
            return att;
        }
        return null;
    }

    public Attribute attributeAt(int idx) {
        return (Attribute)this.get(idx);
    }

    public Attribute attributeNamed(String name) {
        for (int i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.name == null || !att.name.equals(name)) continue;
            return att;
        }
        return null;
    }

    String getAttributeNameAt(int row, int col) {
        Attribute att = this.attributeAt(row, col);
        if (att == null) {
            return "";
        }
        return att.name;
    }

    void setAttributeNameAt(String name, int row, int col) {
        Attribute att = this.attributeAt(row, col);
        if (att != null) {
            this.remove(att);
        }
        this.add(name, row, col);
    }

    public boolean add(String name, int row, int col) {
        return super.add(new Attribute(name, row, col));
    }

    public void setError(String attname, boolean b) {
        Attribute att;
        if (attname != null && (att = this.attributeNamed(attname)) != null) {
            att.on_error = b;
        }
    }

    public boolean onError() {
        for (int i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.name == null || !att.on_error) continue;
            return true;
        }
        return false;
    }

    public boolean allConnected() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.attributeAt((int)i).connected) continue;
            return false;
        }
        return true;
    }

    public void deleteRow(int sel_row) {
        int i;
        String[] tmp = new String[this.rownames.length - 1];
        int j = 0;
        for (i = 0; i < this.rownames.length; ++i) {
            if (i == sel_row) continue;
            tmp[j++] = this.rownames[i];
        }
        this.rownames = tmp;
        for (i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.row == sel_row) {
                this.remove(att);
                --i;
                continue;
            }
            if (att.row <= sel_row) continue;
            --att.row;
        }
    }

    public void deleteColumn(int sel_col) {
        int i;
        String[] tmp = new String[this.colnames.length - 1];
        int j = 0;
        for (i = 0; i < this.colnames.length; ++i) {
            if (i == sel_col) continue;
            tmp[j++] = this.colnames[i];
        }
        this.colnames = tmp;
        for (i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.col == sel_col) {
                this.remove(att);
                --i;
                continue;
            }
            if (att.col <= sel_col) continue;
            --att.col;
        }
    }

    public void addRow() {
        String[] tmp = new String[this.rownames.length + 1];
        for (int i = 0; i < this.rownames.length; ++i) {
            tmp[i] = this.rownames[i];
        }
        tmp[this.rownames.length] = "Row " + (this.rownames.length + 1);
        this.rownames = tmp;
        int row = this.rownames.length - 1;
        for (int col = 0; col < this.colnames.length; ++col) {
            this.add(null, row, col);
        }
    }

    public void addColumn() {
        String[] tmp = new String[this.colnames.length + 1];
        for (int i = 0; i < this.colnames.length; ++i) {
            tmp[i] = this.colnames[i];
        }
        tmp[this.colnames.length] = "Column " + (this.colnames.length + 1);
        this.colnames = tmp;
        int col = this.colnames.length - 1;
        for (int row = 0; row < this.rownames.length; ++row) {
            this.add(null, row, col);
        }
    }

    public void resetConnection() {
        for (int i = 0; i < this.size(); ++i) {
            this.attributeAt((int)i).connected = false;
        }
    }

    public String toString() {
        int i;
        String str = this.title + "\n";
        str = str + "Rows:\n";
        for (i = 0; i < this.rownames.length; ++i) {
            str = str + "\t" + this.rownames[i] + "\n";
        }
        str = str + "Columans:\n";
        for (i = 0; i < this.colnames.length; ++i) {
            str = str + "\t" + this.colnames[i] + "\n";
        }
        str = str + "\nAttributes:\n";
        for (int row = 0; row < this.rownames.length; ++row) {
            str = str + "------------------\n";
            for (int col = 0; col < this.colnames.length; ++col) {
                str = str + "\t" + this.getAttributeNameAt(row, col) + "\n";
            }
        }
        str = str + "Period:\t" + this.period + "\n";
        str = str + "Size:\t" + this.width + " x " + this.height + "\n";
        return str;
    }

    private String xmlColumns() {
        StringBuffer sb = new StringBuffer("\t" + this.tagIn(col_path[1]) + "\n");
        for (int i = 0; i < this.colnames.length; ++i) {
            sb.append("\t\t" + this.tagIn(title_tag) + " ");
            sb.append(this.colnames[i] + " " + this.tagOut(title_tag) + "\n");
            sb.append("\t\t" + this.tagIn(width_tag) + " ");
            sb.append(this.colwidth[i] + " " + this.tagOut(width_tag) + "\n");
        }
        sb.append("\t" + this.tagOut(col_path[1]) + "\n");
        return sb.toString();
    }

    private String xmlRows() {
        StringBuffer sb = new StringBuffer("\t" + this.tagIn(rows_path[1]) + "\n");
        for (int i = 0; i < this.rownames.length; ++i) {
            sb.append("\t\t" + this.tagIn(title_tag) + " ");
            sb.append(this.rownames[i] + " " + this.tagOut(title_tag) + "\n");
        }
        sb.append("\t\t" + this.tagIn(title_width_tag) + " ");
        sb.append(this.row_titlewidth + " " + this.tagOut(title_width_tag) + "\n");
        sb.append("\t" + this.tagOut(rows_path[1]) + "\n");
        return sb.toString();
    }

    private String xmlAttributesAt(int row) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.size(); ++i) {
            Attribute att = this.attributeAt(i);
            if (att.row != row) continue;
            sb.append("\t\t\t" + this.tagIn(name_tag) + " ");
            if (att.name != null) {
                sb.append(att.name);
            }
            sb.append(" " + this.tagOut(name_tag) + "\n");
        }
        return sb.toString();
    }

    private String xmlAttributes() {
        StringBuffer sb = new StringBuffer("\n\t<!-- Attributes definition -->\n");
        sb.append("\t" + this.tagIn(att_path[1]) + "\n");
        for (int row = 0; row < this.rownames.length; ++row) {
            sb.append("\t\t" + this.tagIn(line_tag) + "\n");
            sb.append(this.xmlAttributesAt(row));
            sb.append("\t\t" + this.tagOut(line_tag) + "\n");
        }
        sb.append("\t" + this.tagOut(att_path[1]) + "\n");
        return sb.toString();
    }

    private String xmlPeriod() {
        StringBuffer sb = new StringBuffer("\n\t<!-- Refreshing period in milliseconds -->\n");
        sb.append("\t" + this.tagIn(period_tag) + " " + this.period);
        sb.append(" " + this.tagOut(period_tag) + "\n");
        return sb.toString();
    }

    private String xmlSize() {
        StringBuffer sb = new StringBuffer("\n\t<!-- Viewer size -->\n");
        sb.append("\t" + this.tagIn(size_path[1]) + "\n");
        sb.append("\t\t" + this.tagIn(width_tag) + " " + this.width + " " + this.tagOut(width_tag) + "\n");
        sb.append("\t\t" + this.tagIn(height_tag) + " " + this.height + " " + this.tagOut(height_tag) + "\n");
        sb.append("\t" + this.tagOut(size_path[1]) + "\n");
        return sb.toString();
    }

    public String getXmlCode() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>");
        sb.append("\n\n");
        sb.append(this.tagIn("atktable") + "\n");
        sb.append("\t" + this.tagIn(title_tag) + " ");
        sb.append(this.title + " " + this.tagOut(title_tag) + "\n");
        sb.append(this.xmlRows());
        sb.append(this.xmlColumns());
        sb.append(this.xmlAttributes());
        sb.append(this.xmlPeriod());
        sb.append(this.xmlSize());
        sb.append(this.tagOut("atktable") + "\n");
        return sb.toString();
    }

    private String[] getItems(String str, String tag) {
        int idx = 0;
        Vector<String> v = new Vector<String>();
        while ((idx = str.indexOf(this.tagIn(tag), idx)) >= 0) {
            String item = this.getInTags(str, tag, idx);
            if (item == null) continue;
            idx += tag.length();
            if (item.length() == 0) {
                item = null;
            }
            v.add(item);
        }
        String[] items = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            items[i] = (String)v.get(i);
        }
        return items;
    }

    private String[] parseCodeFor(String[] tags, String tag) {
        String str = this.code;
        for (int i = 0; i < tags.length; ++i) {
            str = this.getInTags(str, tags[i]);
        }
        return this.getItems(str, tag);
    }

    private String getInTags(String str, String t) {
        return this.getInTags(str, t, 0);
    }

    private String getInTags(String str, String t, int idx) {
        String t1 = this.tagIn(t);
        String t2 = this.tagOut(t);
        int start = str.indexOf(t1, idx);
        if (start < 0) {
            return null;
        }
        int end = str.indexOf(t2, start);
        if (end < 0) {
            return null;
        }
        return str.substring(start += t1.length(), end).trim();
    }

    private String tagIn(String tag) {
        return "<" + tag + ">";
    }

    private String tagOut(String tag) {
        return "</" + tag + ">";
    }

    private void checkHeader(String code) throws Exception {
        if (code.indexOf("<?xml ") < 0) {
            throw new Exception("Not an XML file !");
        }
        if (code.indexOf(this.tagIn("atktable")) < 0 || code.indexOf(this.tagOut("atktable")) < 0) {
            throw new Exception("File is not for this application !");
        }
    }

    private void parseAttributeNames() {
        String[] lines = this.parseCodeFor(att_path, line_tag);
        for (int row = 0; row < lines.length; ++row) {
            String[] attnames = this.getItems(lines[row], name_tag);
            for (int col = 0; col < attnames.length; ++col) {
                this.add(attnames[col], row, col);
            }
        }
    }

    private void parseTitle() {
        String[] tmp = this.parseCodeFor(title_path, title_tag);
        if (tmp != null && tmp.length > 0) {
            this.title = tmp[0];
        }
    }

    private void parseColumnNames() {
        this.colnames = this.parseCodeFor(col_path, title_tag);
    }

    private void parseColumnWidth() {
        this.colwidth = new int[this.colnames.length];
        String[] str = this.parseCodeFor(col_path, width_tag);
        for (int i = 0; i < str.length && i < this.colnames.length; ++i) {
            try {
                this.colwidth[i] = Integer.parseInt(str[i]);
                continue;
            }
            catch (NumberFormatException e) {
                this.colwidth = null;
            }
        }
        str = this.parseCodeFor(rows_path, title_width_tag);
        if (str.length > 0) {
            try {
                this.row_titlewidth = Integer.parseInt(str[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseRowNames() {
        this.rownames = this.parseCodeFor(rows_path, title_tag);
    }

    private int parseInt(String[] path, String tag) throws Exception {
        String[] s = this.parseCodeFor(path, tag);
        if (s != null && s.length > 0) {
            return Integer.parseInt(s[0]);
        }
        throw new Exception("Not found");
    }

    private void parsePeriod() {
        try {
            this.period = this.parseInt(period_path, period_tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseSize() {
        try {
            this.width = this.parseInt(size_path, width_tag);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.height = this.parseInt(size_path, height_tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class Attribute {
        String name;
        int row;
        int col;
        boolean connected = false;
        boolean on_error = true;

        public Attribute(String name, int row, int col) {
            this.name = name;
            this.row = row;
            this.col = col;
        }

        public String toString() {
            return this.name;
        }
    }
}

