/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StringScalarEvent;
import fr.esrf.tangoatk.widget.attribute.MultiScalarTableViewer;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import tool_panels.atktable.TableConfig;
import tool_panels.atktable.TablePopupMenu;
import tool_panels.atktable.TableScalarViewer;

class ScrolledScalarViewer
extends JScrollPane
implements IErrorListener,
INumberScalarListener,
IStringScalarListener,
IBooleanScalarListener,
IEnumScalarListener {
    TableScalarViewer parent;
    TableConfig config;
    AttributeList attlist;
    MultiScalarTableViewer table;
    TablePopupMenu menu;
    ErrorHistory err_history;
    boolean on_error = false;
    private ScrolledScalarViewer this_viewer;

    public ScrolledScalarViewer(TableScalarViewer parent) {
        this.parent = parent;
        this.this_viewer = this;
        this.config = new TableConfig();
        this.err_history = new ErrorHistory();
        this.table = new MultiScalarTableViewer();
        this.table.setFont(new Font("Dialog", 1, 14));
        this.attlist = new AttributeList();
        this.attlist.addErrorListener((IErrorListener)this.err_history);
        this.attlist.addErrorListener((IErrorListener)this);
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScrolledScalarViewer.this.headerActionPerformed(evt);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ScrolledScalarViewer.this.tableActionPerformed(evt);
            }
        });
        this.menu = new TablePopupMenu(parent, (JTable)this.table);
    }

    public void setTableFont(Font font) {
        this.table.setFont(font);
    }

    public ScrolledScalarViewer(TableScalarViewer parent, TableConfig config) {
        this(parent);
        this.initializeViewer(config);
    }

    void resetTable() {
        this.table.clearModel();
        this.config.resetConnection();
        this.attlist.removeAllElements();
        this.attlist.stopRefresher();
    }

    void initializeViewer(TableConfig config) {
        this.resetTable();
        this.config = config;
        this.table.setNbColumns(config.colnames.length);
        this.table.setNbRows(config.rownames.length);
        this.table.setColumnIdents(config.colnames);
        this.table.setRowIdents(config.rownames);
        if (config.period > 1000) {
            this.attlist.setRefreshInterval(config.period);
        } else {
            this.attlist.setRefreshInterval(1000);
        }
        this.attlist.startRefresher();
        config.checkSize((JTable)this.table);
        Dimension d = new Dimension(config.width, config.height);
        this.table.setPreferredScrollableViewportSize(d);
        this.setViewportView((Component)this.table);
        new AddAttr().start();
    }

    void updateRows(int row, String name) {
        this.config.rownames[row] = name;
        this.table.getModel().setValueAt(name, row, 0);
        this.table.repaint();
    }

    void updateColumns(int col, String name) {
        this.config.colnames[col - 1] = name;
        this.table.getTableHeader().getColumnModel().getColumn(col).setHeaderValue(name);
        this.table.repaint();
        this.repaint();
    }

    void changeAttributeAt(int row, int col, String attname) {
        TableConfig.Attribute att = this.config.attributeAt(row, col);
        if (att != null) {
            this.config.remove(att);
        }
        if (attname != null) {
            this.config.add(attname, row, col);
            this.config.setAttributeNameAt(attname, row, col);
        }
        this.table.repaint();
    }

    private void tableActionPerformed(MouseEvent evt) {
        if (!this.parent.isEditable()) {
            return;
        }
        int mask = evt.getModifiers();
        if ((mask & 4) != 0) {
            int col = this.table.columnAtPoint(new Point(evt.getX(), evt.getY()));
            int row = this.table.rowAtPoint(new Point(evt.getX(), evt.getY()));
            if (col == 0) {
                this.menu.showMenu(evt, row, col, this.config.rownames[row]);
            } else {
                String attname = this.config.getAttributeNameAt(row, col - 1);
                if (attname != null) {
                    this.menu.showMenu(evt, row, col, attname);
                } else {
                    this.menu.showMenu(evt, row, col, "No Attribute defined");
                }
            }
        }
    }

    private void headerActionPerformed(MouseEvent evt) {
        int col;
        if (!this.parent.isEditable()) {
            return;
        }
        int mask = evt.getModifiers();
        if ((mask & 4) != 0 && (col = this.table.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY()))) > 0) {
            this.menu.showMenu(evt, col, this.config.colnames[col - 1]);
        }
    }

    public void updateConfigSize() {
        Dimension d = this.getViewport().getViewSize();
        this.config.width = d.width;
        this.config.height = d.height;
        int title_width = 80;
        int[] col_width = new int[this.config.colnames.length];
        Enumeration<TableColumn> cenum = this.table.getColumnModel().getColumns();
        if (cenum.hasMoreElements()) {
            title_width = cenum.nextElement().getPreferredWidth();
        }
        int i = 0;
        while (cenum.hasMoreElements()) {
            col_width[i] = cenum.nextElement().getPreferredWidth();
            ++i;
        }
        this.config.setColWidth(title_width, col_width);
    }

    void setColWidth(int title_width, int[] col_width) {
        TableColumn tc;
        Enumeration<TableColumn> cenum = this.table.getColumnModel().getColumns();
        if (cenum.hasMoreElements()) {
            tc = cenum.nextElement();
            tc.setPreferredWidth(title_width);
        }
        for (int i = 0; cenum.hasMoreElements() && i < col_width.length; ++i) {
            tc = cenum.nextElement();
            if (col_width[i] == 0) {
                col_width[i] = 80;
            }
            tc.setPreferredWidth(col_width[i]);
        }
    }

    public void errorChange(ErrorEvent evt) {
        this.config.setError(evt.getSource().toString(), true);
        if (!this.on_error) {
            this.on_error = true;
            this.parent.errorChanged(this.on_error);
            new EndErrorCheck().start();
        }
    }

    public void stringScalarChange(StringScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void enumScalarChange(EnumScalarEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    public void stateChange(AttributeStateEvent evt) {
        if (this.on_error) {
            this.config.setError(evt.getSource().toString(), false);
        }
    }

    class AddAttr
    extends Thread {
        AddAttr() {
        }

        private boolean connectAttribute(TableConfig.Attribute att) {
            if (att.name == null) {
                att.connected = true;
                return false;
            }
            try {
                IAttribute iatt = (IAttribute)ScrolledScalarViewer.this.attlist.add(att.name);
                if (iatt instanceof INumberScalar) {
                    ((INumberScalar)iatt).addNumberScalarListener((INumberScalarListener)ScrolledScalarViewer.this.this_viewer);
                } else if (iatt instanceof IStringScalar) {
                    ((IStringScalar)iatt).addStringScalarListener((IStringScalarListener)ScrolledScalarViewer.this.this_viewer);
                } else if (iatt instanceof IEnumScalar) {
                    ((IEnumScalar)iatt).addEnumScalarListener((IEnumScalarListener)ScrolledScalarViewer.this.this_viewer);
                } else if (iatt instanceof IBooleanScalar) {
                    ((IBooleanScalar)iatt).addBooleanScalarListener((IBooleanScalarListener)ScrolledScalarViewer.this.this_viewer);
                } else {
                    System.out.println(att.name + "  Not Supported Type !!");
                }
                ScrolledScalarViewer.this.table.setModelAt(iatt, att.row, att.col);
                att.connected = true;
                return true;
            }
            catch (Exception e) {
                att.connected = false;
                return false;
            }
        }

        public void run() {
            boolean one_connected = false;
            boolean resize_done = false;
            while (true) {
                for (int i = 0; i < ScrolledScalarViewer.this.config.size(); ++i) {
                    TableConfig.Attribute att = ScrolledScalarViewer.this.config.attributeAt(i);
                    if (att.connected || !this.connectAttribute(att)) continue;
                    one_connected = true;
                }
                try {
                    AddAttr.sleep(2000L);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    class EndErrorCheck
    extends Thread {
        public void run() {
            boolean end = false;
            while (!end) {
                if (!ScrolledScalarViewer.this.config.onError()) {
                    ScrolledScalarViewer.this.on_error = false;
                    ScrolledScalarViewer.this.parent.errorChanged(ScrolledScalarViewer.this.on_error);
                    end = true;
                    continue;
                }
                try {
                    EndErrorCheck.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

