/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import com.sun.opengl.util.BufferUtil;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DView;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class Utils {
    private static Class theClass = null;
    private static Insets bMargin = new Insets(3, 3, 3, 3);
    static final Color fColor = new Color(99, 97, 156);
    static final Insets zInset = new Insets(0, 0, 0, 0);
    static final Font labelFont = new Font("Dialog", 0, 12);
    static final Font labelbFont = new Font("Dialog", 1, 12);

    private static void init() {
        if (theClass == null) {
            String string = "fr.esrf.tangoatk.widget.util.jgl3dchart.Utils";
            try {
                theClass = Class.forName(string);
            }
            catch (Exception exception) {
                System.out.println("Utils.init() Class not found: " + string);
            }
        }
    }

    static VERTEX3D Cross(VERTEX3D vERTEX3D, VERTEX3D vERTEX3D2) {
        VERTEX3D vERTEX3D3 = new VERTEX3D();
        vERTEX3D3.x = vERTEX3D.y * vERTEX3D2.z - vERTEX3D.z * vERTEX3D2.y;
        vERTEX3D3.y = vERTEX3D.z * vERTEX3D2.x - vERTEX3D.x * vERTEX3D2.z;
        vERTEX3D3.z = vERTEX3D.x * vERTEX3D2.y - vERTEX3D.y * vERTEX3D2.x;
        return vERTEX3D3;
    }

    static ByteBuffer convertImageToTexture(BufferedImage bufferedImage, boolean bl) {
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException();
        }
        int n = bl ? 4 : 3;
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(nArray.length * n));
        for (int i = bufferedImage.getHeight() - 1; i >= 0; --i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n2 = nArray[i * bufferedImage.getWidth() + j];
                byteBuffer.put((byte)(n2 >> 16 & 0xFF));
                byteBuffer.put((byte)(n2 >> 8 & 0xFF));
                byteBuffer.put((byte)(n2 >> 0 & 0xFF));
                if (!bl) continue;
                byteBuffer.put((byte)(n2 >> 24 & 0xFF));
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    static double RoundAngle(double d) {
        double d2;
        for (d2 = d; d2 < -Math.PI; d2 += Math.PI * 2) {
        }
        while (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        return d2;
    }

    static double ToDeg(double d) {
        return d / Math.PI * 180.0;
    }

    public static void project(GL gL, double d, double d2, double d3, double[] dArray) {
        int[] nArray = new int[4];
        double[] dArray2 = new double[16];
        double[] dArray3 = new double[16];
        double[] dArray4 = new double[4];
        gL.glGetIntegerv(2978, nArray, 0);
        gL.glGetDoublev(2982, dArray2, 0);
        gL.glGetDoublev(2983, dArray3, 0);
        JGL3DView.glu.gluProject(d, d2, d3, dArray2, 0, dArray3, 0, nArray, 0, dArray4, 0);
        dArray[0] = dArray4[0];
        dArray[1] = (double)nArray[3] - dArray4[1] - 1.0;
    }

    public static void unproject(GL gL, double d, double d2, double d3, double[] dArray) {
        int[] nArray = new int[4];
        double[] dArray2 = new double[16];
        double[] dArray3 = new double[16];
        double[] dArray4 = new double[4];
        gL.glGetIntegerv(2978, nArray, 0);
        gL.glGetDoublev(2982, dArray2, 0);
        gL.glGetDoublev(2983, dArray3, 0);
        double d4 = nArray[3] - (int)d2 - 1;
        JGL3DView.glu.gluUnProject(d, d4, d3, dArray2, 0, dArray3, 0, nArray, 0, dArray4, 0);
        dArray[0] = dArray4[0];
        dArray[1] = dArray4[1];
        dArray[2] = dArray4[2];
    }

    public static void project3D(GL gL, double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = new double[16];
        gL.glGetDoublev(2982, dArray2, 0);
        dArray[0] = d * dArray2[0] + d2 * dArray2[4] + d3 * dArray2[8] + dArray2[12];
        dArray[1] = d * dArray2[1] + d2 * dArray2[5] + d3 * dArray2[9] + dArray2[13];
        dArray[2] = d * dArray2[2] + d2 * dArray2[6] + d3 * dArray2[10] + dArray2[14];
    }

    public static JButton createIconButton(String string, boolean bl, String string2, ActionListener actionListener) {
        Utils.init();
        if (theClass != null) {
            JButton jButton = new JButton(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + string + ".gif")));
            jButton.setPressedIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + string + "_push.gif")));
            if (bl) {
                jButton.setDisabledIcon(new ImageIcon(theClass.getResource("/fr/esrf/tangoatk/widget/util/jgl3dchart/gif/" + string + "_disa.gif")));
            }
            jButton.setToolTipText(string2);
            jButton.setMargin(bMargin);
            jButton.setBorder(null);
            jButton.addActionListener(actionListener);
            return jButton;
        }
        return new JButton(string);
    }

    public static Border createTitleBorder(String string) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string, 1, 0, labelbFont, fColor);
    }
}

