/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.MultiLineCellRenderer;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

class MultiLineCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    MyTextArea textArea;
    JTable table;

    public MultiLineCellEditor(JTable jTable) {
        this.table = jTable;
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
        this.table.setDefaultRenderer(String.class, multiLineCellRenderer);
        this.textArea = new MyTextArea();
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        this.textArea.setBorder(MultiLineCellRenderer.selBorder);
    }

    private int cellHeight(int n, int n2) {
        if (n == this.table.getEditingRow() && n2 == this.table.getEditingColumn()) {
            return this.textArea.getPreferredSize().height;
        }
        return this.table.getDefaultRenderer(String.class).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getModel().getValueAt((int)n, (int)n2), (boolean)false, (boolean)false, (int)n, (int)n2).getPreferredSize().height;
    }

    void updateRows() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    void updateRow(int n) {
        int n2 = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int n3 = this.cellHeight(n, i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.table.setRowHeight(n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.textArea.rowEditing = n;
        this.textArea.columnEditing = n2;
        this.textArea.setEditable(true);
        this.textArea.ingoreChange = true;
        this.textArea.setText(jTable.getValueAt(n, n2).toString());
        this.textArea.ingoreChange = false;
        return this.textArea;
    }

    class MyTextArea
    extends JTextArea
    implements DocumentListener {
        boolean ingoreChange = true;
        int rowEditing;
        int columnEditing;

        MyTextArea() {
            this.getDocument().addDocumentListener(this);
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    MyTextArea.this.requestFocus();
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }
            });
        }

        public void updateField() {
            if (!this.ingoreChange) {
                MultiLineCellEditor.this.table.setValueAt(this.getText(), this.rowEditing, this.columnEditing);
                MultiLineCellEditor.this.updateRow(this.rowEditing);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateField();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateField();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

