/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;

public class JDSpline
extends JDPolyline
implements JDPolyConvert {
    public JDSpline(String string, Point[] pointArray) {
        this.initDefault();
        this.summit = new Point2D.Double[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            this.summit[i] = new Point2D.Double(pointArray[i].x, pointArray[i].y);
        }
        this.step = 10;
        this.name = string;
        this.updateShape();
        Point2D.Double double_ = new Point2D.Double(this.boundRect.x + this.boundRect.width / 2, this.boundRect.y + this.boundRect.height / 2);
        this.setOrigin(double_);
    }

    JDSpline(JDSpline jDSpline, int n, int n2) {
        this.cloneObject(jDSpline, n, n2);
        this.isClosed = jDSpline.isClosed;
        this.step = jDSpline.step;
        this.updateShape();
    }

    JDSpline(JLXObject jLXObject, JLXPath jLXPath) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        int n = (jLXPath.path.size() - 1) * 3 + 1;
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[n];
        this.createSummit();
        int n2 = 0;
        for (int i = 0; i < jLXPath.path.size(); ++i) {
            double[] dArray = (double[])jLXPath.path.get(i);
            if (i == 0) {
                this.summit[n2].x = this.origin.x + dArray[0];
                this.summit[n2].y = this.origin.y + dArray[1];
                ++n2;
                continue;
            }
            if (jLXPath.pathType == 2) {
                this.summit[n2].x = this.origin.x + dArray[0];
                this.summit[n2].y = this.origin.y + dArray[1];
                this.summit[n2 + 1].x = this.origin.x + dArray[0];
                this.summit[n2 + 1].y = this.origin.y + dArray[1];
                this.summit[n2 + 2].x = this.origin.x + dArray[2];
                this.summit[n2 + 2].y = this.origin.y + dArray[3];
            } else {
                this.summit[n2].x = this.origin.x + dArray[0];
                this.summit[n2].y = this.origin.y + dArray[1];
                this.summit[n2 + 1].x = this.origin.x + dArray[2];
                this.summit[n2 + 1].y = this.origin.y + dArray[3];
                this.summit[n2 + 2].x = this.origin.x + dArray[4];
                this.summit[n2 + 2].y = this.origin.y + dArray[5];
            }
            n2 += 3;
        }
        this.isClosed = jLXPath.closed;
        this.step = 10;
        this.updateShape();
    }

    JDSpline(LXObject lXObject, double[] dArray, double[] dArray2, boolean bl) {
        int n;
        this.initDefault();
        this.loadObject(lXObject);
        int n2 = dArray.length;
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        double d = (dArray[0] + dArray[1]) / 2.0;
        double d2 = (dArray2[0] + dArray2[1]) / 2.0;
        vector.add(new Point2D.Double(dArray[0], dArray2[0]));
        vector.add(new Point2D.Double(dArray[0], dArray2[0]));
        vector.add(new Point2D.Double(d, d2));
        vector.add(new Point2D.Double(d, d2));
        for (n = 1; n < n2; ++n) {
            if (n < n2 - 1) {
                d = (dArray[n] + dArray[n + 1]) / 2.0;
                d2 = (dArray2[n] + dArray2[n + 1]) / 2.0;
            } else {
                d = (dArray[n] + dArray[0]) / 2.0;
                d2 = (dArray2[n] + dArray2[0]) / 2.0;
            }
            vector.add(new Point2D.Double(dArray[n], dArray2[n]));
            vector.add(new Point2D.Double(dArray[n], dArray2[n]));
            vector.add(new Point2D.Double(d, d2));
        }
        vector.add(new Point2D.Double(d, d2));
        vector.add(new Point2D.Double(dArray[0], dArray2[0]));
        vector.add(new Point2D.Double(dArray[0], dArray2[0]));
        this.summit = new Point2D.Double[vector.size()];
        for (n = 0; n < this.summit.length; ++n) {
            this.summit[n] = (Point2D.Double)vector.get(n);
        }
        this.isClosed = bl;
        this.step = 10;
        this.updateShape();
        double d3 = this.boundRect.getX();
        double d4 = this.boundRect.getY();
        double d5 = this.boundRect.getWidth();
        double d6 = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d3 + d5 / 2.0, d4 + d6 / 2.0));
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDSpline(this, n, n2);
    }

    @Override
    void computeBoundRect() {
        int n;
        double d = -65536.0;
        double d2 = -65536.0;
        double d3 = 65536.0;
        double d4 = 65536.0;
        for (n = 0; n < this.summit.length; ++n) {
            if (this.summit[n].x < d3) {
                d3 = this.summit[n].x;
            }
            if (this.summit[n].x > d) {
                d = this.summit[n].x;
            }
            if (this.summit[n].y < d4) {
                d4 = this.summit[n].y;
            }
            if (!(this.summit[n].y > d2)) continue;
            d2 = this.summit[n].y;
        }
        for (n = 0; n < this.ptsx.length; ++n) {
            if ((double)this.ptsx[n] < d3) {
                d3 = this.ptsx[n];
            }
            if ((double)this.ptsx[n] > d) {
                d = this.ptsx[n];
            }
            if ((double)this.ptsy[n] < d4) {
                d4 = this.ptsy[n];
            }
            if (!((double)this.ptsy[n] > d2)) continue;
            d2 = this.ptsy[n];
        }
        this.boundRect = new Rectangle((int)d3, (int)d4, (int)(d - d3) + 1, (int)(d2 - d4) + 1);
    }

    @Override
    public void setStep(int n) {
        this.step = n;
        this.updateShape();
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(this.isClosed());
        jDPolyline.updateShape();
        return jDPolyline;
    }

    @Override
    public void moveSummit(int n, double d, double d2) {
        if (n % 3 == 0) {
            double d3 = d - this.summit[n].x;
            double d4 = d2 - this.summit[n].y;
            if (n > 0) {
                this.summit[n - 1].x += d3;
                this.summit[n - 1].y += d4;
            }
            this.summit[n].x += d3;
            this.summit[n].y += d4;
            if (n < this.summit.length - 1) {
                this.summit[n + 1].x += d3;
                this.summit[n + 1].y += d4;
            }
        } else {
            this.summit[n].x = d;
            this.summit[n].y = d2;
        }
        this.updateShape();
    }

    @Override
    void deleteSummit() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = null;
        doubleArray = new Point2D.Double[this.summit.length - 3];
        if (this.breakId == 0) {
            for (int i = 3; i < this.summit.length; ++i) {
                doubleArray[i - 3] = this.summit[i];
            }
        } else if (this.breakId == this.summit.length - 1) {
            for (int i = 0; i < this.summit.length - 3; ++i) {
                doubleArray[i] = this.summit[i];
            }
        } else {
            int n = 0;
            for (int i = 0; i < this.summit.length; ++i) {
                if (i >= this.breakId - 1 && i <= this.breakId + 1) continue;
                doubleArray[n++] = this.summit[i];
            }
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    @Override
    boolean canDeleteSummit(int n) {
        if (!this.visible) {
            return false;
        }
        this.breakId = -1;
        if (n < 0 || n >= this.summit.length || this.summit.length <= 4) {
            return false;
        }
        if (n % 3 != 0) {
            return false;
        }
        this.breakId = n;
        return true;
    }

    @Override
    void paintSummit(Graphics graphics, double d) {
        super.paintSummit(graphics, d);
        graphics.setColor(Color.green);
        for (int i = 0; i < this.summit.length - 1; i += 3) {
            graphics.drawLine((int)this.summit[i].x, (int)this.summit[i].y, (int)this.summit[i + 1].x, (int)this.summit[i + 1].y);
            graphics.drawLine((int)this.summit[i + 2].x, (int)this.summit[i + 2].y, (int)this.summit[i + 3].x, (int)this.summit[i + 3].y);
        }
    }

    @Override
    void breakShape() {
        if (this.breakId < 0) {
            return;
        }
        Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + 3];
        int n = this.breakId / this.step * 3 + 2;
        if (n < this.summit.length) {
            double d = this.ptsx[this.breakId + 1] - this.ptsx[this.breakId];
            double d2 = this.ptsy[this.breakId + 1] - this.ptsy[this.breakId];
            double d3 = Math.sqrt(d * d + d2 * d2);
            if (d3 < 1.0) {
                d = 30.0;
                d2 = 30.0;
            } else {
                d = 30.0 * d / d3;
                d2 = 30.0 * d2 / d3;
            }
            int n2 = 0;
            for (int i = 0; i < this.summit.length; ++i) {
                if (i == n) {
                    doubleArray[n2++] = new Point2D.Double(this.breakX - (int)d, this.breakY - (int)d2);
                    doubleArray[n2++] = new Point2D.Double(this.breakX, this.breakY);
                    doubleArray[n2++] = new Point2D.Double(this.breakX + (int)d, this.breakY + (int)d2);
                }
                doubleArray[n2++] = this.summit[i];
            }
        } else {
            double d = this.ptsx[0] - this.ptsx[this.ptsx.length - 1];
            double d4 = this.ptsy[0] - this.ptsy[this.ptsx.length - 1];
            double d5 = Math.sqrt(d * d + d4 * d4);
            if (d5 < 1.0) {
                d = 30.0;
                d4 = 30.0;
            } else {
                d = 30.0 * d / d5;
                d4 = 30.0 * d4 / d5;
            }
            for (int i = 0; i < this.summit.length; ++i) {
                doubleArray[i] = this.summit[i];
            }
            doubleArray[i++] = new Point2D.Double(this.breakX - (int)d, this.breakY - (int)d4);
            doubleArray[i++] = new Point2D.Double(this.breakX, this.breakY);
            doubleArray[i++] = new Point2D.Double(this.breakX + (int)d, this.breakY + (int)d4);
        }
        this.summit = doubleArray;
        this.updateShape();
    }

    JDSpline(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        int n = jDFileLoader.getCurrentLine();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseSummitArray();
        if (this.summit.length < 2) {
            throw new IOException("Invalid summit number for JDSpline at line " + n);
        }
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("isClosed")) {
                this.isClosed = jDFileLoader.parseBoolean();
                continue;
            }
            if (string.equals("step")) {
                this.step = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    public void connect(JDPolyline jDPolyline) {
        if (jDPolyline instanceof JDSpline) {
            int n;
            Point2D.Double[] doubleArray = new Point2D.Double[this.summit.length + jDPolyline.getSummitNumber() + 2];
            for (n = 0; n < this.summit.length; ++n) {
                doubleArray[n] = this.summit[n];
            }
            double d = this.summit[n - 1].x;
            double d2 = this.summit[n - 1].y;
            double d3 = jDPolyline.getSummit((int)0).x - this.summit[n - 1].x;
            double d4 = jDPolyline.getSummit((int)0).y - this.summit[n - 1].y;
            doubleArray[n] = new Point2D.Double(d + d3 * 0.33, d2 + d4 * 0.33);
            doubleArray[n + 1] = new Point2D.Double(d + d3 * 0.66, d2 + d4 * 0.66);
            for (n = 0; n < jDPolyline.getSummitNumber(); ++n) {
                doubleArray[n + 2 + this.summit.length] = new Point2D.Double(jDPolyline.getSummit((int)n).x, jDPolyline.getSummit((int)n).y);
            }
            this.summit = doubleArray;
            this.updateShape();
        } else {
            System.out.println("JDSpline.connect() : Cannot connect a JDSpline to JDPolyline.");
        }
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(8);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.isClosed = this.isClosed;
        return undoPattern;
    }

    JDSpline(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.isClosed = undoPattern.isClosed;
        this.updateShape();
    }

    @Override
    void updateShape() {
        int n = 0;
        this.ptsx = new int[this.summit.length / 3 * this.step + 1];
        this.ptsy = new int[this.summit.length / 3 * this.step + 1];
        for (int i = 0; i < this.summit.length - 1; i += 3) {
            JDUtils.computeSpline(this.summit[i + 0].x, this.summit[i + 0].y, this.summit[i + 1].x, this.summit[i + 1].y, this.summit[i + 2].x, this.summit[i + 2].y, this.summit[i + 3].x, this.summit[i + 3].y, this.step, i == this.summit.length - 4, n, null, this.ptsx, this.ptsy);
            n += this.step;
        }
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
        this.computeBoundRect();
    }
}

