/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDRoundRectanglePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JLabel cornerWidthLabel;
    private JSpinner cornerWidthSpinner;
    private JDRoundRectangle[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDRoundRectanglePanel(JDRoundRectangle[] jDRoundRectangleArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Corner"));
        jPanel.setBounds(5, 5, 370, 85);
        this.cornerWidthLabel = new JLabel("Corner width");
        this.cornerWidthLabel.setFont(JDUtils.labelFont);
        this.cornerWidthLabel.setForeground(JDUtils.labelColor);
        this.cornerWidthLabel.setBounds(10, 20, 100, 25);
        jPanel.add(this.cornerWidthLabel);
        this.cornerWidthSpinner = new JSpinner();
        this.cornerWidthSpinner.addChangeListener(this);
        this.cornerWidthSpinner.setBounds(115, 20, 60, 25);
        jPanel.add(this.cornerWidthSpinner);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        jPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        jPanel.add(this.stepSpinner);
        this.add(jPanel);
        this.updatePanel(jDRoundRectangleArray);
    }

    public void updatePanel(JDRoundRectangle[] jDRoundRectangleArray) {
        this.allObjects = jDRoundRectangleArray;
        this.isUpdating = true;
        if (jDRoundRectangleArray == null || jDRoundRectangleArray.length <= 0) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.cornerWidthSpinner.setModel(spinnerNumberModel);
            this.stepSpinner.setModel(spinnerNumberModel);
        } else {
            JDRoundRectangle jDRoundRectangle = jDRoundRectangleArray[0];
            Integer n = new Integer(jDRoundRectangle.getCornerWidth());
            Integer n2 = new Integer(1);
            Integer n3 = new Integer(256);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.cornerWidthSpinner.setModel(spinnerNumberModel);
            Integer n5 = new Integer(jDRoundRectangle.getStep());
            Integer n6 = new Integer(1);
            Integer n7 = new Integer(256);
            Integer n8 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n5, n6, n7, n8);
            this.stepSpinner.setModel(spinnerNumberModel2);
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            rectangle = rectangle.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        Integer n2;
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = changeEvent.getSource();
        if (object == this.stepSpinner) {
            n2 = (Integer)this.stepSpinner.getValue();
            for (n = 0; n < this.allObjects.length; ++n) {
                this.allObjects[n].setStep(n2);
            }
            this.invoker.setNeedToSave(true, "Change step");
        }
        if (object == this.cornerWidthSpinner) {
            n2 = (Integer)this.cornerWidthSpinner.getValue();
            for (n = 0; n < this.allObjects.length; ++n) {
                this.allObjects[n].setCornerWidth(n2);
            }
            this.invoker.setNeedToSave(true, "Change corner width");
        }
        this.repaintObjects();
    }
}

