/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class JDLibraryViewer
extends JFrame
implements ActionListener,
JDrawEditorListener {
    JDrawEditor libViewer;
    JDrawEditor invoker;
    JPanel controlPanel;
    JButton copyButton;
    JButton closeButton;
    JMenuItem copyMenuItem;
    JMenuItem exitMenuItem;

    public JDLibraryViewer(String string, JDrawEditor jDrawEditor) {
        this.initComponents(string, jDrawEditor, true);
    }

    public JDLibraryViewer(String string, JDrawEditor jDrawEditor, boolean bl) {
        this.initComponents(string, jDrawEditor, bl);
    }

    public void initComponents(String string, JDrawEditor jDrawEditor, boolean bl) {
        this.invoker = jDrawEditor;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.libViewer = new JDrawEditor(4);
        try {
            this.libViewer.loadFile(string);
        }
        catch (IOException iOException) {
            System.out.println("Cannot load library:\n" + iOException.getMessage());
        }
        this.libViewer.computePreferredSize();
        this.libViewer.setBorder(BorderFactory.createEtchedBorder());
        container.add((Component)this.libViewer, "Center");
        if (bl) {
            this.controlPanel = new JPanel();
            this.copyButton = new JButton("Copy");
            this.copyButton.setFont(ATKConstant.labelFont);
            this.copyButton.setMnemonic(67);
            this.copyButton.addActionListener(this);
            this.closeButton = new JButton("Close");
            this.closeButton.setFont(ATKConstant.labelFont);
            this.closeButton.setMnemonic(76);
            this.closeButton.addActionListener(this);
            this.controlPanel.add(this.copyButton);
            this.controlPanel.add(this.closeButton);
            container.add((Component)this.controlPanel, "South");
        }
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        this.libViewer.addToMenu(this.copyMenuItem);
        this.libViewer.addToMenu(this.exitMenuItem);
        this.libViewer.addEditorListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton || object == this.exitMenuItem) {
            this.setVisible(false);
        } else if ((object == this.copyButton || object == this.copyMenuItem) && this.invoker != null) {
            this.invoker.addObjectToClipboard(this.libViewer.getSelectedObjects());
        }
    }

    @Override
    public void selectionChanged() {
        if (this.libViewer.getSelectionLength() > 0) {
            this.invoker.addObjectToClipboard(this.libViewer.getSelectedObjects());
            this.invoker.create(7);
        }
    }

    @Override
    public void sizeChanged() {
    }

    @Override
    public void clipboardChanged() {
    }

    @Override
    public void valueChanged() {
    }

    @Override
    public void creationDone() {
    }

    public static void main(String[] stringArray) {
        JDLibraryViewer jDLibraryViewer = new JDLibraryViewer("Z:/segfs/blcdas/appli/vacuum/xvacuum/LOOX_files/Lib_Xvacuum.g", null);
        jDLibraryViewer.setTitle("ESRF Vacuum Library");
        jDLibraryViewer.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(jDLibraryViewer);
        jDLibraryViewer.setVisible(true);
    }
}

