/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JDGroup
extends JDRectangular {
    private Vector children;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean vFlat = false;
    private boolean hFlat = false;

    public JDGroup(String string, Vector vector) {
        this.initDefault();
        this.children = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.children.add(vector.get(i));
        }
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    JDGroup(JDGroup jDGroup, int n, int n2) {
        this.cloneObject(jDGroup, n, n2);
        this.children = new Vector();
        for (int i = 0; i < jDGroup.children.size(); ++i) {
            this.children.add(((JDObject)jDGroup.children.get(i)).copy(n, n2));
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDGroup(this, n, n2);
    }

    JDGroup(JLXObject jLXObject, Vector vector) {
        this.initDefault();
        this.loadObject(jLXObject);
        this.children = vector;
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    JDGroup(LXObject lXObject, Vector vector) {
        this.initDefault();
        this.loadObject(lXObject);
        this.children = vector;
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    private boolean canPaint() {
        if (!this.visible) {
            return false;
        }
        if (this.hFlat) {
            return this.boundRect.width > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5);
        }
        if (this.vFlat) {
            return this.boundRect.height > 1 || !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
        }
        return this.boundRect.width > 1 && this.boundRect.height > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5) && !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (this.canPaint()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).paint(jDrawEditor, graphics);
            }
        }
    }

    @Override
    void paintShadows(Graphics graphics) {
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        boolean bl = false;
        for (int i = this.children.size() - 1; i >= 0 && !bl; --i) {
            bl = ((JDObject)this.children.get(i)).isInsideObject(n, n2);
        }
        return bl;
    }

    @Override
    void updateShape() {
        double d;
        if (this.hFlat ? Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 : (this.vFlat ? Math.abs(this.summit[4].y - this.summit[0].y) < 0.5 : Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 || Math.abs(this.summit[4].y - this.summit[0].y) < 0.5)) {
            return;
        }
        double d2 = this.summit[0].x;
        double d3 = this.summit[0].y;
        double d4 = this.summit[4].x;
        double d5 = this.summit[4].y;
        double d6 = d2 - this.x1;
        double d7 = d3 - this.y1;
        double d8 = this.vFlat ? 1.0 : (d4 - d2) / (this.x2 - this.x1);
        double d9 = d = this.hFlat ? 1.0 : (d5 - d3) / (this.y2 - this.y1);
        if (d8 == 1.0 && d == 1.0) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).translate(d6, d7);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).scaleTranslate(this.x1, this.y1, d8, d, d6, d7);
            }
        }
        this.computeGroupBoundRect();
        this.computeBoundRect();
    }

    @Override
    public void restoreTransform() {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).restoreTransform();
        }
        this.computeGroupBoundRect();
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).saveTransform();
        }
        super.saveTransform();
    }

    @Override
    public void rotate90(double d, double d2) {
        for (int i = 0; i < this.getChildrenNumber(); ++i) {
            this.getChildAt(i).rotate90(d, d2);
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    @Override
    int getSummitMotion(int n) {
        if (this.hFlat) {
            if (n == 1 || n == 5) {
                return 0;
            }
            return 1;
        }
        if (this.vFlat) {
            if (n == 7 || n == 3) {
                return 0;
            }
            return 2;
        }
        return super.getSummitMotion(n);
    }

    @Override
    public void moveSummit(int n, double d, double d2) {
        if (this.hFlat) {
            switch (n) {
                case 0: 
                case 6: 
                case 7: {
                    super.moveSummit(7, d, d2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    super.moveSummit(3, d, d2);
                }
            }
            return;
        }
        if (this.vFlat) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    super.moveSummit(1, d, d2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    super.moveSummit(5, d, d2);
                }
            }
            return;
        }
        super.moveSummit(n, d, d2);
    }

    @Override
    void paintSummit(Graphics graphics, double d) {
        int n = (int)(d / 2.0 + 1.0);
        if (this.hFlat) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.fillRect((int)(this.summit[0].x - (double)n), (int)(this.summit[0].y - (double)n), 2 * n, 2 * n);
            graphics.fillRect((int)(this.summit[2].x - (double)n), (int)(this.summit[2].y - (double)n), 2 * n, 2 * n);
            graphics.setPaintMode();
            return;
        }
        if (this.vFlat) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.fillRect((int)(this.summit[0].x - (double)n), (int)(this.summit[0].y - (double)n), 2 * n, 2 * n);
            graphics.fillRect((int)(this.summit[6].x - (double)n), (int)(this.summit[6].y - (double)n), 2 * n, 2 * n);
            graphics.setPaintMode();
            return;
        }
        super.paintSummit(graphics, d);
    }

    @Override
    void setParent(JDrawEditor jDrawEditor) {
        super.setParent(jDrawEditor);
        for (int i = 0; i < this.getChildrenNumber(); ++i) {
            this.getChildAt(i).setParent(jDrawEditor);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        int n;
        Rectangle rectangle = null;
        for (n = 0; n < this.children.size(); ++n) {
            rectangle = n == 0 ? ((JDObject)this.children.get(n)).getRepaintRect() : rectangle.union(((JDObject)this.children.get(n)).getRepaintRect());
        }
        if (rectangle == null) {
            n = this.lineWidth + 1;
            return new Rectangle(this.boundRect.x - n, this.boundRect.y - n, this.boundRect.width + n * 2, this.boundRect.height + n * 2);
        }
        return rectangle;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setForeground(color);
        }
    }

    @Override
    public void setFillStyle(int n) {
        this.fillStyle = n;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setFillStyle(n);
        }
    }

    @Override
    public void setLineStyle(int n) {
        this.lineStyle = n;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setLineStyle(n);
        }
    }

    @Override
    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setAntiAlias(bl);
        }
    }

    @Override
    public void setLineWidth(int n) {
        this.lineWidth = n;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setLineWidth(n);
        }
    }

    @Override
    public void setShadow(boolean bl) {
        this.isShadowed = bl;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setShadow(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setVisible(bl);
        }
    }

    @Override
    public void setInverseShadow(boolean bl) {
        this.invertShadow = bl;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setInverseShadow(bl);
        }
    }

    @Override
    public void setShadowWidth(int n) {
        this.shadowThickness = n;
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setShadowWidth(n);
        }
    }

    @Override
    void setVal(int n, JDObject jDObject) {
        for (int i = 0; i < this.children.size(); ++i) {
            ((JDObject)this.children.get(i)).setVal(n, jDObject);
        }
        super.setVal(n, jDObject);
    }

    @Override
    void initVal(JDObject jDObject) {
        JDObject jDObject2 = this.isInteractive() ? this : jDObject;
        super.initVal(jDObject2);
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).initVal(jDObject2);
        }
    }

    @Override
    public void setMinValue(int n) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setMinValue(n);
        }
        super.setMinValue(n);
    }

    @Override
    public void setMaxValue(int n) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setMaxValue(n);
        }
        super.setMaxValue(n);
    }

    @Override
    public void setInitValue(int n) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).setInitValue(n);
        }
        super.setInitValue(n);
    }

    @Override
    void findObjectsAt(int n, int n2, Vector vector) {
        if (this.isInteractive()) {
            super.findObjectsAt(n, n2, vector);
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).findObjectsAt(n, n2, vector);
        }
    }

    @Override
    void getUserValueList(Vector vector) {
        if (this.isInteractive()) {
            vector.add(this);
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                this.getChildAt(i).getUserValueList(vector);
            }
        }
    }

    @Override
    void getObjectsByClassList(Vector vector, Class clazz) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.getChildAt(i).getObjectsByClassList(vector, clazz);
        }
    }

    @Override
    public void getObjectsByName(Vector vector, String string, boolean bl) {
        super.getObjectsByName(vector, string, bl);
        for (int i = 0; i < this.children.size() && bl; ++i) {
            this.getChildAt(i).getObjectsByName(vector, string, bl);
        }
    }

    @Override
    public boolean isProgrammed() {
        boolean bl = super.isProgrammed();
        for (int i = 0; i < this.children.size(); ++i) {
            bl |= this.getChildAt(i).isProgrammed();
        }
        return bl;
    }

    public JDObject getChildAt(int n) {
        return (JDObject)this.children.get(n);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public void setChildrenList(Vector vector) {
        this.children = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.children.add(vector.get(i));
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void generateJavaClass(FileWriter fileWriter) throws IOException {
        int n;
        Object object;
        int n2;
        int n3 = this.boundRect.x + this.boundRect.width / 2;
        int n4 = this.boundRect.y + this.boundRect.height / 2;
        class ObjInfo {
            int type;
            boolean closed;
            int[] xPolys;
            int[] yPolys;
            int backgroundId;
            int foregroundId;

            ObjInfo() {
            }

            void setValue(JDPolyline jDPolyline, int n, int n2, ColorManager colorManager) {
                this.type = 1;
                this.xPolys = new int[jDPolyline.getSummitNumber()];
                this.yPolys = new int[jDPolyline.getSummitNumber()];
                for (int i = 0; i < jDPolyline.getSummitNumber(); ++i) {
                    this.xPolys[i] = (int)jDPolyline.getSummit((int)i).x - n;
                    this.yPolys[i] = (int)jDPolyline.getSummit((int)i).y - n2;
                }
                if (jDPolyline.getName().equalsIgnoreCase("body")) {
                    this.backgroundId = -3;
                    this.foregroundId = -1;
                } else {
                    class ColorManager {
                        Vector colors = new Vector();

                        ColorManager() {
                        }

                        int addColor(Color color) {
                            if (color.equals(Color.black)) {
                                return -1;
                            }
                            if (color.equals(Color.white)) {
                                return -2;
                            }
                            int n = 0;
                            boolean bl = false;
                            while (n < this.colors.size() && !bl) {
                                bl = ((Color)this.colors.get(n)).getRGB() == color.getRGB();
                                if (bl) continue;
                                ++n;
                            }
                            if (!bl) {
                                this.colors.add(color);
                            }
                            return n;
                        }

                        Color get(int n) {
                            return (Color)this.colors.get(n);
                        }

                        String getName(int n) {
                            if (n == -1) {
                                return "Color.black";
                            }
                            if (n == -2) {
                                return "Color.white";
                            }
                            if (n == -3) {
                                return "backColor";
                            }
                            return "sColor" + n;
                        }
                    }
                    this.backgroundId = colorManager.addColor(jDPolyline.getBackground());
                    this.foregroundId = colorManager.addColor(jDPolyline.getForeground());
                }
                this.closed = jDPolyline.isClosed();
            }
        }
        ObjInfo[] objInfoArray = new ObjInfo[this.getChildrenNumber()];
        ColorManager colorManager = new ColorManager();
        for (n2 = 0; n2 < this.getChildrenNumber(); ++n2) {
            objInfoArray[n2] = new ObjInfo();
            if (this.getChildAt(n2) instanceof JDPolyConvert) {
                object = ((JDPolyConvert)((Object)this.getChildAt(n2))).convertToPolyline();
                objInfoArray[n2].setValue((JDPolyline)object, n3, n4, colorManager);
                continue;
            }
            if (this.getChildAt(n2) instanceof JDPolyline) {
                object = (JDPolyline)this.getChildAt(n2);
                objInfoArray[n2].setValue((JDPolyline)object, n3, n4, colorManager);
                continue;
            }
            if (this.getChildAt(n2) instanceof JDLine) {
                object = (JDLine)this.getChildAt(n2);
                objInfoArray[n2].type = 2;
                objInfoArray[n2].xPolys = new int[2];
                objInfoArray[n2].yPolys = new int[2];
                objInfoArray[n2].xPolys[0] = (int)((JDObject)object).getSummit((int)0).x - n3;
                objInfoArray[n2].yPolys[0] = (int)((JDObject)object).getSummit((int)0).y - n4;
                objInfoArray[n2].xPolys[1] = (int)((JDObject)object).getSummit((int)1).x - n3;
                objInfoArray[n2].yPolys[1] = (int)((JDObject)object).getSummit((int)1).y - n4;
                objInfoArray[n2].foregroundId = colorManager.addColor(((JDObject)object).getForeground());
                continue;
            }
            throw new IOException("generateJavaClass() supports only Line or Polyline");
        }
        fileWriter.write("/** ---------- " + this.getName() + " class ---------- */\n");
        fileWriter.write("public class " + this.getName() + " {\n\n");
        fileWriter.write("  private static int[][] xPolys = null;\n");
        fileWriter.write("  private static int[][] yPolys = null;\n\n");
        for (n2 = 0; n2 < colorManager.colors.size(); ++n2) {
            object = colorManager.get(n2);
            fileWriter.write("  private static Color sColor" + n2 + " = new Color(" + ((Color)object).getRed() + "," + ((Color)object).getGreen() + "," + ((Color)object).getBlue() + ");\n");
        }
        fileWriter.write("\n");
        fileWriter.write("  private static int[][] xOrgPolys = {\n");
        for (n2 = 0; n2 < this.getChildrenNumber(); ++n2) {
            if (objInfoArray[n2].type != 1) continue;
            fileWriter.write("    {");
            for (n = 0; n < objInfoArray[n2].xPolys.length; ++n) {
                fileWriter.write(Integer.toString(objInfoArray[n2].xPolys[n]));
                if (n >= objInfoArray[n2].xPolys.length - 1) continue;
                fileWriter.write(",");
            }
            fileWriter.write("},\n");
        }
        fileWriter.write("  };\n\n");
        fileWriter.write("  private static int[][] yOrgPolys = {\n");
        for (n2 = 0; n2 < this.getChildrenNumber(); ++n2) {
            if (objInfoArray[n2].type != 1) continue;
            fileWriter.write("    {");
            for (n = 0; n < objInfoArray[n2].yPolys.length; ++n) {
                fileWriter.write(Integer.toString(objInfoArray[n2].yPolys[n]));
                if (n >= objInfoArray[n2].yPolys.length - 1) continue;
                fileWriter.write(",");
            }
            fileWriter.write("},\n");
        }
        fileWriter.write("  };\n\n");
        fileWriter.write("  static public void paint(Graphics g,Color backColor,int x,int y,double size) {\n\n");
        fileWriter.write("    // Allocate array once\n");
        fileWriter.write("    if( xPolys == null ) {\n");
        fileWriter.write("      xPolys = new int [xOrgPolys.length][];\n");
        fileWriter.write("      yPolys = new int [yOrgPolys.length][];\n");
        fileWriter.write("      for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        fileWriter.write("        xPolys[i] = new int [xOrgPolys[i].length];\n");
        fileWriter.write("        yPolys[i] = new int [yOrgPolys[i].length];\n");
        fileWriter.write("      }\n");
        fileWriter.write("    }\n\n");
        fileWriter.write("    // Scale and translate poly\n");
        fileWriter.write("    for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        fileWriter.write("      for( int j=0 ; j<xOrgPolys[i].length ; j++ ) {\n");
        fileWriter.write("        xPolys[i][j] = (int)((double)xOrgPolys[i][j]*size+0.5) + x;\n");
        fileWriter.write("        yPolys[i][j] = (int)((double)yOrgPolys[i][j]*size+0.5) + y;\n");
        fileWriter.write("      }\n");
        fileWriter.write("    }\n\n");
        fileWriter.write("    // Paint object\n");
        int n5 = 0;
        for (n2 = 0; n2 < this.getChildrenNumber(); ++n2) {
            if (objInfoArray[n2].type == 1) {
                if (this.getChildAt(n2).getFillStyle() != 0) {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n2].backgroundId) + ");g.fillPolygon(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                }
                if (objInfoArray[n2].closed) {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n2].foregroundId) + ");g.drawPolygon(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                } else {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n2].foregroundId) + ");g.drawPolyline(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                }
                ++n5;
                continue;
            }
            fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n2].foregroundId) + ");\n");
            fileWriter.write("    g.drawLine((int)(" + objInfoArray[n2].xPolys[0] + ".0*size+0.5)+x, (int)(" + objInfoArray[n2].yPolys[0] + ".0*size+0.5)+y, (int)(" + objInfoArray[n2].xPolys[1] + ".0*size+0.5)+x, (int)(" + objInfoArray[n2].yPolys[1] + ".0*size+0.5)+y);\n");
        }
        fileWriter.write("\n  }\n\n");
        fileWriter.write("  static public void setBoundRect(int x,int y,double size,Rectangle bound) {\n");
        fileWriter.write("    bound.setRect((int)(" + (this.boundRect.x - n3) + ".0*size+0.5)+x,(int)(" + (this.boundRect.y - n4) + ".0*size+0.5)+y,(int)(" + this.boundRect.width + ".0*size+0.5),(int)(" + this.boundRect.height + ".0*size+0.5));");
        fileWriter.write("\n  }\n\n");
        fileWriter.write("}\n\n");
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        if (this.children.size() > 0) {
            String string = this.saveObjectHeader(fileWriter, n);
            String string2 = string + "children: {\n";
            fileWriter.write(string2, 0, string2.length());
            for (int i = 0; i < this.children.size(); ++i) {
                ((JDObject)this.children.get(i)).saveObject(fileWriter, n + 2);
            }
            string2 = string + "}\n";
            fileWriter.write(string2, 0, string2.length());
            this.closeObjectHeader(fileWriter, n);
        }
    }

    JDGroup(JDFileLoader jDFileLoader) throws IOException {
        this.children = new Vector();
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("children")) {
                jDFileLoader.startBlock();
                while (!jDFileLoader.isEndBlock()) {
                    this.children.add(jDFileLoader.parseObject());
                }
                jDFileLoader.endBlock();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.computeGroupBoundRect();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(2);
        this.fillUndoPattern(undoPattern);
        undoPattern.gChildren = new Vector();
        for (int i = 0; i < this.children.size(); ++i) {
            undoPattern.gChildren.add(((JDObject)this.children.get(i)).getUndoPattern());
        }
        return undoPattern;
    }

    JDGroup(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.children = new Vector();
        for (int i = 0; i < undoPattern.gChildren.size(); ++i) {
            UndoPattern undoPattern2 = (UndoPattern)undoPattern.gChildren.get(i);
            UndoBuffer.rebuildObject(undoPattern2, this.children);
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    private void computeGroupBoundRect() {
        double d;
        this.x1 = 65536.0;
        this.y1 = 65536.0;
        this.x2 = -65536.0;
        this.y2 = -65536.0;
        for (int i = 0; i < this.children.size(); ++i) {
            JDObject jDObject = (JDObject)this.children.get(i);
            for (int j = 0; j < jDObject.summit.length; ++j) {
                if (jDObject.summit[j].x < this.x1) {
                    this.x1 = jDObject.summit[j].x;
                }
                if (jDObject.summit[j].y < this.y1) {
                    this.y1 = jDObject.summit[j].y;
                }
                if (jDObject.summit[j].x > this.x2) {
                    this.x2 = jDObject.summit[j].x;
                }
                if (!(jDObject.summit[j].y > this.y2)) continue;
                this.y2 = jDObject.summit[j].y;
            }
        }
        this.hFlat = this.y2 == this.y1;
        boolean bl = this.vFlat = this.x2 == this.x1;
        if (this.summit[0].x > this.summit[4].x) {
            d = this.x1;
            this.x1 = this.x2;
            this.x2 = d;
        }
        if (this.summit[0].y > this.summit[4].y) {
            d = this.y1;
            this.y1 = this.y2;
            this.y2 = d;
        }
    }

    private void computeSummitCoordinates() {
        this.computeGroupBoundRect();
        if (this.children.size() >= 0) {
            this.summit[0].x = this.x1;
            this.summit[0].y = this.y1;
            this.summit[2].x = this.x2;
            this.summit[2].y = this.y1;
            this.summit[4].x = this.x2;
            this.summit[4].y = this.y2;
            this.summit[6].x = this.x1;
            this.summit[6].y = this.y2;
            this.centerSummit();
        }
        this.setOrigin(new Point2D.Double((this.x2 - this.x1) / 2.0, (this.y2 - this.y1) / 2.0));
    }
}

