/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDAxis
extends JDRectangular {
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    public static final int LEFT_LABEL = 0;
    public static final int RIGHT_LABEL = 1;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    private static int orientationDefault = 1;
    private static boolean tickCenteredDefault = false;
    private static int tickLengthDefault = 4;
    private static int labelPosDefault = 0;
    private static int scaleDefault = 0;
    private static int formatDefault = 0;
    private static double minDefault = 0.0;
    private static double maxDefault = 100.0;
    private static boolean invertedDefault = true;
    private static int tickSpacingDefault = 10;
    private Font theFont;
    private int orientation;
    private boolean tickCentered;
    private boolean inverted;
    private int tickLength;
    private int labelPos;
    private int scale;
    private int format;
    private int tickSpacing;
    private double min;
    private double max;
    private int fAscent;
    private JLAxis theAxis;

    public JDAxis(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.buildAxis();
        this.updateShape();
        this.centerOrigin();
    }

    JDAxis(JDAxis jDAxis, int n, int n2) {
        this.cloneObject(jDAxis, n, n2);
        this.theFont = new Font(jDAxis.theFont.getName(), jDAxis.theFont.getStyle(), jDAxis.theFont.getSize());
        this.orientation = jDAxis.orientation;
        this.tickCentered = jDAxis.tickCentered;
        this.tickLength = jDAxis.tickLength;
        this.tickSpacing = jDAxis.tickSpacing;
        this.labelPos = jDAxis.labelPos;
        this.scale = jDAxis.scale;
        this.min = jDAxis.min;
        this.max = jDAxis.max;
        this.format = jDAxis.format;
        this.inverted = jDAxis.inverted;
        this.buildAxis();
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.lineWidth = 0;
        this.theFont = JDLabel.fontDefault;
        this.orientation = orientationDefault;
        this.tickCentered = tickCenteredDefault;
        this.tickLength = tickLengthDefault;
        this.labelPos = labelPosDefault;
        this.min = minDefault;
        this.max = maxDefault;
        this.scale = scaleDefault;
        this.format = formatDefault;
        this.inverted = invertedDefault;
        this.tickSpacing = tickSpacingDefault;
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDAxis(this, n, n2);
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        super.paint(jDrawEditor, graphics);
        int n = 0;
        boolean bl = false;
        Shape shape = null;
        Color color = Color.BLACK;
        if (jDrawEditor != null) {
            color = jDrawEditor.getBackground();
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.orientation == 1) {
            this.theAxis.measureAxis(fontRenderContext, 0, this.boundRect.height - 1);
            int n2 = this.theAxis.getTickLength();
            if (n2 < 0) {
                n2 = 0;
            }
            boolean bl2 = bl = this.boundRect.width <= this.theAxis.getThickness() + n2;
            if (bl) {
                shape = graphics.getClip();
                graphics.setClip(this.boundRect.x, this.boundRect.y - this.fAscent, this.boundRect.width, this.boundRect.height + 2 * this.fAscent);
            }
            if (this.labelPos == 0) {
                n = this.boundRect.width - this.theAxis.getThickness() - 1;
            }
            if (n < 0) {
                n = 0;
            }
            this.theAxis.paintAxisDirect(graphics, fontRenderContext, this.boundRect.x + n, this.boundRect.y, color, 0, 0);
        } else {
            this.theAxis.measureAxis(fontRenderContext, this.boundRect.width - 1, 0);
            int n3 = this.theAxis.getTickLength();
            if (n3 < 0) {
                n3 = 0;
            }
            boolean bl3 = bl = this.boundRect.height <= this.theAxis.getThickness() + n3;
            if (bl) {
                shape = graphics.getClip();
                int n4 = this.theAxis.getFontOverWidth();
                graphics.setClip(this.boundRect.x - n4, this.boundRect.y, this.boundRect.width + 2 * n4, this.boundRect.height);
            }
            this.theAxis.paintAxisDirect(graphics, fontRenderContext, this.boundRect.x, this.boundRect.y, color, 0, 0);
        }
        if (bl) {
            graphics.setClip(shape);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle rectangle = super.getRepaintRect();
        int n = this.theAxis.getTickLength();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.theAxis.getFontOverWidth();
        if (this.orientation == 1) {
            rectangle.x -= n;
            rectangle.width += 2 * n;
            rectangle.y -= this.fAscent;
            rectangle.height += 2 * this.fAscent;
        } else {
            rectangle.y -= n;
            rectangle.height += 2 * n;
            rectangle.x -= n2;
            rectangle.width += 2 * n2;
        }
        return rectangle;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)(this.summit[0].x + 0.5);
                this.ptsy[0] = (int)(this.summit[0].y + 0.5);
                this.ptsx[1] = (int)(this.summit[2].x + 0.5);
                this.ptsy[1] = (int)(this.summit[2].y + 0.5);
                this.ptsx[2] = (int)(this.summit[4].x + 0.5);
                this.ptsy[2] = (int)(this.summit[4].y + 0.5);
                this.ptsx[3] = (int)(this.summit[6].x + 0.5);
                this.ptsy[3] = (int)(this.summit[6].y + 0.5);
            } else {
                this.ptsx[0] = (int)(this.summit[6].x + 0.5);
                this.ptsy[0] = (int)(this.summit[6].y + 0.5);
                this.ptsx[1] = (int)(this.summit[4].x + 0.5);
                this.ptsy[1] = (int)(this.summit[4].y + 0.5);
                this.ptsx[2] = (int)(this.summit[2].x + 0.5);
                this.ptsy[2] = (int)(this.summit[2].y + 0.5);
                this.ptsx[3] = (int)(this.summit[0].x + 0.5);
                this.ptsy[3] = (int)(this.summit[0].y + 0.5);
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)(this.summit[2].x + 0.5);
            this.ptsy[0] = (int)(this.summit[2].y + 0.5);
            this.ptsx[1] = (int)(this.summit[0].x + 0.5);
            this.ptsy[1] = (int)(this.summit[0].y + 0.5);
            this.ptsx[2] = (int)(this.summit[6].x + 0.5);
            this.ptsy[2] = (int)(this.summit[6].y + 0.5);
            this.ptsx[3] = (int)(this.summit[4].x + 0.5);
            this.ptsy[3] = (int)(this.summit[4].y + 0.5);
        } else {
            this.ptsx[0] = (int)(this.summit[4].x + 0.5);
            this.ptsy[0] = (int)(this.summit[4].y + 0.5);
            this.ptsx[1] = (int)(this.summit[6].x + 0.5);
            this.ptsy[1] = (int)(this.summit[6].y + 0.5);
            this.ptsx[2] = (int)(this.summit[0].x + 0.5);
            this.ptsy[2] = (int)(this.summit[0].y + 0.5);
            this.ptsx[3] = (int)(this.summit[2].x + 0.5);
            this.ptsy[3] = (int)(this.summit[2].y + 0.5);
        }
        if (this.theAxis != null) {
            if (this.orientation == 1) {
                if (this.labelPos == 0) {
                    this.theAxis.setOrientation(6);
                } else {
                    this.theAxis.setOrientation(5);
                }
                if (this.tickCentered) {
                    this.theAxis.setPosition(7);
                }
            } else {
                this.theAxis.setOrientation(1);
                if (this.tickCentered) {
                    this.theAxis.setPosition(4);
                }
            }
            this.theAxis.setTickSpacing(this.tickSpacing);
            this.theAxis.setTickLength(-this.tickLength);
            this.theAxis.setScale(this.scale);
            this.theAxis.setFont(this.theFont);
            this.fAscent = (int)(ATKGraphicsUtils.getLineMetrics("0", this.theFont).getAscent() + 0.5f);
            this.theAxis.setAxisColor(this.foreground);
            this.theAxis.setMinimum(this.min);
            this.theAxis.setMaximum(this.max);
            this.theAxis.setLabelFormat(this.format);
            this.theAxis.setInverted(this.inverted);
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.updateShape();
    }

    public void setFont(Font font) {
        this.theFont = font;
        this.updateShape();
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setTickCentered(boolean bl) {
        this.tickCentered = bl;
        this.updateShape();
    }

    public boolean isTickCentered() {
        return this.tickCentered;
    }

    public void setTickWidth(int n) {
        this.tickLength = n;
        this.updateShape();
    }

    public int getTickWidth() {
        return this.tickLength;
    }

    public void setTickSpacing(int n) {
        this.tickSpacing = n;
        this.updateShape();
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setMax(double d) {
        this.max = d;
        this.updateShape();
    }

    public void setMin(double d) {
        this.min = d;
        this.updateShape();
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void setLabelPos(int n) {
        this.labelPos = n;
        this.updateShape();
    }

    public int getLabelPos() {
        return this.labelPos;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setScale(int n) {
        this.scale = n;
        this.updateShape();
    }

    public int getScale() {
        return this.scale;
    }

    public void setFormat(int n) {
        this.format = n;
        this.updateShape();
    }

    public int getFormat() {
        return this.format;
    }

    public void setInverted(boolean bl) {
        this.inverted = bl;
        this.updateShape();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.theFont.getName() != JDLabel.fontDefault.getName() || this.theFont.getStyle() != JDLabel.fontDefault.getStyle() || this.theFont.getSize() != JDLabel.fontDefault.getSize()) {
            string = string2 + "font:\"" + this.theFont.getName() + "\"," + this.theFont.getStyle() + "," + this.theFont.getSize() + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.tickCentered != tickCenteredDefault) {
            string = string2 + "tickCentered:" + this.tickCentered + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.inverted != invertedDefault) {
            string = string2 + "inverted:" + this.inverted + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.tickSpacing != tickSpacingDefault) {
            string = string2 + "tickSpacing:" + this.tickSpacing + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.tickLength != tickLengthDefault) {
            string = string2 + "tickLength:" + this.tickLength + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.max != maxDefault) {
            string = string2 + "max:" + this.max + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.min != minDefault) {
            string = string2 + "min:" + this.min + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.labelPos != labelPosDefault) {
            string = string2 + "labelPos:" + this.labelPos + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.orientation != orientationDefault) {
            string = string2 + "orientation:" + this.orientation + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.scale != scaleDefault) {
            string = string2 + "scale:" + this.scale + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.format != formatDefault) {
            string = string2 + "format:" + this.format + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    JDAxis(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("font")) {
                this.theFont = jDFileLoader.parseFont();
                continue;
            }
            if (string.equals("tickCentered")) {
                this.tickCentered = jDFileLoader.parseBoolean();
                continue;
            }
            if (string.equals("inverted")) {
                this.inverted = jDFileLoader.parseBoolean();
                continue;
            }
            if (string.equals("tickLength")) {
                this.tickLength = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("tickSpacing")) {
                this.tickSpacing = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("labelPos")) {
                this.labelPos = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("orientation")) {
                this.orientation = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("scale")) {
                this.scale = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("min")) {
                this.min = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("max")) {
                this.max = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("format")) {
                this.format = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.buildAxis();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(11);
        this.fillUndoPattern(undoPattern);
        undoPattern.fName = this.theFont.getName();
        undoPattern.fStyle = this.theFont.getStyle();
        undoPattern.fSize = this.theFont.getSize();
        undoPattern.tickCentered = this.tickCentered;
        undoPattern.arrowWidth = this.tickLength;
        undoPattern.cornerWidth = this.tickSpacing;
        undoPattern.vAlignment = this.labelPos;
        undoPattern.arrowMode = this.orientation;
        undoPattern.arcType = this.scale;
        undoPattern.min = this.min;
        undoPattern.max = this.max;
        undoPattern.axis = this.theAxis;
        undoPattern.angleExtent = this.format;
        undoPattern.isClosed = this.inverted;
        return undoPattern;
    }

    JDAxis(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.theFont = new Font(undoPattern.fName, undoPattern.fStyle, undoPattern.fSize);
        this.tickCentered = undoPattern.tickCentered;
        this.tickLength = undoPattern.arrowWidth;
        this.tickSpacing = undoPattern.cornerWidth;
        this.labelPos = undoPattern.vAlignment;
        this.orientation = undoPattern.arrowMode;
        this.scale = undoPattern.arcType;
        this.min = undoPattern.min;
        this.max = undoPattern.max;
        this.format = undoPattern.angleExtent;
        this.theAxis = undoPattern.axis;
        this.inverted = undoPattern.isClosed;
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }

    private void buildAxis() {
        this.theAxis = this.orientation == 1 ? new JLAxis(null, 6) : new JLAxis(null, 1);
        this.theAxis.setAutoScale(false);
        this.theAxis.setAnnotation(2);
    }
}

