/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class EntityJTableAdapter
extends AbstractTableModel {
    JTable table;
    boolean initialized = false;
    List entities = new Vector();
    int columns = 0;
    List columnNames = new Vector();

    public void addTableModelListener(JTable jTable) {
        super.addTableModelListener(jTable);
        System.out.println("Added listener " + jTable);
    }

    public void addEntity(IEntity iEntity) {
        this.entities.add(iEntity);
        Map map = iEntity.getPropertyMap();
        if (!this.initialized) {
            this.columnNames.addAll(map.values());
            this.columns = this.columnNames.size();
        } else {
            this.normalizeProperties(iEntity);
        }
        this.fireTableChanged(new TableModelEvent(this));
        this.fireTableRowsInserted(0, 1);
    }

    protected void normalizeProperties(IEntity iEntity) {
        Map map = iEntity.getPropertyMap();
        try {
            if (map.size() < this.columns) {
                for (int i = 0; i < this.columns; ++i) {
                    String string = ((Property)this.columnNames.get(i)).toString();
                    if (map.containsKey(string)) continue;
                    map.put(string, null);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addEntities(AttributeList attributeList) {
        int n = this.entities.size();
        for (int i = 0; i < attributeList.size(); ++i) {
            IEntity iEntity = (IEntity)attributeList.get(i);
            this.normalizeProperties(iEntity);
            this.entities.add(attributeList.get(i));
        }
        this.fireTableRowsInserted(n, this.entities.size() - 1);
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n).toString();
    }

    @Override
    public int getRowCount() {
        return this.entities.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    public Property internalGetValueAt(int n, int n2) {
        Vector vector = new Vector();
        IEntity iEntity = (IEntity)this.entities.get(n);
        if (iEntity.getPropertyMap() == null) {
            return null;
        }
        vector.addAll(iEntity.getPropertyMap().values());
        return (Property)vector.get(n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.internalGetValueAt(n, n2);
        if (property == null) {
            property = (Property)this.columnNames.get(n2);
            if (property instanceof NumberProperty) {
                return new Double("NaN");
            }
            return "NULL";
        }
        if (property instanceof StringProperty || property instanceof NumberProperty) {
            System.out.println("Returning " + property.getValue());
            return property.getValue();
        }
        return property.getPresentation();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Property property = this.internalGetValueAt(n, n2);
        property.setValue(object);
        property.store();
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Property property = this.internalGetValueAt(n, n2);
        if (property == null) {
            return false;
        }
        return property.isEditable();
    }

    public Class getColumnClass(int n) {
        Property property = (Property)this.columnNames.get(n);
        if (property instanceof StringProperty) {
            return String.class;
        }
        if (property instanceof NumberProperty) {
            return Double.class;
        }
        return String.class;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame();
        AttributeList attributeList = new AttributeList();
        EntityJTableAdapter entityJTableAdapter = new EntityJTableAdapter();
        entityJTableAdapter.addEntity(attributeList.add("eas/test-api/1/Att_sinus"));
        JTable jTable = new JTable(entityJTableAdapter);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        attributeList.add("eas/test-api/1/*");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

