/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.EditableTableRowModel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JTable;

public class EditableJTableRow
extends JTableRow
implements ActionListener {
    protected JMenuItem loadMenuItem;
    protected JMenuItem deleteMenuItem;
    private EditableTableRowModel etrm = null;

    public EditableJTableRow() {
        this.editable = true;
        this.loadMenuItem = new JMenuItem("Load File");
        this.loadMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete Rows");
        this.deleteMenuItem.addActionListener(this);
        int n = this.tableMenu.getComponentIndex(this.saveMenuItem);
        this.tableMenu.remove(n);
        this.tableMenu.insert(this.loadMenuItem, n);
        this.tableMenu.insert(this.deleteMenuItem, n);
        this.etrm = new EditableTableRowModel();
        this.dm = this.etrm;
    }

    @Override
    public void setEditable(boolean bl) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public void setTableRowModel(TableRowModel tableRowModel) {
        if (tableRowModel != null) {
            this.dm = tableRowModel;
        }
    }

    public EditableTableRowModel getEditorTableRowModel() {
        return this.etrm;
    }

    public JTable getJTable() {
        return this.theTable;
    }

    public void loadDataFile() {
        File file;
        int n;
        JFileChooser jFileChooser = new JFileChooser(".");
        if (this.currentFile != null) {
            jFileChooser.setSelectedFile(this.currentFile);
        }
        if ((n = jFileChooser.showDialog(this, "Load")) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.currentFile = file;
            this.etrm.loadDataFile(file);
            String[] stringArray = this.etrm.getColName();
            this.setData(this.etrm.getData(), stringArray);
            this.etrm.fireTableDataChanged();
        }
    }

    public void deleteSelectedRows() {
        int[] nArray = this.theTable.getSelectedColumns();
        int[] nArray2 = this.theTable.getSelectedRows();
        if (!(nArray != null && nArray.length != 0 || nArray2 != null && nArray2.length != 0)) {
            return;
        }
        this.theTable.clearSelection();
        Arrays.sort(nArray2);
        for (int i = nArray2.length - 1; i >= 0; --i) {
            this.etrm.removeOneRow(nArray2[i]);
        }
        String[] stringArray = this.etrm.getColName();
        this.setData(this.etrm.getData(), stringArray);
        this.etrm.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.loadMenuItem && object != this.deleteMenuItem) {
            super.actionPerformed(actionEvent);
            return;
        }
        if (object == this.deleteMenuItem) {
            this.deleteSelectedRows();
        }
        if (object == this.loadMenuItem) {
            this.loadDataFile();
        }
    }
}

