/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.widget.util.EntityJTableAdapter;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DropTable
extends JTable {
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private int acceptableActions = 1;

    public DropTable() {
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    public DropTable(TableModel tableModel) {
        super(tableModel);
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    public DropTable(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 0x40000000) {
            throw new IllegalArgumentException("action" + n);
        }
        this.acceptableActions = n;
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    class DTListener
    implements DropTargetListener {
        private boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
            return true;
        }

        private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
            DataFlavor dataFlavor = DataFlavor.stringFlavor;
            return dataFlavor;
        }

        private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
                System.out.println("isDragOk:no flavors chosen");
                return false;
            }
            int n = dropTargetDragEvent.getDropAction();
            System.out.print("dt drop action " + n);
            System.out.println(" my acceptable actions " + DropTable.this.acceptableActions);
            return (n & DropTable.this.acceptableActions) != 0;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            System.out.println("dtlistener dragEnter");
            if (!this.isDragOk(dropTargetDragEvent)) {
                System.out.println("enter not ok");
                dropTargetDragEvent.rejectDrag();
                return;
            }
            System.out.println("dt enter: accepting " + dropTargetDragEvent.getDropAction());
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragOk(dropTargetDragEvent)) {
                System.out.println("dtlistener dragOver not ok");
                dropTargetDragEvent.rejectDrag();
                return;
            }
            System.out.println("dt over: accepting");
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragOk(dropTargetDragEvent)) {
                System.out.println("dtlistener changed not ok");
                dropTargetDragEvent.rejectDrag();
                return;
            }
            System.out.println("dt changed: accepting" + dropTargetDragEvent.getDropAction());
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            System.out.println("dtlistener dragExit");
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            System.out.println("dtlistener drop");
            DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
            if (dataFlavor == null) {
                System.err.println("No flavor match found");
                dropTargetDropEvent.rejectDrop();
                return;
            }
            System.err.println("Chosen data flavor is " + dataFlavor.getMimeType());
            int n = dropTargetDropEvent.getDropAction();
            int n2 = dropTargetDropEvent.getSourceActions();
            System.out.println("drop: sourceActions: " + n2);
            System.out.println("drop: dropAction: " + n);
            if ((n2 & DropTable.this.acceptableActions) == 0) {
                System.err.println("No action match found");
                dropTargetDropEvent.rejectDrop();
                return;
            }
            Object object = null;
            try {
                dropTargetDropEvent.acceptDrop(DropTable.this.acceptableActions);
                object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
                if (object == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable throwable) {
                System.err.println("Couldn't get transfer data: " + throwable.getMessage());
                throwable.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            System.out.println("Got data: " + object.getClass().getName());
            if (!(object instanceof IEntity)) {
                System.out.println("drop: rejecting");
                dropTargetDropEvent.dropComplete(false);
                return;
            }
            IEntity iEntity = (IEntity)object;
            ((EntityJTableAdapter)DropTable.this.getModel()).addEntity(iEntity);
            System.out.println("got " + iEntity);
            dropTargetDropEvent.dropComplete(true);
        }

        DTListener() {
        }
    }
}

