/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Node;
import fr.esrf.tangoatk.widget.util.RootNode;
import fr.esrf.tangoatk.widget.util.TreeNodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DeviceFinder
extends JPanel {
    public static final int MODE_DEVICE = 0;
    public static final int MODE_ATTRIBUTE = 1;
    public static final int MODE_COMMAND = 2;
    public static final int MODE_ATTRIBUTE_SCALAR = 3;
    public static final int MODE_ATTRIBUTE_NUMBER_SCALAR = 4;
    public static final int MODE_ATTRIBUTE_BOOLEAN_SCALAR = 5;
    public static final int MODE_ATTRIBUTE_STRING_SCALAR = 6;
    public static final int MODE_ATTRIBUTE_NUMBER_SPECTRUM = 7;
    public static final int MODE_ATTRIBUTE_NUMBER_BOOLEAN_SCALAR = 8;
    public static final int MODE_ATTRIBUTE_NUMBER_BOOLEAN_SPECTRUM_SCALAR = 9;
    static Database db;
    JTree tree;
    JScrollPane treeView;
    DefaultTreeModel treeModel;
    int mode;

    public DeviceFinder(int n) {
        this.mode = n;
        try {
            db = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage(null, "Database", devFailed);
            return;
        }
        this.setLayout(new BorderLayout());
        this.createTree();
        this.add((Component)this.treeView, "Center");
    }

    public void setSelectionModel(int n) {
        this.tree.getSelectionModel().setSelectionMode(n);
    }

    public String[] getSelectedNames() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        Vector<String> vector = new Vector<String>();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                Object[] objectArray = treePathArray[i].getPath();
                Node node = (Node)objectArray[objectArray.length - 1];
                if (!node.isLeaf()) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 1; j < objectArray.length; ++j) {
                    stringBuffer.append(objectArray[j]);
                    if (j == objectArray.length - 1) continue;
                    stringBuffer.append('/');
                }
                vector.add(stringBuffer.toString());
            }
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    private void createTree() {
        this.treeModel = new DefaultTreeModel(new RootNode(this.mode));
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.tree);
    }

    public JTree getTree() {
        return this.tree;
    }

    public static void main(String[] stringArray) {
        final DeviceFinder deviceFinder = new DeviceFinder(0);
        deviceFinder.setSelectionModel(1);
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton = new JButton("Select");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = deviceFinder.getSelectedNames();
                System.out.println("-------------------------");
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i]);
                }
            }
        });
        jPanel.add((Component)jButton, "South");
        jPanel.add((Component)deviceFinder, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setVisible(true);
    }
}

