/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import javax.swing.table.AbstractTableModel;

class CommandTableModel
extends AbstractTableModel {
    private ACommand[] allCommands = new ACommand[0];
    private static final String[] colNames = new String[]{"Command name", "Execution count"};

    public CommandTableModel() {
        this.refresh();
    }

    public void refresh() {
        this.allCommands = CommandFactory.getInstance().getCommands();
    }

    @Override
    public int getRowCount() {
        return this.allCommands.length;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.allCommands[n].getName();
            }
            case 1: {
                return Integer.toString(this.allCommands[n].getExecutionCount());
            }
        }
        return "";
    }
}

