/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

class AttributeTableModel
extends AbstractTableModel {
    private AAttribute[] allAttributes = new AAttribute[0];
    private static final String[] colNames = new String[]{"Attribute name", "Event enabled", "Event src", "Listeners", "", "Polling", "Change", "Periodic", "Config"};
    private static String[] evtType = new String[]{"Unknown", "notifd", "zmq"};

    public AttributeTableModel() {
        this.refresh();
    }

    public void refresh() {
        this.allAttributes = AttributeFactory.getInstance().getAttributes();
    }

    public AAttribute getAttribute(int n) {
        return this.allAttributes[n];
    }

    @Override
    public int getRowCount() {
        return this.allAttributes.length;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    public Class getColumnClass(int n) {
        if (n == 4) {
            return JButton.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.allAttributes[n].getName();
            }
            case 1: {
                return Boolean.toString(this.allAttributes[n].hasEvents());
            }
            case 2: {
                return evtType[this.allAttributes[n].getEventType()];
            }
            case 3: {
                return Integer.toString(this.allAttributes[n].getPropChanges().getListenerCount());
            }
            case 4: {
                return "";
            }
            case 5: {
                return Long.toString(this.allAttributes[n].getRefreshCount());
            }
            case 6: {
                return Long.toString(this.allAttributes[n].getChangeCount());
            }
            case 7: {
                return Long.toString(this.allAttributes[n].getPeriodicCount());
            }
            case 8: {
                return Long.toString(this.allAttributes[n].getConfigCount());
            }
        }
        return "";
    }
}

