/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceProperty;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DevicePropertyDialog
extends JDialog
implements PropertyChangeListener {
    protected DeviceProperty devicePropertyModel;
    protected JTextArea valueField;
    protected JButton ok;
    protected JButton apply;
    protected JButton cancel;
    protected JButton refresh;
    protected JLabel nameLabel;
    protected Box propertyBox;
    protected Box buttonBox;
    protected Box globalBox;

    public DevicePropertyDialog(Dialog dialog, String string) {
        super(dialog, string, true);
        this.initComponents();
    }

    public DevicePropertyDialog(Frame frame, String string) {
        super(frame, string, true);
        this.initComponents();
    }

    public DevicePropertyDialog(Dialog dialog) {
        super(dialog, "", true);
        this.initComponents();
    }

    public DevicePropertyDialog(Frame frame) {
        super(frame, "", true);
        this.initComponents();
    }

    public DevicePropertyDialog() {
        super((Frame)null, "", true);
        this.initComponents();
    }

    public void setDevicePropertyModel(DeviceProperty deviceProperty) {
        if (this.devicePropertyModel != null) {
            this.devicePropertyModel.removePresentationListener((PropertyChangeListener)this);
        }
        this.devicePropertyModel = null;
        this.devicePropertyModel = deviceProperty;
        if (this.devicePropertyModel != null) {
            this.devicePropertyModel.addPresentationListener((PropertyChangeListener)this);
            this.ok.setEnabled(this.devicePropertyModel.isEditable());
            this.apply.setEnabled(this.devicePropertyModel.isEditable());
            this.refresh.setEnabled(true);
            this.valueField.setText(deviceProperty.getStringValue());
            this.valueField.setEditable(this.devicePropertyModel.isEditable());
            this.nameLabel.setText(this.devicePropertyModel.getName());
        } else {
            this.ok.setEnabled(false);
            this.apply.setEnabled(false);
            this.refresh.setEnabled(false);
            this.valueField.setText("No value");
            this.valueField.setEditable(false);
            this.nameLabel.setText("No property defined");
        }
    }

    public DeviceProperty getDevicePropertyModel() {
        return this.devicePropertyModel;
    }

    public void clearDevicePropertyModel() {
        this.setDevicePropertyModel(null);
    }

    protected void initComponents() {
        this.ok = new JButton("ok");
        this.cancel = new JButton("cancel");
        this.apply = new JButton("apply");
        this.refresh = new JButton("refresh");
        this.nameLabel = new JLabel("No property defined");
        this.nameLabel.setToolTipText("Property Name");
        this.valueField = new JTextArea("No value");
        this.valueField.setToolTipText("Property Value");
        this.valueField.setAutoscrolls(true);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePropertyDialog.this.apply();
                DevicePropertyDialog.this.cancel();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePropertyDialog.this.cancel();
            }
        });
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePropertyDialog.this.apply();
            }
        });
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DevicePropertyDialog.this.refresh();
            }
        });
        this.globalBox = new Box(1);
        this.propertyBox = new Box(0);
        this.buttonBox = new Box(0);
        this.buttonBox.add(this.ok);
        this.buttonBox.add(this.apply);
        this.buttonBox.add(this.cancel);
        this.buttonBox.add(this.refresh);
        this.propertyBox.add(this.nameLabel);
        this.propertyBox.add(new JScrollPane(this.valueField));
        this.globalBox.add(this.propertyBox);
        this.globalBox.add(this.buttonBox);
        this.getContentPane().add(this.globalBox);
        this.setSize(350, 200);
    }

    protected void apply() {
        if (this.devicePropertyModel != null) {
            this.devicePropertyModel.setValue(this.valueField.getText());
            this.devicePropertyModel.store();
        }
    }

    protected void cancel() {
        this.clearDevicePropertyModel();
        this.dispose();
        this.setVisible(false);
    }

    protected void refresh() {
        if (this.devicePropertyModel != null) {
            this.devicePropertyModel.refresh();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.valueField.setText(((DeviceProperty)propertyChangeEvent.getSource()).getStringValue());
    }

    public static void main(String[] stringArray) {
        try {
            DeviceProperty deviceProperty;
            if (stringArray.length != 0 && stringArray.length != 2) {
                System.out.println("wrong arguments");
                System.exit(2);
            }
            System.out.println("accessing device and property...");
            if (stringArray.length > 0) {
                Device device = DeviceFactory.getInstance().getDevice(stringArray[0]);
                System.out.println("device accessed");
                deviceProperty = device.getProperty(stringArray[1]);
                System.out.println("property accessed");
            } else {
                Device device = DeviceFactory.getInstance().getDevice("test/testSignal2/1");
                System.out.println("device accessed");
                deviceProperty = device.getProperty("propertyTest");
                System.out.println("property accessed");
            }
            System.out.println("loading widget...");
            DevicePropertyDialog devicePropertyDialog = new DevicePropertyDialog();
            devicePropertyDialog.setDevicePropertyModel(deviceProperty);
            devicePropertyDialog.setVisible(true);
            System.out.println("widget closed... goodbye !");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

