/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.dnd;

import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.dnd.AttributeNode;
import fr.esrf.tangoatk.widget.dnd.CommandNode;
import fr.esrf.tangoatk.widget.dnd.Node;
import fr.esrf.tangoatk.widget.dnd.NumberImageNode;
import fr.esrf.tangoatk.widget.dnd.NumberScalarNode;
import fr.esrf.tangoatk.widget.dnd.NumberSpectrumNode;
import fr.esrf.tangoatk.widget.dnd.StringScalarNode;

public class NodeFactory {
    protected static NodeFactory instance;
    public static String MIME_NUMBERSCALAR;
    public static String MIME_NUMBERIMAGE;
    public static String MIME_NUMBERSPECTRUM;
    public static String MIME_ENTITY;
    public static String MIME_COMMAND;
    public static String MIME_ATTRIBUTE;
    public static String MIME_STRINGSCALAR;

    protected NodeFactory() {
    }

    public static NodeFactory getInstance() {
        if (instance == null) {
            instance = new NodeFactory();
        }
        return instance;
    }

    public Node getNode4Entity(IAttribute iAttribute) {
        if (iAttribute instanceof INumberScalar) {
            return this.getNode4Entity((INumberScalar)iAttribute);
        }
        if (iAttribute instanceof IStringScalar) {
            return this.getNode4Entity((IStringScalar)iAttribute);
        }
        if (iAttribute instanceof INumberSpectrum) {
            return this.getNode4Entity((INumberSpectrum)iAttribute);
        }
        if (iAttribute instanceof INumberImage) {
            return this.getNode4Entity((INumberImage)iAttribute);
        }
        return new AttributeNode(iAttribute);
    }

    public Node getNode4Entity(INumberScalar iNumberScalar) {
        return new NumberScalarNode(iNumberScalar);
    }

    public Node getNode4Entity(IStringScalar iStringScalar) {
        return new StringScalarNode(iStringScalar);
    }

    public Node getNode4Entity(INumberSpectrum iNumberSpectrum) {
        return new NumberSpectrumNode(iNumberSpectrum);
    }

    public Node getNode4Entity(INumberImage iNumberImage) {
        return new NumberImageNode(iNumberImage);
    }

    public Node getNode4Entity(ICommand iCommand) {
        return new CommandNode(iCommand);
    }

    static {
        MIME_NUMBERSCALAR = "tango/numberscalar";
        MIME_NUMBERIMAGE = "tango/numberimage";
        MIME_NUMBERSPECTRUM = "tango/numberspectrum";
        MIME_ENTITY = "tango/entity";
        MIME_COMMAND = "tango/icommand";
        MIME_ATTRIBUTE = "tango/iattribute";
        MIME_STRINGSCALAR = "tango/strinscalar";
    }
}

