/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class StringScalarNumberComboEditor
extends JComboBox
implements ActionListener,
INumberScalarListener {
    private DefaultComboBoxModel comboModel = null;
    private String defActionCmd = "setAttActionCmd";
    private INumberScalar numberModel = null;
    private String[] optionList = new String[]{"0.0"};

    public StringScalarNumberComboEditor() {
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.setActionCommand(this.defActionCmd);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        double d = 0.0;
        int n = this.getSelectedIndex();
        if (!actionEvent.getActionCommand().equals(this.defActionCmd)) {
            return;
        }
        if (this.numberModel == null) {
            return;
        }
        d = Double.NaN;
        d = this.getValues(n);
        if (!Double.isNaN(d)) {
            this.numberModel.setValue(d);
        }
    }

    private void changeCurrentSelection(int n) {
        this.disableExecution();
        this.setSelectedIndex(n);
        this.repaint();
        this.enableExecution();
    }

    private void changeSelectedOption(double d) {
        this.changeCurrentSelection(this.getIndex(d));
    }

    public void disableExecution() {
        this.setActionCommand("dummy");
    }

    public void enableExecution() {
        this.setActionCommand(this.defActionCmd);
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.changeSelectedOption(Double.NaN);
    }

    private int getIndex(double d) {
        if (this.numberModel == null) {
            return 0;
        }
        double[] dArray = this.numberModel.getPossibleValues();
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != d) continue;
            return i;
        }
        return 0;
    }

    public double getValues(int n) {
        double[] dArray = this.numberModel.getPossibleValues();
        if (dArray == null) {
            return Double.NaN;
        }
        if (n > dArray.length || n < 0) {
            return Double.NaN;
        }
        return dArray[n];
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = Double.NaN;
        d = this.hasFocus() ? this.numberModel.getNumberScalarSetPointFromDevice() : this.numberModel.getNumberScalarSetPoint();
        this.changeSelectedOption(d);
    }

    public void setNumberModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar == null) {
            return;
        }
        if (!iNumberScalar.isWritable()) {
            return;
        }
        this.numberModel = iNumberScalar;
        this.comboModel = new DefaultComboBoxModel<String>(this.optionList);
        this.setModel(this.comboModel);
        this.numberModel.addNumberScalarListener((INumberScalarListener)this);
        this.numberModel.refresh();
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
        }
    }

    public void setOptionList(String[] stringArray) {
        this.optionList = stringArray;
        this.comboModel = new DefaultComboBoxModel<String>(stringArray);
        this.setModel(this.comboModel);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }
}

