/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IDeviceApplication;
import fr.esrf.tangoatk.widget.device.IDevicePopUp;
import fr.esrf.tangoatk.widget.device.SingletonStatusViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SimpleStateViewer
extends JSmoothLabel
implements IDevStateScalarListener {
    protected IDevStateScalar model = null;
    private String currentState = "UNKNOWN";
    protected boolean stateClickable = true;
    private IDeviceApplication application;
    private IDevicePopUp popUp = SingletonStatusViewer.getInstance();
    protected boolean hasToolTip = true;
    protected boolean stateInTooltip = true;

    public SimpleStateViewer() {
        this.setFont(ATKConstant.labelFont);
        this.setPreferredSize(new Dimension(40, 14));
        this.setOpaque(true);
        this.setState("UNKNOWN");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SimpleStateViewer.this.stateViewerMouseClicked(mouseEvent);
            }
        });
    }

    protected void stateViewerMouseClicked(MouseEvent mouseEvent) {
        if (!this.stateClickable) {
            return;
        }
        if (this.model == null) {
            return;
        }
        IDevice iDevice = this.model.getDevice();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.application == null) {
                return;
            }
            this.application.setModel(iDevice);
            this.application.run();
        } else {
            this.popUp.setModel(iDevice);
            this.popUp.setVisible(true);
        }
    }

    public void setHasToolTip(boolean bl) {
        if (this.hasToolTip == bl) {
            return;
        }
        this.hasToolTip = bl;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
    }

    public void setModel(IDevStateScalar iDevStateScalar) {
        if (this.model != null) {
            this.clearModel();
        }
        if (iDevStateScalar == null) {
            return;
        }
        this.model = iDevStateScalar;
        if (!iDevStateScalar.areAttPropertiesLoaded()) {
            iDevStateScalar.loadAttProperties();
        }
        this.model.addDevStateScalarListener((IDevStateScalarListener)this);
        if (this.hasToolTip) {
            this.setToolTipText(this.model.getDevice().getName());
        }
        this.model.refresh();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateScalarListener((IDevStateScalarListener)this);
            this.model = null;
            this.setState("UNKNOWN");
            if (this.hasToolTip) {
                this.setToolTipText("no device");
            } else {
                this.setToolTipText(null);
            }
        }
    }

    public IDevStateScalar getModel() {
        return this.model;
    }

    private void setState(String string) {
        this.currentState = string;
        if (this.model != null) {
            this.setBackground(ATKConstant.getColor4State(this.currentState, this.model.getInvertedOpenClose(), this.model.getInvertedInsertExtract()));
            if (this.hasToolTip && this.stateInTooltip) {
                this.setToolTipText(this.model.getDevice().getName() + " : " + this.currentState);
            }
        } else {
            this.setBackground(ATKConstant.getColor4State(string));
            if (this.hasToolTip) {
                this.setToolTipText("");
            } else {
                this.setToolTipText(null);
            }
        }
    }

    public void setStateClickable(boolean bl) {
        this.stateClickable = bl;
    }

    public boolean getStateClickable() {
        return this.stateClickable;
    }

    public void setApplication(IDeviceApplication iDeviceApplication) {
        this.application = iDeviceApplication;
    }

    public IDeviceApplication getApplication() {
        return this.application;
    }

    public IDevicePopUp getPopUp() {
        return this.popUp;
    }

    public void setPopUp(IDevicePopUp iDevicePopUp) {
        this.popUp = iDevicePopUp;
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        this.setState(devStateScalarEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setState("UNKNOWN");
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        Font font = new Font("Dialog", 0, 18);
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        try {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            SimpleStateViewer simpleStateViewer = new SimpleStateViewer();
            simpleStateViewer.setFont(font);
            simpleStateViewer.setHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
            simpleStateViewer.setStateClickable(false);
            IDevStateScalar iDevStateScalar = (IDevStateScalar)attributeList.add("dev/test/10/State_attr_rw");
            simpleStateViewer.setModel(iDevStateScalar);
            simpleStateViewer.setText("    ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            jPanel.add((Component)simpleStateViewer, gridBagConstraints);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

