/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.LabelItem;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ScalarLevelMeterViewer
extends JComponent
implements INumberScalarListener {
    private INumberScalar numberModel = null;
    private double min;
    private double max;
    private double value = Double.NaN;
    private Color viewBackground = Color.WHITE;
    private int nbDiv = 30;
    private Vector<LabelItem> labels;
    private boolean drawGradient = true;

    public ScalarLevelMeterViewer() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(200, 100));
        this.min = 0.0;
        this.max = 100.0;
        this.labels = new Vector();
        this.setFont(new Font("Dialog", 0, 10));
        this.addLabel(0.0, "0%");
        this.addLabel(0.25, "25%");
        this.addLabel(0.5, "50%");
        this.addLabel(0.75, "75%");
        this.addLabel(1.0, "100%");
        this.numberModel = null;
    }

    public void setDrawGradient(boolean bl) {
        this.drawGradient = bl;
    }

    public void setMin(double d) {
        this.min = d;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public void setViewBackground(Color color) {
        this.viewBackground = color;
    }

    public Color getViewBackground() {
        return this.viewBackground;
    }

    public void addLabel(double d, String string) {
        LabelItem labelItem = new LabelItem(d, string);
        this.labels.add(labelItem);
    }

    public void clearLabel() {
        this.labels.clear();
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        this.value = numberScalarEvent.getValue();
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.value = Double.NaN;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n5, n6);
        }
        int n7 = (this.nbDiv + 1) * 2;
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        double d = (double)n5 / 2.0;
        double d2 = 2.0 * (double)n6 + 10.0;
        double d3 = 2.0 * (double)n6 - 20.0;
        double d4 = 2.0 * (double)n6 - (double)n6 / 3.0 - 20.0;
        double d5 = 2.0 * (double)n6 - 10.0;
        double d6 = Math.asin((d - 30.0) / d3);
        double d7 = 2.0 * d6 / (double)this.nbDiv;
        double d8 = -d6;
        for (int i = 0; i <= this.nbDiv; ++i) {
            nArray[i] = (int)(d3 * Math.sin(d8) + d);
            nArray[n7 - 1 - i] = (int)(d4 * Math.sin(d8) + d);
            nArray2[i] = (int)(-d3 * Math.cos(d8) + d2);
            nArray2[n7 - 1 - i] = (int)(-d4 * Math.cos(d8) + d2);
            d8 += d7;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.drawGradient) {
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.GREEN, n5 - 50, 1.0f, Color.ORANGE, false);
            graphics2D.setPaint(gradientPaint);
        } else {
            graphics.setColor(this.viewBackground);
        }
        graphics.fillPolygon(nArray, nArray2, n7);
        graphics.setColor(this.getForeground());
        graphics.drawPolygon(nArray, nArray2, n7);
        for (int i = 0; i < this.labels.size(); ++i) {
            d8 = d6 * (2.0 * this.labels.get((int)i).x - 1.0);
            int n8 = (int)(d3 * Math.sin(d8) + d);
            n4 = (int)(-d3 * Math.cos(d8) + d2);
            n3 = (int)(d5 * Math.sin(d8) + d);
            n2 = (int)(-d5 * Math.cos(d8) + d2);
            graphics.drawLine(n8, n4, n3, n2);
            graphics.setFont(this.getFont());
            n = ATKGraphicsUtils.measureString((String)this.labels.get((int)i).label, (Font)this.getFont()).width;
            graphics.drawString(this.labels.get((int)i).label, n3 - n / 2, n2 - 3);
        }
        if (!Double.isNaN(this.value)) {
            d8 = this.value < this.min ? -d6 : (this.value > this.max ? d6 : d6 * (2.0 * (this.value - this.min) / (this.max - this.min) - 1.0));
            Stroke stroke = graphics2D.getStroke();
            BasicStroke basicStroke = new BasicStroke(2.0f);
            if (basicStroke != null) {
                graphics2D.setStroke(basicStroke);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            n4 = (int)(d3 * Math.sin(d8) + d);
            n3 = (int)(-d3 * Math.cos(d8) + d2);
            n2 = (int)(d4 * Math.sin(d8) + d);
            n = (int)(-d4 * Math.cos(d8) + d2);
            graphics.drawLine(n4, n3, n2, n);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setStroke(stroke);
        }
        this.paintBorder(graphics);
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
            this.numberModel = null;
        }
    }

    public void setModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar != null) {
            this.numberModel = iNumberScalar;
            this.numberModel.addNumberScalarListener((INumberScalarListener)this);
            this.numberModel.refresh();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        ScalarLevelMeterViewer scalarLevelMeterViewer = new ScalarLevelMeterViewer();
        String string = "jlp/test/1/att_un";
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        IAttribute iAttribute = null;
        try {
            iAttribute = (IAttribute)attributeList.add(string);
        }
        catch (Exception exception) {
            iAttribute = null;
        }
        if (iAttribute instanceof INumberScalar) {
            scalarLevelMeterViewer.setModel((INumberScalar)iAttribute);
        } else {
            System.err.println(string + " is not a valid attribute or is not available");
            System.exit(1);
        }
        scalarLevelMeterViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        scalarLevelMeterViewer.setForeground(Color.BLACK);
        scalarLevelMeterViewer.clearLabel();
        scalarLevelMeterViewer.addLabel(0.0, "-1");
        scalarLevelMeterViewer.addLabel(0.25, "");
        scalarLevelMeterViewer.addLabel(0.5, "0");
        scalarLevelMeterViewer.addLabel(0.75, "");
        scalarLevelMeterViewer.addLabel(1.0, "1");
        scalarLevelMeterViewer.setMin(-1.0);
        scalarLevelMeterViewer.setMax(1.0);
        iAttribute.refresh();
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(scalarLevelMeterViewer);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

