/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class NumberScalarSpinner
extends JSpinner
implements Serializable,
INumberScalarListener,
ActionListener,
MouseListener,
KeyListener {
    private boolean displayReadValue = true;
    private boolean valueEditable = true;
    private double stepValue = 1.0;
    private boolean alarmEnabled = true;
    private SpinnerNumberModel numberSpinnerModel = null;
    private INumberScalar numberModel = null;
    public static final String ACTION_ARROW = "ARROW";
    public static final String ACTION_CHANGE_VALUE = "VALUE";

    public NumberScalarSpinner() {
        Double d = new Double(0.0);
        Double d2 = new Double(-1.7976931348623157E308);
        Double d3 = new Double(Double.MAX_VALUE);
        Double d4 = new Double(this.stepValue);
        this.numberSpinnerModel = new SpinnerNumberModel(d, d2, d3, d4);
        this.setModel(this.numberSpinnerModel);
        this.getComponent(0).setName(ACTION_ARROW);
        this.getComponent(0).addMouseListener(this);
        this.getComponent(1).setName(ACTION_ARROW);
        this.getComponent(1).addMouseListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addMouseListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setName(ACTION_CHANGE_VALUE);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addActionListener(this);
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().addKeyListener(this);
    }

    public boolean getDisplayReadValue() {
        return this.displayReadValue;
    }

    public void setDisplayReadValue(boolean bl) {
        if (this.numberModel != null && !this.numberModel.isWritable()) {
            bl = true;
            return;
        }
        this.displayReadValue = bl;
    }

    public boolean getAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public boolean getValueEditable() {
        return this.valueEditable;
    }

    public void setValueEditable(boolean bl) {
        this.valueEditable = bl;
        if (!this.numberModel.isWritable()) {
            ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(false);
        } else {
            ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(bl);
        }
    }

    public double getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(double d) {
        this.stepValue = d;
        this.numberSpinnerModel.setStepSize(new Double(d));
    }

    public INumberScalar getNumberModel() {
        return this.numberModel;
    }

    public void setNumberModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar != null) {
            this.numberModel = iNumberScalar;
            if (!iNumberScalar.isWritable()) {
                ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(false);
            } else {
                ((JSpinner.NumberEditor)this.getEditor()).getTextField().setEditable(this.valueEditable);
            }
            this.numberModel.addNumberScalarListener((INumberScalarListener)this);
        }
    }

    public void clearModel() {
        if (this.numberModel != null) {
            this.numberModel.removeNumberScalarListener((INumberScalarListener)this);
            this.numberModel = null;
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        if (!this.alarmEnabled) {
            return;
        }
        String string = attributeStateEvent.getState();
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (!this.alarmEnabled) {
            return;
        }
        this.setValue(new Double(0.0));
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    @Override
    public void setBackground(Color color) {
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setBackground(color);
    }

    @Override
    public Color getBackground() {
        return ((JSpinner.NumberEditor)this.getEditor()).getTextField().getBackground();
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        try {
            Double d = this.displayReadValue || !this.numberModel.isWritable() ? new Double(numberScalarEvent.getValue()) : new Double(numberScalarEvent.getNumberSource().getNumberScalarSetPoint());
            this.setValue(d);
        }
        catch (Exception exception) {
            this.setValue(new Double(0.0));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent().getName().equals(ACTION_ARROW)) {
            this.arrowActionPerformed();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (((Component)actionEvent.getSource()).getName().equals(ACTION_CHANGE_VALUE)) {
            this.valueChangePerformed();
        }
    }

    public void arrowActionPerformed() {
        if (this.numberModel == null) {
            return;
        }
        if (!this.numberModel.isWritable()) {
            try {
                Double d = new Double(this.numberModel.getNumberScalarValue());
                this.setValue(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        double d = (Double)this.getValue();
        if (((JSpinner.NumberEditor)this.getEditor()).getTextField().hasFocus()) {
            this.numberModel.setValue(d);
        }
    }

    public void valueChangePerformed() {
        if (this.numberModel == null) {
            return;
        }
        if (!this.numberModel.isWritable()) {
            try {
                Double d = new Double(this.numberModel.getNumberScalarValue());
                this.setValue(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        double d = (Double)this.getValue();
        if (((JSpinner.NumberEditor)this.getEditor()).getTextField().hasFocus()) {
            this.numberModel.setValue(d);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
            this.arrowActionPerformed();
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributePolledList attributePolledList = new AttributePolledList();
            INumberScalar iNumberScalar = stringArray.length != 0 ? (INumberScalar)attributePolledList.add(stringArray[0].trim()) : (INumberScalar)attributePolledList.add("LT1/AE/CH.1/current".toLowerCase());
            attributePolledList.startRefresher();
            NumberScalarSpinner numberScalarSpinner = new NumberScalarSpinner();
            numberScalarSpinner.setNumberModel(iNumberScalar);
            numberScalarSpinner.setAlarmEnabled(true);
            numberScalarSpinner.setStepValue(2.0);
            JFrame jFrame = new JFrame("NumberScalarSpinner");
            jFrame.getContentPane().add(numberScalarSpinner);
            jFrame.setSize(300, 50);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

