/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.DigitalNumberViewer;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DigitalNumberScalarViewer
extends DigitalNumberViewer
implements INumberScalarListener,
PropertyChangeListener,
IErrorListener,
JDrawable {
    INumberScalar model = null;
    boolean alarmEnabled = true;
    Color backgroundColor = ATKConstant.getColor4Quality("VALID");
    String userFormat = null;
    private boolean hasToolTip = false;
    private boolean qualityInTooltip = false;
    static String[] exts = new String[]{"userFormat", "alarmEnabled", "validBackground", "fontSize"};

    public DigitalNumberScalarViewer() {
        this.setOpaque(true);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setUserFormat(String string) {
        if (string == null || string.equals("")) {
            this.userFormat = null;
        } else {
            this.userFormat = string;
            this.setFormat(this.userFormat);
        }
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String string) {
        if (string.equalsIgnoreCase("userFormat")) {
            return "Overrides the tango attribute format property when specified.\nSupports C format, ex:%5.2f .";
        }
        if (string.equalsIgnoreCase("alarmEnabled")) {
            return "When enabled, the background color change with the\nTango attribute quality factor.\nDefault colors are: ( unless they have been changed with\nATKConstant.setColor4Quality() )\n VALID   => Green\n INVALID => Grey\n ALARM   => Orange\n WARNING => Orange\n CHANGING => Blue\n UNKNOWN => Grey\nPossible values are: true, false.";
        }
        if (string.equalsIgnoreCase("validBackground")) {
            return "Sets the background color (r,g,b) for the VALID quality factor for this viewer.\nHas effect only if alarmEnabled is true.";
        }
        if (string.equalsIgnoreCase("fontSize")) {
            return "Sets the digit size.";
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("userFormat")) {
            this.setUserFormat(string2);
            return true;
        }
        if (string.equalsIgnoreCase("alarmEnabled")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setAlarmEnabled(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setAlarmEnabled(false);
                return true;
            }
            this.showJdrawError(bl, "alarmEnabled", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("validBackground")) {
            String[] stringArray = string2.split(",");
            if (stringArray.length != 3) {
                this.showJdrawError(bl, "validBackground", "Integer list expected: r,g,b");
                return false;
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
                    this.showJdrawError(bl, "validBackground", "Parameter out of bounds. [0..255]");
                    return false;
                }
                this.setBackgroundColor(new Color(n, n2, n3));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "validBackground", "Wrong integer syntax.");
                return false;
            }
        }
        if (string.equalsIgnoreCase("fontSize")) {
            try {
                int n = Integer.parseInt(string2);
                if (n <= 10) {
                    this.showJdrawError(bl, "fontSize", "Parameter must be greater than 10");
                    return false;
                }
                this.setFontSize(n);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "fontSize", "Wrong integer syntax.");
                return false;
            }
        }
        return false;
    }

    @Override
    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("userFormat")) {
            if (this.userFormat == null) {
                return "";
            }
            return this.userFormat;
        }
        if (string.equals("alarmEnabled")) {
            return this.isAlarmEnabled() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("validBackground")) {
            Color color = this.backgroundColor;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (string.equalsIgnoreCase("fontSize")) {
            return Integer.toString(this.getFontSize());
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "DigitalNumberScalarViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        this.setValue(numberScalarEvent.getValue());
    }

    public void setAlarmEnabled(boolean bl) {
        this.alarmEnabled = bl;
    }

    public boolean isAlarmEnabled() {
        return this.alarmEnabled;
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (this.hasToolTip && this.qualityInTooltip) {
            IAttribute iAttribute = (IAttribute)attributeStateEvent.getSource();
            this.setToolTipText(iAttribute.getName() + " : " + string);
        }
        if (string.equals("INVALID")) {
            this.setValue(Double.NaN);
        }
        if (!this.alarmEnabled) {
            return;
        }
        if (string.equals("VALID")) {
            this.setBackground(this.backgroundColor);
            this.repaint();
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality(string));
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setValue(Double.NaN);
        if (!this.alarmEnabled) {
            return;
        }
        this.setBackground(ATKConstant.getColor4Quality("UNKNOWN"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null) {
            if (property.getName().equalsIgnoreCase("format") && this.userFormat == null) {
                this.setFormat(property.getValue().toString());
            }
            this.model.refresh();
        }
    }

    public void setModel(INumberScalar iNumberScalar) {
        this.clearModel();
        if (iNumberScalar != null) {
            if (this.userFormat == null) {
                this.setFormat(iNumberScalar.getProperty("format").getPresentation());
            }
            this.model = iNumberScalar;
            this.model.addNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
            if (this.hasToolTip) {
                this.setToolTipText(iNumberScalar.getName());
            }
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.hasToolTip) {
            this.setToolTipText(null);
        }
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model = null;
        }
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean bl) {
        if (this.hasToolTip == bl) {
            return;
        }
        this.hasToolTip = bl;
        if (!this.hasToolTip) {
            this.setToolTipText(null);
            return;
        }
        if (this.model != null) {
            this.setToolTipText(this.model.getName());
        }
    }

    public boolean getQualityInTooltip() {
        return this.qualityInTooltip;
    }

    public void setQualityInTooltip(boolean bl) {
        INumberScalar iNumberScalar = null;
        if (!this.hasToolTip) {
            this.qualityInTooltip = bl;
            return;
        }
        if (this.qualityInTooltip != bl) {
            if (this.model != null) {
                iNumberScalar = this.model;
            }
            if (!bl && iNumberScalar != null) {
                this.setToolTipText(iNumberScalar.getName());
            }
            this.qualityInTooltip = bl;
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        DigitalNumberScalarViewer digitalNumberScalarViewer = new DigitalNumberScalarViewer();
        String string = "jlp/test/1/att_un";
        IAttribute iAttribute = null;
        try {
            iAttribute = (IAttribute)attributeList.add(string);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage(null, "jlp/test/1", exception);
            iAttribute = null;
        }
        digitalNumberScalarViewer.setModel((INumberScalar)iAttribute);
        digitalNumberScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        digitalNumberScalarViewer.setBackgroundColor(Color.WHITE);
        digitalNumberScalarViewer.setForeground(Color.BLACK);
        digitalNumberScalarViewer.setHasToolTip(true);
        if (iAttribute != null) {
            iAttribute.refresh();
        }
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(digitalNumberScalarViewer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.startRefresher();
    }
}

