/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BooleanSpectrumViewer
extends JPanel
implements IBooleanSpectrumListener,
PropertyChangeListener {
    public static final int TOOLTIP_NONE = 0;
    public static final int TOOLTIP_ATTNAME = 1;
    public static final int TOOLTIP_VALUE = 2;
    public static final int TOOLTIP_ATTNAME_VALUE = 3;
    public static final int DISPLAY_ICON = 0;
    public static final int DISPLAY_TEXT = 1;
    public static final int DISPLAY_ICON_TEXT = 2;
    private static ImageIcon TRUE_ICON = null;
    private static ImageIcon FALSE_ICON = null;
    private static ImageIcon ERROR_ICON = null;
    private static final String TRUE_LABEL = "True";
    private static final String FALSE_LABEL = "False";
    private static final String ERROR_LABEL = "Unknown";
    private Vector<JLabel> labelJLabels;
    private Vector<JLabel> valueJLabels;
    private Font globalFont;
    private boolean booleanLabelVisible;
    private int displayMode;
    private int toolTipMode;
    private ImageIcon trueIcon = null;
    private ImageIcon falseIcon = null;
    private ImageIcon errorIcon = null;
    private String trueLabel = null;
    private String falseLabel = null;
    private String errorLabel = null;
    private IBooleanSpectrum model;
    String[] modelBooleanLabels;
    String modelLabel;

    public BooleanSpectrumViewer() {
        if (TRUE_ICON == null) {
            TRUE_ICON = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/true.png"));
        }
        if (FALSE_ICON == null) {
            FALSE_ICON = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/false.png"));
        }
        if (ERROR_ICON == null) {
            ERROR_ICON = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/unknown.png"));
        }
        this.trueIcon = TRUE_ICON;
        this.falseIcon = FALSE_ICON;
        this.errorIcon = ERROR_ICON;
        this.trueLabel = TRUE_LABEL;
        this.falseLabel = FALSE_LABEL;
        this.errorLabel = ERROR_LABEL;
        this.model = null;
        this.modelBooleanLabels = null;
        this.modelLabel = null;
        this.globalFont = new Font("Dialog", 0, 12);
        this.booleanLabelVisible = true;
        this.displayMode = 2;
        this.toolTipMode = 1;
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public ImageIcon getTrueIcon() {
        return this.trueIcon;
    }

    public void setTrueIcon(ImageIcon imageIcon) {
        if (imageIcon == this.falseIcon || imageIcon == this.errorIcon) {
            return;
        }
        this.trueIcon = imageIcon;
    }

    public ImageIcon getFalseIcon() {
        return this.falseIcon;
    }

    public void setFalseIcon(ImageIcon imageIcon) {
        if (imageIcon == this.trueIcon || imageIcon == this.errorIcon) {
            return;
        }
        this.falseIcon = imageIcon;
    }

    public ImageIcon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(ImageIcon imageIcon) {
        if (imageIcon == this.falseIcon || imageIcon == this.trueIcon) {
            return;
        }
        this.errorIcon = imageIcon;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(this.falseLabel) || string.equalsIgnoreCase(this.errorLabel)) {
            return;
        }
        this.trueLabel = string;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(this.trueLabel) || string.equalsIgnoreCase(this.errorLabel)) {
            return;
        }
        this.falseLabel = string;
    }

    public String getErrorLabel() {
        return this.errorLabel;
    }

    public void setErrorLabel(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(this.falseLabel) || string.equalsIgnoreCase(this.trueLabel)) {
            return;
        }
        this.errorLabel = string;
    }

    public IBooleanSpectrum getModel() {
        return this.model;
    }

    public void setModel(IBooleanSpectrum iBooleanSpectrum) {
        this.clearModel();
        if (iBooleanSpectrum == null) {
            return;
        }
        this.model = iBooleanSpectrum;
        if (!this.model.areAttPropertiesLoaded()) {
            this.model.loadAttProperties();
        }
        this.modelBooleanLabels = this.model.getBooleanLabels();
        this.modelLabel = this.model.getLabel();
        this.initComponents();
        this.setVisible(true);
        this.model.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        this.model.addBooleanSpectrumListener((IBooleanSpectrumListener)this);
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeBooleanSpectrumListener((IBooleanSpectrumListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.removeComponents();
            this.model = null;
            this.modelBooleanLabels = null;
            this.modelLabel = null;
        }
    }

    public Font getGlobalFont() {
        return this.globalFont;
    }

    public void setGlobalFont(Font font) {
        int n;
        JLabel jLabel = null;
        if (font == null) {
            return;
        }
        this.globalFont = font;
        if (this.labelJLabels != null) {
            for (n = 0; n < this.labelJLabels.size(); ++n) {
                jLabel = this.labelJLabels.get(n);
                jLabel.setFont(this.globalFont);
            }
        }
        if (this.valueJLabels != null) {
            for (n = 0; n < this.valueJLabels.size(); ++n) {
                jLabel = this.valueJLabels.get(n);
                jLabel.setFont(this.globalFont);
            }
        }
    }

    public boolean getBooleanLabelVisible() {
        return this.booleanLabelVisible;
    }

    public void setBooleanLabelVisible(boolean bl) {
        if (this.booleanLabelVisible != bl) {
            this.booleanLabelVisible = bl;
            this.changeBooleanLabelVisibility();
        }
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(int n) {
        if (n == this.displayMode) {
            return;
        }
        this.displayMode = n;
    }

    public int getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(int n) {
        if (n == this.toolTipMode) {
            return;
        }
        this.toolTipMode = n;
    }

    private void removeComponents() {
        if (this.labelJLabels != null) {
            this.labelJLabels.removeAllElements();
        }
        if (this.valueJLabels != null) {
            this.valueJLabels.removeAllElements();
        }
        this.removeAll();
        this.labelJLabels = null;
        this.valueJLabels = null;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        boolean[] blArray = this.model.getDeviceValue();
        if (blArray == null) {
            return;
        }
        if (blArray.length <= 0) {
            return;
        }
        this.labelJLabels = new Vector();
        this.valueJLabels = new Vector();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        while (n < blArray.length) {
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            String string = null;
            if (this.toolTipMode == 1) {
                string = this.model.getName() + "[" + n + "]";
            } else if (this.toolTipMode == 2) {
                string = Boolean.toString(blArray[n]);
            } else if (this.toolTipMode == 3) {
                string = this.model.getName() + "[" + n + "] = " + Boolean.toString(blArray[n]);
            }
            jLabel.setFont(this.globalFont);
            jLabel.setBackground(this.getBackground());
            jLabel.setToolTipText(string);
            if (this.modelBooleanLabels != null && n < this.modelBooleanLabels.length) {
                jLabel.setText(this.modelBooleanLabels[n]);
            } else {
                jLabel.setText(this.modelLabel + "[" + n + "]");
            }
            jLabel2.setFont(this.globalFont);
            jLabel2.setToolTipText(string);
            this.displayBooleanValue(jLabel2, blArray[n]);
            this.labelJLabels.add(jLabel);
            this.valueJLabels.add(jLabel2);
            jLabel.setHorizontalAlignment(4);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 6, 6, 6);
            this.add((Component)jLabel2, gridBagConstraints);
            jLabel.setVisible(this.booleanLabelVisible);
        }
    }

    private void changeBooleanLabelVisibility() {
        JLabel jLabel = null;
        if (this.labelJLabels == null) {
            return;
        }
        for (int i = 0; i < this.labelJLabels.size(); ++i) {
            try {
                jLabel = this.labelJLabels.get(i);
                jLabel.setVisible(this.booleanLabelVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateSpectrumValues(boolean[] blArray) {
        if (this.valueJLabels == null) {
            return;
        }
        for (int i = 0; i < blArray.length && i < this.valueJLabels.size(); ++i) {
            this.displayBooleanValue(this.valueJLabels.get(i), blArray[i]);
            this.updateValueInTooltip(i, blArray[i]);
        }
    }

    private void displayBooleanValue(JLabel jLabel, boolean bl) {
        if (this.displayMode == 2) {
            if (bl) {
                jLabel.setIcon(this.trueIcon);
                jLabel.setText(this.trueLabel);
            } else {
                jLabel.setIcon(this.falseIcon);
                jLabel.setText(this.falseLabel);
            }
            return;
        }
        if (this.displayMode == 0) {
            jLabel.setText("");
            if (bl) {
                jLabel.setIcon(this.trueIcon);
            } else {
                jLabel.setIcon(this.falseIcon);
            }
            return;
        }
        if (this.displayMode == 1) {
            jLabel.setIcon(null);
            if (bl) {
                jLabel.setText(this.trueLabel);
            } else {
                jLabel.setText(this.falseLabel);
            }
            return;
        }
    }

    private void updateValueInTooltip(int n, boolean bl) {
        if (this.toolTipMode == 1) {
            return;
        }
        if (this.toolTipMode == 0) {
            return;
        }
        String string = this.toolTipMode == 2 ? Boolean.toString(bl) : this.model.getName() + "[" + n + "] = " + Boolean.toString(bl);
        if (this.labelJLabels != null && n < this.labelJLabels.size()) {
            this.labelJLabels.get(n).setToolTipText(string);
        }
        if (this.valueJLabels != null && n < this.valueJLabels.size()) {
            this.valueJLabels.get(n).setToolTipText(string);
        }
    }

    private void setNewAttLabel(String string) {
        this.modelLabel = string;
        if (this.labelJLabels == null) {
            return;
        }
        for (int i = 0; i < this.labelJLabels.size(); ++i) {
            JLabel jLabel = this.labelJLabels.get(i);
            if (this.modelBooleanLabels != null && i < this.modelBooleanLabels.length) continue;
            jLabel.setText(this.modelLabel + "[" + i + "]");
        }
    }

    private void displayErrorAllBooleans() {
        if (this.valueJLabels == null) {
            return;
        }
        for (int i = 0; i < this.valueJLabels.size(); ++i) {
            this.displayErrorValue(this.valueJLabels.get(i));
            this.updateTooltipWithError(i);
        }
    }

    private void displayErrorValue(JLabel jLabel) {
        if (this.displayMode == 2) {
            jLabel.setIcon(this.errorIcon);
            jLabel.setText(this.errorLabel);
            return;
        }
        if (this.displayMode == 0) {
            jLabel.setText("");
            jLabel.setIcon(this.errorIcon);
            return;
        }
        if (this.displayMode == 1) {
            jLabel.setIcon(null);
            jLabel.setText(this.errorLabel);
        }
    }

    private void updateTooltipWithError(int n) {
        if (this.toolTipMode == 1) {
            return;
        }
        if (this.toolTipMode == 0) {
            return;
        }
        String string = this.toolTipMode == 2 ? this.errorLabel : this.model.getName() + "[" + n + "] = " + this.errorLabel;
        if (this.labelJLabels != null && n < this.labelJLabels.size()) {
            this.labelJLabels.get(n).setToolTipText(string);
        }
        if (this.valueJLabels != null && n < this.valueJLabels.size()) {
            this.valueJLabels.get(n).setToolTipText(string);
        }
    }

    public void booleanSpectrumChange(BooleanSpectrumEvent booleanSpectrumEvent) {
        if (booleanSpectrumEvent.getValue().length < 1) {
            this.displayErrorAllBooleans();
            return;
        }
        this.updateSpectrumValues(booleanSpectrumEvent.getValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null && property.getName().equalsIgnoreCase("label")) {
            this.setNewAttLabel(property.getValue().toString());
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.displayErrorAllBooleans();
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        BooleanSpectrumViewer booleanSpectrumViewer = new BooleanSpectrumViewer();
        try {
            IBooleanSpectrum iBooleanSpectrum = (IBooleanSpectrum)attributeList.add("id-carr/td13/gap/limitswitches");
            booleanSpectrumViewer.setModel(iBooleanSpectrum);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.setPreferredSize(new Dimension(500, 800));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(booleanSpectrumViewer);
        jFrame.setContentPane(jScrollPane);
        jFrame.pack();
        attributeList.startRefresher();
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.repaint();
    }
}

