/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;

public class TaskAttributeNode
extends TangoNode {
    private Database db;
    private String devName;
    private Vector attInfo;

    TaskAttributeNode(Database database, String string) {
        this.db = database;
        this.devName = string;
        this.attInfo = null;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.atticon;
    }

    @Override
    public String toString() {
        return "Attribute config";
    }

    @Override
    String getTitle() {
        return "Attribute configuration";
    }

    String getName() {
        return this.devName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    int getAttributeNumber() {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return this.attInfo.size();
    }

    String getAttName(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).name;
    }

    String getMinAlarm(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).min_alarm;
    }

    String getMaxAlarm(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).max_alarm;
    }

    String getMinWarning(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).min_warning;
    }

    String getMaxWarning(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).max_warning;
    }

    String getDeltaT(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).delta_t;
    }

    String getDeltaVal(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).delta_val;
    }

    void setMinAlarm(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_alarm = string;
            } else {
                attributeInfoEx.min_alarm = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMaxAlarm(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.max_alarm = string;
            } else {
                attributeInfoEx.max_alarm = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMinWarning(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_warning = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMaxWarning(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.max_warning = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDeltaT(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.delta_t = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDeltaVal(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.delta_val = string;
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetAlarms(int n) {
        try {
            String[] stringArray = new String[]{"min_alarm", "max_alarm", "min_warning", "max_warning", "delta_t", "delta_val"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLAlarms(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_alarm = "Not specified";
                attributeInfoEx.alarms.max_alarm = "Not specified";
                attributeInfoEx.alarms.min_warning = "Not specified";
                attributeInfoEx.alarms.max_warning = "Not specified";
                attributeInfoEx.alarms.delta_t = "Not specified";
                attributeInfoEx.alarms.delta_val = "Not specified";
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULAlarms(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_alarm = "";
                attributeInfoEx.alarms.max_alarm = "";
                attributeInfoEx.alarms.min_warning = "";
                attributeInfoEx.alarms.max_warning = "";
                attributeInfoEx.alarms.delta_t = "";
                attributeInfoEx.alarms.delta_val = "";
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULAlarms(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            if (attributeInfoEx.alarms != null) {
                attributeInfoEx.alarms.min_alarm = "NaN";
                attributeInfoEx.alarms.max_alarm = "NaN";
                attributeInfoEx.alarms.min_warning = "NaN";
                attributeInfoEx.alarms.max_warning = "NaN";
                attributeInfoEx.alarms.delta_t = "NaN";
                attributeInfoEx.alarms.delta_val = "NaN";
            }
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getUnit(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).unit;
    }

    String getDisplayUnit(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).display_unit;
    }

    String getStandardUnit(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).standard_unit;
    }

    void setUnit(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setDisplayUnit(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.display_unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setStandardUnit(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.standard_unit = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetUnit(int n) {
        try {
            String[] stringArray = new String[]{"unit", "display_unit", "standard_unit"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLUnit(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.unit = "Not specified";
            attributeInfoEx.display_unit = "Not specified";
            attributeInfoEx.standard_unit = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULUnit(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.unit = "";
            attributeInfoEx.display_unit = "";
            attributeInfoEx.standard_unit = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULUnit(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.unit = "NaN";
            attributeInfoEx.display_unit = "NaN";
            attributeInfoEx.standard_unit = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getMin(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).min;
    }

    String getMax(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).max;
    }

    void setMin(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.min_value = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setMax(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.max_value = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetRange(int n) {
        try {
            String[] stringArray = new String[]{"min_value", "max_value"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLRange(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.min_value = "Not specified";
            attributeInfoEx.max_value = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULRange(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.min_value = "";
            attributeInfoEx.max_value = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULRange(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.min_value = "NaN";
            attributeInfoEx.max_value = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getLabel(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).label;
    }

    String getFormat(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).format;
    }

    void setLabel(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.label = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void setFormat(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.format = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetDisplay(int n) {
        try {
            String[] stringArray = new String[]{"label", "format"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.label = "Not specified";
            attributeInfoEx.format = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.label = "";
            attributeInfoEx.format = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULDisplay(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.label = "NaN";
            attributeInfoEx.format = "NaN";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getDescription(int n) {
        if (this.attInfo == null) {
            this.browseAttributeInfo();
        }
        return ((AttInfo)this.attInfo.get((int)n)).descr;
    }

    void setDescription(int n, String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.description = string;
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetDescription(int n) {
        try {
            String[] stringArray = new String[]{"description"};
            this.db.delete_device_attribute_property(this.devName, this.getAttName(n), stringArray);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetLDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.description = "Not specified";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetULDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.description = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void resetCULDescription(int n) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(this.getAttName(n));
            attributeInfoEx.description = "";
            deviceProxy.set_attribute_info(new AttributeInfoEx[]{attributeInfoEx});
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public String get_alias_attribute(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        String string2 = "select alias from attribute_alias where name='" + string + "'";
        deviceData.insert(string2);
        DeviceData deviceData2 = this.db.command_inout("DbMySqlSelect", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        if (devVarLongStringArray.svalue.length == 1 && devVarLongStringArray.lvalue[0] != 0) {
            return devVarLongStringArray.svalue[0];
        }
        return "None";
    }

    void setAlias(int n, String string) {
        try {
            String string2 = this.devName + "/" + this.getAttName(n);
            if (string.equalsIgnoreCase("none") || string.length() == 0) {
                String string3 = this.get_alias_attribute(string2);
                this.db.delete_attribute_alias(string3);
            } else {
                this.db.put_attribute_alias(string2, string);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    String getAlias(int n) {
        try {
            String string = this.devName + "/" + this.getAttName(n);
            return this.get_alias_attribute(string);
        }
        catch (DevFailed devFailed) {
            return "None";
        }
    }

    void browseAttributeInfo() {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            this.attInfo = new Vector();
            String[] stringArray = deviceProxy.get_attribute_list();
            JiveUtils.sortList(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(stringArray[i]);
                AttInfo attInfo = new AttInfo();
                attInfo.name = stringArray[i];
                if (attributeInfoEx.alarms != null) {
                    attInfo.min_alarm = this.reformat(attributeInfoEx.alarms.min_alarm);
                    attInfo.max_alarm = this.reformat(attributeInfoEx.alarms.max_alarm);
                    attInfo.min_warning = this.reformat(attributeInfoEx.alarms.min_warning);
                    attInfo.max_warning = this.reformat(attributeInfoEx.alarms.max_warning);
                    attInfo.delta_t = this.reformat(attributeInfoEx.alarms.delta_t);
                    attInfo.delta_val = this.reformat(attributeInfoEx.alarms.delta_val);
                } else {
                    attInfo.min_alarm = this.reformat(attributeInfoEx.min_alarm);
                    attInfo.max_alarm = this.reformat(attributeInfoEx.max_alarm);
                    attInfo.min_warning = "None";
                    attInfo.max_warning = "None";
                    attInfo.delta_t = "None";
                    attInfo.delta_val = "None";
                }
                attInfo.unit = this.reformat(attributeInfoEx.unit);
                attInfo.display_unit = this.reformat(attributeInfoEx.display_unit);
                attInfo.standard_unit = this.reformat(attributeInfoEx.standard_unit);
                attInfo.min = this.reformat(attributeInfoEx.min_value);
                attInfo.max = this.reformat(attributeInfoEx.max_value);
                attInfo.format = this.reformat(attributeInfoEx.format);
                attInfo.label = this.reformat(attributeInfoEx.label);
                attInfo.descr = this.reformat(attributeInfoEx.description);
                this.attInfo.add(attInfo);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public boolean isTango8() {
        try {
            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
            CommandInfo[] commandInfoArray = deviceProxy.command_list_query();
            boolean bl = false;
            int n = 0;
            while (!bl && n < commandInfoArray.length) {
                bl = commandInfoArray[n].cmd_name.equalsIgnoreCase("ZmqEventSubscriptionChange");
                if (bl) continue;
                ++n;
            }
            return bl;
        }
        catch (DevFailed devFailed) {
            return false;
        }
    }

    public void restartDevice() {
        try {
            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(this.devName);
            deviceProxy.command_inout("DevRestart", deviceData);
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    private String reformat(String string) {
        if (string.equalsIgnoreCase("Not specified") || string.equalsIgnoreCase("No standard unit") || string.equalsIgnoreCase("No unit") || string.equalsIgnoreCase("No description") || string.equalsIgnoreCase("No display unit")) {
            return "None";
        }
        return string;
    }

    class AttInfo {
        String name;
        String min_alarm;
        String max_alarm;
        String min_warning;
        String max_warning;
        String delta_t;
        String delta_val;
        String unit;
        String display_unit;
        String standard_unit;
        String min;
        String max;
        String format;
        String label;
        String descr;

        AttInfo() {
        }
    }
}

