/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.ProgressFrame;
import jive3.TaskSingleAttributeNode;

public class SingleAttributePanel
extends JPanel
implements ActionListener {
    private static final int NB_ROW = 31;
    private TaskSingleAttributeNode[] source = null;
    private JTable attTable;
    private DefaultTableModel attModel;
    MultiLineCellEditor editor;
    private JButton refreshBtn;
    private JButton applyBtn;
    private boolean[] updatedProp = new boolean[31];

    public SingleAttributePanel() {
        this.setLayout(new BorderLayout());
        this.attModel = new DefaultTableModel(){

            public Class getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && !JiveUtils.readOnly && n != 0 && n != 3 && n != 6 && n != 10 && n != 12 && n != 15 && n != 19 && n != 22 && n != 29;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!object.equals(this.getValueAt(n, n2))) {
                    super.setValueAt(object, n, n2);
                    SingleAttributePanel.this.applyBtn.setEnabled(true);
                    ((SingleAttributePanel)SingleAttributePanel.this).updatedProp[n] = true;
                }
            }
        };
        this.attTable = new JTable(this.attModel);
        this.editor = new MultiLineCellEditor(this.attTable);
        this.attTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer(true, true);
        this.attTable.setDefaultRenderer(String.class, multiLineCellRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.attTable);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.add((Component)jPanel, "South");
        this.refreshBtn = new JButton("Refresh");
        this.refreshBtn.addActionListener(this);
        jPanel.add(this.refreshBtn);
        this.applyBtn = new JButton("Apply");
        this.applyBtn.addActionListener(this);
        jPanel.add(this.applyBtn);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.setBorder(titledBorder);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshBtn) {
            this.refreshValue();
        } else if (object == this.applyBtn) {
            this.saveChange();
        }
    }

    public void setSource(TaskSingleAttributeNode[] taskSingleAttributeNodeArray) {
        this.source = taskSingleAttributeNodeArray;
        this.refreshValue();
    }

    public boolean hasChanged() {
        return this.applyBtn.isEnabled();
    }

    public void saveChange() {
        int n = this.getNbUpdated() * this.source.length;
        int n2 = 0;
        if (n > 1) {
            ProgressFrame.displayProgress("Updating properties");
        }
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            block24: for (int j = 0; j < this.source.length; ++j) {
                ProgressFrame.setProgress("Applying " + this.source[j].getTitle(), ++n2 * 100 / n);
                switch (i) {
                    case 1: 
                    case 2: {
                        boolean bl = ((String)this.attModel.getValueAt(1, 1)).equalsIgnoreCase("true");
                        String string = (String)this.attModel.getValueAt(2, 1);
                        this.source[j].setAttributePolling(bl, string);
                        continue block24;
                    }
                    case 4: {
                        String string = (String)this.attModel.getValueAt(4, 1);
                        this.source[j].setAbsoluteChange(string);
                        continue block24;
                    }
                    case 5: {
                        String string = (String)this.attModel.getValueAt(5, 1);
                        this.source[j].setRelativeChange(string);
                        continue block24;
                    }
                    case 7: {
                        String string = (String)this.attModel.getValueAt(7, 1);
                        this.source[j].setArchAbsoluteChange(string);
                        continue block24;
                    }
                    case 8: {
                        String string = (String)this.attModel.getValueAt(8, 1);
                        this.source[j].setArchRelativeChange(string);
                        continue block24;
                    }
                    case 9: {
                        String string = (String)this.attModel.getValueAt(9, 1);
                        this.source[j].setArchPeriod(string);
                        continue block24;
                    }
                    case 11: {
                        String string = (String)this.attModel.getValueAt(11, 1);
                        this.source[j].setPeriod(string);
                        continue block24;
                    }
                    case 13: {
                        String string = (String)this.attModel.getValueAt(13, 1);
                        this.source[j].setLabel(string);
                        continue block24;
                    }
                    case 14: {
                        String string = (String)this.attModel.getValueAt(14, 1);
                        this.source[j].setFormat(string);
                        continue block24;
                    }
                    case 16: {
                        String string = (String)this.attModel.getValueAt(16, 1);
                        this.source[j].setUnit(string);
                        continue block24;
                    }
                    case 17: {
                        String string = (String)this.attModel.getValueAt(17, 1);
                        this.source[j].setDisplayUnit(string);
                        continue block24;
                    }
                    case 18: {
                        String string = (String)this.attModel.getValueAt(18, 1);
                        this.source[j].setStandardUnit(string);
                        continue block24;
                    }
                    case 20: {
                        String string = (String)this.attModel.getValueAt(20, 1);
                        this.source[j].setMin(string);
                        continue block24;
                    }
                    case 21: {
                        String string = (String)this.attModel.getValueAt(21, 1);
                        this.source[j].setMax(string);
                        continue block24;
                    }
                    case 23: {
                        String string = (String)this.attModel.getValueAt(23, 1);
                        this.source[j].setMinAlarm(string);
                        continue block24;
                    }
                    case 24: {
                        String string = (String)this.attModel.getValueAt(24, 1);
                        this.source[j].setMaxAlarm(string);
                        continue block24;
                    }
                    case 25: {
                        String string = (String)this.attModel.getValueAt(25, 1);
                        this.source[j].setMinWarning(string);
                        continue block24;
                    }
                    case 26: {
                        String string = (String)this.attModel.getValueAt(26, 1);
                        this.source[j].setMaxWarning(string);
                        continue block24;
                    }
                    case 27: {
                        String string = (String)this.attModel.getValueAt(27, 1);
                        this.source[j].setDeltaT(string);
                        continue block24;
                    }
                    case 28: {
                        String string = (String)this.attModel.getValueAt(28, 1);
                        this.source[j].setDeltaVal(string);
                        continue block24;
                    }
                    case 30: {
                        String string = (String)this.attModel.getValueAt(30, 1);
                        this.source[j].setDescr(string);
                    }
                }
            }
        }
        this.refreshValue();
        ProgressFrame.hideProgress();
    }

    private int getNbUpdated() {
        int n = 0;
        for (int i = 0; i < this.updatedProp.length; ++i) {
            if (!this.updatedProp[i]) continue;
            ++n;
        }
        return n;
    }

    private void refreshValue() {
        if (this.source != null) {
            String string = this.source.length == 1 ? "Attribute configuration [" + this.source[0].getTitle() + "]" : "Attribute configuration [" + this.source.length + " attributes selected]";
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string);
            this.setBorder(titledBorder);
            this.source[0].browseAttributeInfo();
            this.source[0].updatePollingInfo();
            for (int i = 0; i < 31; ++i) {
                this.updatedProp[i] = false;
            }
            this.applyBtn.setEnabled(false);
            Object[] objectArray = new String[]{"Name", "Value"};
            Object[][] objectArray2 = new Object[31][2];
            objectArray2[0][0] = "/BPolling";
            objectArray2[0][1] = "";
            objectArray2[1][0] = "Is Polled";
            objectArray2[1][1] = Boolean.toString(this.source[0].isPolled());
            objectArray2[2][0] = "Polling Period";
            objectArray2[2][1] = this.source[0].getPollingPeriod();
            objectArray2[3][0] = "/BChange Event";
            objectArray2[3][1] = "";
            objectArray2[4][0] = "Absolute";
            objectArray2[4][1] = this.source[0].getAbsoluteChange();
            objectArray2[5][0] = "Relative";
            objectArray2[5][1] = this.source[0].getRelativeChange();
            objectArray2[6][0] = "/BArchive Event";
            objectArray2[6][1] = "";
            objectArray2[7][0] = "Absolute";
            objectArray2[7][1] = this.source[0].getArchAbsoluteChange();
            objectArray2[8][0] = "Relative";
            objectArray2[8][1] = this.source[0].getArchRelativeChange();
            objectArray2[9][0] = "Period";
            objectArray2[9][1] = this.source[0].getArchPeriod();
            objectArray2[10][0] = "/BPeriodic Event";
            objectArray2[10][1] = "";
            objectArray2[11][0] = "Period";
            objectArray2[11][1] = this.source[0].getPeriodic();
            objectArray2[12][0] = "/BDisplay";
            objectArray2[12][1] = "";
            objectArray2[13][0] = "Label";
            objectArray2[13][1] = this.source[0].getLabel();
            objectArray2[14][0] = "Format";
            objectArray2[14][1] = this.source[0].getFormat();
            objectArray2[15][0] = "/BUnit";
            objectArray2[15][1] = "";
            objectArray2[16][0] = "Unit";
            objectArray2[16][1] = this.source[0].getUnit();
            objectArray2[17][0] = "Display Unit";
            objectArray2[17][1] = this.source[0].getDisplayUnit();
            objectArray2[18][0] = "Standard Unit";
            objectArray2[18][1] = this.source[0].getStandardUnit();
            objectArray2[19][0] = "/BRange";
            objectArray2[19][1] = "";
            objectArray2[20][0] = "Min value";
            objectArray2[20][1] = this.source[0].getMin();
            objectArray2[21][0] = "Max value";
            objectArray2[21][1] = this.source[0].getMax();
            objectArray2[22][0] = "/BAlarms";
            objectArray2[22][1] = "";
            objectArray2[23][0] = "Min Alarm";
            objectArray2[23][1] = this.source[0].getMinAlarm();
            objectArray2[24][0] = "Max Alarm";
            objectArray2[24][1] = this.source[0].getMaxAlarm();
            objectArray2[25][0] = "Min Warning";
            objectArray2[25][1] = this.source[0].getMinWarning();
            objectArray2[26][0] = "Max Warning";
            objectArray2[26][1] = this.source[0].getMaxWarning();
            objectArray2[27][0] = "Delta T";
            objectArray2[27][1] = this.source[0].getDeltaT();
            objectArray2[28][0] = "Delta Val";
            objectArray2[28][1] = this.source[0].getDeltaVal();
            objectArray2[29][0] = "/BDescription";
            objectArray2[29][1] = "";
            objectArray2[30][0] = "Description";
            objectArray2[30][1] = this.source[0].getDescr();
            this.attModel.setDataVector(objectArray2, objectArray);
            this.attTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.editor.updateRows();
        } else {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
            this.setBorder(titledBorder);
        }
    }
}

