/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jive.DevWizard;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.WizardPanel;

class DevicePanel
extends WizardPanel {
    String className;
    String serverName;
    JComboBox deviceCombo;
    JLabel deviceLabel;

    public DevicePanel(DevWizard devWizard, String string, String string2) {
        this.setLayout(null);
        this.parent = devWizard;
        this.className = string2;
        this.serverName = string;
        this.deviceLabel = new JLabel("Device name");
        this.deviceLabel.setFont(DevWizard.wizFont);
        this.deviceLabel.setBounds(10, 30, 100, 25);
        this.add(this.deviceLabel);
        this.deviceCombo = new JComboBox();
        this.deviceCombo.setEditable(true);
        this.deviceCombo.setFont(DevWizard.wizFont);
        this.deviceCombo.setBounds(115, 30, 160, 25);
        this.add(this.deviceCombo);
        try {
            Database database = ApiUtil.get_db_obj();
            String[] stringArray = database.get_device_name(string, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                this.deviceCombo.addItem(stringArray[i]);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        this.deviceCombo.setSelectedItem(null);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/device_wz.gif"));
    }

    @Override
    public String getTitle() {
        return "Device Declaration of Class \"" + this.className + "\"";
    }

    @Override
    public String getDescription() {
        return "It is now time to give a device name for the '" + this.className + "' class. " + "If this device does not already exit, it will be added. Otherwise, the " + "server's device list remains unchanged.\n" + "Click [Next] to edit device properties.";
    }

    @Override
    public boolean getNextState() {
        return true;
    }

    @Override
    public boolean next() {
        String string = (String)this.deviceCombo.getSelectedItem();
        if (string == null || string.length() == 0) {
            JiveUtils.showJiveError("Please enter a device name.");
            return false;
        }
        try {
            Database database = ApiUtil.get_db_obj();
            if (!this.deviceExists(string, this.serverName, this.className)) {
                database.add_device(string, this.className, this.serverName);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            return false;
        }
        boolean bl = false;
        int n = this.parent.getPanels().indexOf(this);
        if (n < this.parent.getPanels().size() - 1) {
            bl = this.parent.getPanel(n + 1) instanceof PropertyPanel;
        }
        if (!bl) {
            try {
                DeviceData deviceData = new DeviceData();
                deviceData.insert(this.className);
                DeviceProxy deviceProxy = new DeviceProxy("dserver/" + this.serverName);
                DeviceData deviceData2 = deviceProxy.command_inout("QueryWizardDevProperty", deviceData);
                String[] stringArray = deviceData2.extractStringArray();
                for (int i = 0; i < stringArray.length; i += 3) {
                    this.parent.addPanel(n + 1 + i / 3, new PropertyPanel(this.parent, 1, this.serverName, string, stringArray[i], stringArray[i + 1], stringArray[i + 2], this.className));
                }
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
                return false;
            }
        } else {
            boolean bl2 = false;
            ++n;
            while (n < this.parent.getPanels().size() && !bl2) {
                bl2 = !(this.parent.getPanel(n) instanceof PropertyPanel);
                if (bl2) continue;
                ((PropertyPanel)this.parent.getPanel(n)).setEntityName(string);
                ++n;
            }
        }
        return true;
    }

    @Override
    public boolean back() {
        return true;
    }
}

