/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.Subtract;

public class MMultiply
extends Multiply
implements BinaryOperatorI {
    protected Add add = new Add();
    protected Subtract sub = new Subtract();

    public MMultiply() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        Object object = this.mul(e2, e);
        stack.push(object);
    }

    public Object mul(Object object, Object object2) throws ParseException {
        if (object instanceof MatrixValueI && object2 instanceof MatrixValueI) {
            return this.mul((MatrixValueI)object, (MatrixValueI)object2);
        }
        if (object instanceof MatrixValueI) {
            MatrixValueI matrixValueI = (MatrixValueI)object;
            MatrixValueI matrixValueI2 = Tensor.getInstance(matrixValueI.getDim());
            for (int i = 0; i < matrixValueI2.getNumEles(); ++i) {
                matrixValueI2.setEle(i, super.mul(matrixValueI.getEle(i), object2));
            }
            return matrixValueI2;
        }
        if (object2 instanceof MatrixValueI) {
            MatrixValueI matrixValueI = (MatrixValueI)object2;
            MatrixValueI matrixValueI3 = Tensor.getInstance(matrixValueI.getDim());
            for (int i = 0; i < matrixValueI3.getNumEles(); ++i) {
                matrixValueI3.setEle(i, super.mul(object, matrixValueI.getEle(i)));
            }
            return matrixValueI3;
        }
        return super.mul(object, object2);
    }

    public Object mul(MatrixValueI matrixValueI, MatrixValueI matrixValueI2) throws ParseException {
        Dimensions dimensions = this.calcDim(matrixValueI.getDim(), matrixValueI2.getDim());
        MatrixValueI matrixValueI3 = Tensor.getInstance(dimensions);
        return this.calcValue(matrixValueI3, matrixValueI, matrixValueI2);
    }

    public Dimensions calcDim(Dimensions dimensions, Dimensions dimensions2) throws ParseException {
        int n = dimensions.rank();
        int n2 = dimensions2.rank();
        block0 : switch (n) {
            case 0: {
                return dimensions2;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                    case 1: {
                        return Dimensions.valueOf(dimensions.getFirstDim(), dimensions2.getFirstDim());
                    }
                    case 2: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions2.getLastDim());
                    }
                    default: {
                        throw new ParseException("Sorry I don't know how to multiply a vector by a tensor");
                    }
                }
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                    case 1: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions.getFirstDim());
                    }
                    case 2: {
                        if (dimensions.getLastDim() != dimensions2.getFirstDim()) break block0;
                        return Dimensions.valueOf(dimensions.getFirstDim(), dimensions2.getLastDim());
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 0: {
                        return dimensions;
                    }
                }
            }
        }
        throw new ParseException("Dimensions for multiply do not match: " + dimensions + " " + dimensions2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatrixValueI calcValue(MatrixValueI matrixValueI, MatrixValueI matrixValueI2, MatrixValueI matrixValueI3) throws ParseException {
        if (matrixValueI2 instanceof Scaler) {
            if (matrixValueI3 instanceof Scaler) {
                matrixValueI.setEle(0, super.mul(matrixValueI2.getEle(0), matrixValueI3.getEle(0)));
                return matrixValueI;
            } else if (matrixValueI3 instanceof MVector) {
                for (int i = 0; i < matrixValueI3.getDim().getFirstDim(); ++i) {
                    matrixValueI.setEle(i, super.mul(matrixValueI2.getEle(0), matrixValueI3.getEle(i)));
                }
                return matrixValueI;
            } else if (matrixValueI3 instanceof Matrix) {
                Matrix matrix = (Matrix)matrixValueI3;
                Matrix matrix2 = (Matrix)matrixValueI;
                for (int i = 0; i < matrix.getNumRows(); ++i) {
                    for (int j = 0; j < matrix.getNumCols(); ++j) {
                        matrix2.setEle(i, j, super.mul(matrixValueI2.getEle(0), matrix.getEle(i, j)));
                    }
                }
                return matrixValueI;
            } else {
                for (int i = 0; i < matrixValueI3.getDim().numEles(); ++i) {
                    matrixValueI.setEle(i, super.mul(matrixValueI2.getEle(0), matrixValueI3.getEle(i)));
                }
            }
            return matrixValueI;
        } else if (matrixValueI2 instanceof MVector) {
            if (matrixValueI3 instanceof Scaler) {
                for (int i = 0; i < matrixValueI2.getDim().getFirstDim(); ++i) {
                    matrixValueI.setEle(i, super.mul(matrixValueI2.getEle(i), matrixValueI3.getEle(0)));
                }
                return matrixValueI;
            } else if (matrixValueI3 instanceof MVector) {
                Matrix matrix = (Matrix)matrixValueI;
                for (int i = 0; i < matrixValueI2.getDim().getFirstDim(); ++i) {
                    for (int j = 0; j < matrixValueI3.getDim().getFirstDim(); ++j) {
                        matrix.setEle(i, j, super.mul(matrixValueI2.getEle(i), matrixValueI3.getEle(j)));
                    }
                }
                return matrixValueI;
            } else {
                if (!(matrixValueI3 instanceof Matrix)) throw new ParseException("Sorry I don't know how to multiply a vector by a tensor");
                MVector mVector = (MVector)matrixValueI2;
                Matrix matrix = (Matrix)matrixValueI3;
                if (mVector.getNumEles() != matrix.getNumRows()) {
                    throw new ParseException("Multiply Matrix , Vector: Miss match in sizes (" + mVector.getNumEles() + "," + matrix.getNumRows() + ")!");
                }
                for (int i = 0; i < matrix.getNumCols(); ++i) {
                    Object object = super.mul(mVector.getEle(0), matrix.getEle(0, i));
                    for (int j = 1; j < matrix.getNumRows(); ++j) {
                        object = this.add.add(object, super.mul(mVector.getEle(j), matrix.getEle(j, i)));
                    }
                    matrixValueI.setEle(i, object);
                }
            }
            return matrixValueI;
        } else if (matrixValueI2 instanceof Matrix) {
            if (matrixValueI3 instanceof Scaler) {
                Matrix matrix = (Matrix)matrixValueI2;
                Matrix matrix3 = (Matrix)matrixValueI;
                for (int i = 0; i < matrix.getNumRows(); ++i) {
                    for (int j = 0; j < matrix.getNumCols(); ++j) {
                        matrix3.setEle(i, j, super.mul(matrix.getEle(i, j), matrixValueI3.getEle(0)));
                    }
                }
                return matrixValueI;
            } else if (matrixValueI3 instanceof MVector) {
                Matrix matrix = (Matrix)matrixValueI2;
                MVector mVector = (MVector)matrixValueI3;
                if (matrix.getNumCols() != mVector.getNumEles()) {
                    throw new ParseException("Mat * Vec: Miss match in sizes (" + matrix.getNumCols() + "," + mVector.getNumEles() + ") when trying to add vectors!");
                }
                for (int i = 0; i < matrix.getNumRows(); ++i) {
                    Object object = super.mul(matrix.getEle(i, 0), mVector.getEle(0));
                    for (int j = 1; j < matrix.getNumCols(); ++j) {
                        object = this.add.add(object, super.mul(matrix.getEle(i, j), mVector.getEle(j)));
                    }
                    matrixValueI.setEle(i, object);
                }
                return matrixValueI;
            } else {
                if (!(matrixValueI3 instanceof Matrix)) throw new ParseException("Sorry I don't know how to multiply a matrix by a tensor");
                Matrix matrix = (Matrix)matrixValueI2;
                Matrix matrix4 = (Matrix)matrixValueI3;
                Matrix matrix5 = (Matrix)matrixValueI;
                if (matrix.getNumCols() != matrix4.getNumRows()) {
                    throw new ParseException("Multiply matrix,matrix: Miss match in number of dims (" + matrix.getNumCols() + "," + matrix4.getNumRows() + ")!");
                }
                int n = matrix.getNumRows();
                int n2 = matrix.getNumCols();
                int n3 = matrix4.getNumCols();
                Object[][] objectArray = matrix.getEles();
                Object[][] objectArray2 = matrix4.getEles();
                Object[][] objectArray3 = matrix5.getEles();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        Object object = this.mul(objectArray[i][0], objectArray2[0][j]);
                        for (int k = 1; k < n2; ++k) {
                            object = this.add.add(object, this.mul(objectArray[i][k], objectArray2[k][j]));
                        }
                        objectArray3[i][j] = object;
                    }
                }
            }
            return matrixValueI;
        } else {
            if (!(matrixValueI3 instanceof Scaler)) throw new ParseException("Sorry I don't know how to multiply a tensor by a vector");
            for (int i = 0; i < matrixValueI2.getDim().numEles(); ++i) {
                matrixValueI.setEle(i, super.mul(matrixValueI2.getEle(i), matrixValueI3.getEle(0)));
            }
        }
        return matrixValueI;
    }
}

