/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import org.lsmp.djep.groupJep.groups.Group;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.JEP;

public class Quaternions
extends Group
implements RingI {
    private Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    private Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    private Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    private Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    public Number getZERO() {
        return this.ZERO;
    }

    public Number getONE() {
        return this.ONE;
    }

    public Number getInverse(Number number) {
        Quaternion quaternion = (Quaternion)number;
        return new Quaternion(-quaternion.x, -quaternion.y, -quaternion.z, -quaternion.w);
    }

    public Number add(Number number, Number number2) {
        Quaternion quaternion = (Quaternion)number;
        Quaternion quaternion2 = (Quaternion)number2;
        return new Quaternion(quaternion.x + quaternion2.x, quaternion.y + quaternion2.y, quaternion.z + quaternion2.z, quaternion.w + quaternion2.w);
    }

    public Number sub(Number number, Number number2) {
        Quaternion quaternion = (Quaternion)number;
        Quaternion quaternion2 = (Quaternion)number2;
        return new Quaternion(quaternion.x - quaternion2.x, quaternion.y - quaternion2.y, quaternion.z - quaternion2.z, quaternion.w - quaternion2.w);
    }

    public Number mul(Number number, Number number2) {
        Quaternion quaternion = (Quaternion)number;
        Quaternion quaternion2 = (Quaternion)number2;
        return new Quaternion(quaternion.x * quaternion2.x - quaternion.y * quaternion2.y - quaternion.z * quaternion2.z - quaternion.w * quaternion2.w, quaternion.x * quaternion2.y - quaternion.y * quaternion2.x + quaternion.z * quaternion2.w - quaternion.w * quaternion2.z, quaternion.x * quaternion2.z - quaternion.y * quaternion2.w + quaternion.z * quaternion2.x + quaternion.w * quaternion2.y, quaternion.x * quaternion2.w - quaternion.y * quaternion2.z - quaternion.z * quaternion2.y + quaternion.w * quaternion2.x);
    }

    public boolean equals(Number number, Number number2) {
        Quaternion quaternion = (Quaternion)number;
        Quaternion quaternion2 = (Quaternion)number2;
        return quaternion.x == quaternion2.x && quaternion.y == quaternion2.y && quaternion.z == quaternion2.z && quaternion.w == quaternion2.w;
    }

    public Number valueOf(String string) {
        return new Quaternion(Double.parseDouble(string), 0.0, 0.0, 0.0);
    }

    public void addStandardConstants(JEP jEP) {
        super.addStandardConstants(jEP);
        jEP.addConstant("i", this.I);
        jEP.addConstant("j", this.J);
        jEP.addConstant("k", this.K);
    }

    public String toString() {
        return "Quaternions";
    }

    public static class Quaternion
    extends Number {
        double x;
        double y;
        double z;
        double w;

        public Quaternion(double d, double d2, double d3, double d4) {
            this.w = d;
            this.y = d2;
            this.z = d3;
            this.w = d4;
        }

        public double doubleValue() {
            return this.x;
        }

        public float floatValue() {
            return (float)this.x;
        }

        public int intValue() {
            return (int)this.x;
        }

        public long longValue() {
            return (long)this.x;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (this.x != 0.0) {
                stringBuffer.append(this.x);
                bl = true;
            }
            if (this.y != 0.0) {
                if (bl && this.y > 0.0) {
                    stringBuffer.append("+");
                }
                if (this.y != 1.0) {
                    if (this.y == -1.0) {
                        stringBuffer.append("-");
                    } else {
                        stringBuffer.append(this.y);
                    }
                }
                stringBuffer.append("i");
                bl = true;
            }
            if (this.z != 0.0) {
                if (bl && this.z > 0.0) {
                    stringBuffer.append("+");
                }
                if (this.z != 1.0) {
                    if (this.z == -1.0) {
                        stringBuffer.append("-");
                    } else {
                        stringBuffer.append(this.z);
                    }
                }
                stringBuffer.append("j");
                bl = true;
            }
            if (this.w != 0.0) {
                if (bl && this.w > 0.0) {
                    stringBuffer.append("+");
                }
                if (this.w != 1.0) {
                    if (this.w == -1.0) {
                        stringBuffer.append("-");
                    } else {
                        stringBuffer.append(this.w);
                    }
                }
                stringBuffer.append("k");
                bl = true;
            }
            if (!bl) {
                stringBuffer.append("0");
            }
            return stringBuffer.toString();
        }
    }
}

