/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String c2hex(Color c) {
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }

    public static String f2hex(float f) {
        int i = Float.floatToIntBits(f);
        char[] buf9 = new char[9];
        buf9[0] = 35;
        for (int pos = 8; pos >= 1; --pos) {
            buf9[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf9);
    }

    public static double[] getMinMax(double[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] getMinMax(float[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] toDouble(float[] a) {
        int len = a.length;
        double[] d = new double[len];
        for (int i = 0; i < len; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static float[] toFloat(double[] a) {
        int len = a.length;
        float[] f = new float[len];
        for (int i = 0; i < len; ++i) {
            f[i] = (float)a[i];
        }
        return f;
    }

    public static String fixNewLines(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r') continue;
            chars[i] = 10;
        }
        return new String(chars);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            Double d = new Double(s);
            defaultValue = d;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double parseDouble(String s) {
        return Tools.parseDouble(s, Double.NaN);
    }

    public static int getDecimalPlaces(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 2;
        if (n < 100.0) {
            digits = 3;
        }
        if (n < 0.1) {
            digits = 4;
        }
        if (n < 0.01) {
            digits = 5;
        }
        if (n < 0.001) {
            digits = 6;
        }
        if (n < 1.0E-4) {
            digits = 7;
        }
        return digits;
    }

    public static String[] split(String str) {
        return Tools.split(str, " \t\n\r");
    }

    public static String[] split(String str, String delim) {
        String[] strings;
        if (delim.equals("\n")) {
            return Tools.splitLines(str);
        }
        StringTokenizer t = new StringTokenizer(str, delim);
        int tokens = t.countTokens();
        if (tokens > 0) {
            strings = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                strings[i] = t.nextToken();
            }
        } else {
            strings = new String[]{str};
            tokens = 1;
        }
        return strings;
    }

    static String[] splitLines(String str) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(str));
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }
}

