/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.util.Hashtable;

public class PlugInFilterRunner
implements Runnable,
DialogListener {
    private String command;
    private Object theFilter;
    private ImagePlus imp;
    private int flags;
    private boolean snapshotDone;
    private boolean previewCheckboxOn;
    private boolean bgPreviewOn;
    private boolean bgKeepPreview;
    private Thread previewThread;
    private GenericDialog gd;
    private Checkbox previewCheckbox;
    private long previewTime;
    private boolean ipChanged;
    private int processedAsPreview;
    private Hashtable slicesForThread;
    Hashtable sliceForThread = new Hashtable();
    private int nPasses;
    private int pass;
    private boolean doStack;

    public PlugInFilterRunner(Object theFilter, String command, String arg) {
        ImageWindow win;
        this.theFilter = theFilter;
        this.command = command;
        this.imp = WindowManager.getCurrentImage();
        this.flags = ((PlugInFilter)theFilter).setup(arg, this.imp);
        if ((this.flags & 0x1000) != 0) {
            return;
        }
        if (!this.checkImagePlus(this.imp, this.flags, command)) {
            return;
        }
        if ((this.flags & 0x200) != 0) {
            this.imp = null;
        }
        Roi roi = null;
        if (this.imp != null) {
            roi = this.imp.getRoi();
            if (roi != null) {
                roi.endPaste();
            }
            if (!this.imp.lock()) {
                return;
            }
            this.nPasses = this.imp.getProcessor().getNChannels();
        }
        if (theFilter instanceof ExtendedPlugInFilter) {
            boolean keepPreviewFlag;
            this.flags = ((ExtendedPlugInFilter)theFilter).showDialog(this.imp, command, this);
            if (this.snapshotDone) {
                Undo.setup(1, this.imp);
            }
            boolean bl = keepPreviewFlag = (this.flags & 0x1000000) != 0;
            if (keepPreviewFlag && this.imp != null && this.previewThread != null && this.ipChanged && this.previewCheckbox != null && this.previewCheckboxOn) {
                this.bgKeepPreview = true;
                this.waitForPreviewDone();
                this.processedAsPreview = this.imp.getCurrentSlice();
            } else {
                this.killPreview();
                this.previewTime = 0L;
            }
        }
        if ((this.flags & 0x1000) != 0) {
            if (this.imp != null) {
                this.imp.unlock();
            }
            return;
        }
        if (this.imp == null) {
            ((PlugInFilter)theFilter).run(null);
            return;
        }
        int slices = this.imp.getStackSize();
        this.doStack = slices > 1 && (this.flags & 0x20) != 0;
        this.imp.startTiming();
        if (this.doStack || this.processedAsPreview == 0) {
            IJ.showStatus(command + (this.doStack ? " (Stack)..." : "..."));
            ImageProcessor ip = this.imp.getProcessor();
            this.pass = 0;
            if (!this.doStack) {
                FloatProcessor fp = null;
                this.prepareProcessor(ip, this.imp);
                this.announceSliceNumber(this.imp.getCurrentSlice());
                if (theFilter instanceof ExtendedPlugInFilter) {
                    ((ExtendedPlugInFilter)theFilter).setNPasses(this.nPasses);
                }
                if ((this.flags & 0x80) == 0) {
                    boolean disableUndo;
                    boolean bl = disableUndo = Prefs.disableUndo || (this.flags & 0x100) != 0;
                    if (!disableUndo) {
                        ip.snapshot();
                        this.snapshotDone = true;
                    }
                }
                this.processOneImage(ip, fp, this.snapshotDone);
                if ((this.flags & 0x80) == 0) {
                    if (this.snapshotDone) {
                        Undo.setup(1, this.imp);
                    } else {
                        Undo.reset();
                    }
                }
                if ((this.flags & 0x80) == 0) {
                    ip.resetBinaryThreshold();
                }
            } else {
                Undo.reset();
                IJ.resetEscape();
                int slicesToDo = this.processedAsPreview != 0 ? slices - 1 : slices;
                this.nPasses *= slicesToDo;
                if (theFilter instanceof ExtendedPlugInFilter) {
                    ((ExtendedPlugInFilter)theFilter).setNPasses(this.nPasses);
                }
                int threads = 1;
                if ((this.flags & 0x8000) != 0) {
                    threads = Prefs.getThreads();
                    if (threads > slicesToDo) {
                        threads = slicesToDo;
                    }
                    if (threads > 1) {
                        this.slicesForThread = new Hashtable(threads - 1);
                    }
                }
                int startSlice = 1;
                for (int i = 1; i < threads; ++i) {
                    int endSlice = slicesToDo * i / threads;
                    if (this.processedAsPreview != 0 && this.processedAsPreview <= endSlice) {
                        ++endSlice;
                    }
                    Thread bgThread = new Thread((Runnable)this, command + " " + startSlice + "-" + endSlice);
                    this.slicesForThread.put(bgThread, new int[]{startSlice, endSlice});
                    bgThread.start();
                    startSlice = endSlice + 1;
                }
                this.processStack(startSlice, slices);
                if (this.slicesForThread != null) {
                    while (this.slicesForThread.size() > 0) {
                        Thread theThread = (Thread)this.slicesForThread.keys().nextElement();
                        try {
                            theThread.join();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.slicesForThread.remove(theThread);
                    }
                }
            }
        }
        if ((this.flags & 0x10000) != 0 && !IJ.escapePressed()) {
            ((PlugInFilter)theFilter).setup("final", this.imp);
        }
        if (IJ.escapePressed()) {
            IJ.showStatus(command + " INTERRUPTED");
        } else {
            IJ.showTime(this.imp, this.imp.getStartTime() - this.previewTime, command + ": ", this.doStack ? slices : 1);
        }
        IJ.showProgress(1.0);
        if (this.ipChanged) {
            this.imp.changes = true;
            this.imp.updateAndDraw();
        }
        if ((win = this.imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
        this.imp.unlock();
    }

    private void processStack(int firstSlice, int endSlice) {
        ImageStack stack = this.imp.getStack();
        ImageProcessor ip = stack.getProcessor(firstSlice);
        this.prepareProcessor(ip, this.imp);
        ip.setLineWidth(Line.getWidth());
        FloatProcessor fp = null;
        int slices = this.imp.getNSlices();
        for (int i = firstSlice; i <= endSlice; ++i) {
            if (i == this.processedAsPreview) continue;
            this.announceSliceNumber(i);
            ip.setPixels(stack.getPixels(i));
            this.processOneImage(ip, fp, false);
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            break;
        }
    }

    private void prepareProcessor(ImageProcessor ip, ImagePlus imp) {
        ImageProcessor mask = imp.getMask();
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            ip.setRoi(roi);
        } else {
            ip.setRoi((Roi)null);
        }
        if (imp.getStackSize() > 1) {
            ImageProcessor ip2 = imp.getProcessor();
            double minThreshold = ip2.getMinThreshold();
            double maxThreshold = ip2.getMaxThreshold();
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
        }
        float[] cTable = imp.getCalibration().getCTable();
        ip.setCalibrationTable(cTable);
    }

    private void processOneImage(ImageProcessor ip, FloatProcessor fp, boolean snapshotDone) {
        boolean doMasking;
        Thread thread = Thread.currentThread();
        boolean convertToFloat = (this.flags & 0x2000) != 0 && !(ip instanceof FloatProcessor);
        boolean bl = doMasking = (this.flags & 0x40) != 0 && ip.getMask() != null;
        if (!snapshotDone && (doMasking || (this.flags & 0x4000) != 0 && !convertToFloat)) {
            ip.snapshot();
            this.snapshotDone = true;
        }
        if (convertToFloat) {
            for (int i = 0; i < ip.getNChannels(); ++i) {
                fp = ip.toFloat(i, fp);
                if (thread.isInterrupted()) {
                    return;
                }
                if ((this.flags & 0x4000) != 0) {
                    fp.snapshot();
                }
                if (this.doStack) {
                    IJ.showProgress((double)this.pass / (double)this.nPasses);
                }
                ((PlugInFilter)this.theFilter).run(fp);
                if (thread.isInterrupted()) {
                    return;
                }
                ++this.pass;
                if ((this.flags & 0x80) != 0) continue;
                this.ipChanged = true;
                ip.setPixels(i, fp);
            }
        } else {
            if ((this.flags & 0x80) == 0) {
                this.ipChanged = true;
            }
            if (this.doStack) {
                IJ.showProgress((double)this.pass / (double)this.nPasses);
            }
            ((PlugInFilter)this.theFilter).run(ip);
            ++this.pass;
        }
        if (thread.isInterrupted()) {
            return;
        }
        if (doMasking) {
            ip.reset(ip.getMask());
        }
    }

    private boolean checkImagePlus(ImagePlus imp, int flags, String cmd) {
        boolean imageRequired;
        boolean bl = imageRequired = (flags & 0x200) == 0;
        if (imageRequired && imp == null) {
            IJ.noImage();
            return false;
        }
        if (imageRequired) {
            if (imp.getProcessor() == null) {
                PlugInFilterRunner.wrongType(flags, cmd);
                return false;
            }
            int type = imp.getType();
            switch (type) {
                case 0: {
                    if ((flags & 1) != 0) break;
                    PlugInFilterRunner.wrongType(flags, cmd);
                    return false;
                }
                case 3: {
                    if ((flags & 2) != 0) break;
                    PlugInFilterRunner.wrongType(flags, cmd);
                    return false;
                }
                case 1: {
                    if ((flags & 4) != 0) break;
                    PlugInFilterRunner.wrongType(flags, cmd);
                    return false;
                }
                case 2: {
                    if ((flags & 8) != 0) break;
                    PlugInFilterRunner.wrongType(flags, cmd);
                    return false;
                }
                case 4: {
                    if ((flags & 0x10) != 0) break;
                    PlugInFilterRunner.wrongType(flags, cmd);
                    return false;
                }
            }
            if ((flags & 0x400) != 0 && imp.getRoi() == null) {
                IJ.error(cmd + ": Selection required");
                return false;
            }
            if ((flags & 0x800) != 0 && imp.getStackSize() == 1) {
                IJ.error(cmd + ": Stack required");
                return false;
            }
        }
        return true;
    }

    static void wrongType(int flags, String cmd) {
        String s = "\"" + cmd + "\" requires an image of type:\n \n";
        if ((flags & 1) != 0) {
            s = s + "    8-bit grayscale\n";
        }
        if ((flags & 2) != 0) {
            s = s + "    8-bit color\n";
        }
        if ((flags & 4) != 0) {
            s = s + "    16-bit grayscale\n";
        }
        if ((flags & 8) != 0) {
            s = s + "    32-bit (float) grayscale\n";
        }
        if ((flags & 0x10) != 0) {
            s = s + "    RGB color\n";
        }
        IJ.error(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceSliceNumber(int slice) {
        Hashtable hashtable = this.sliceForThread;
        synchronized (hashtable) {
            Integer number = new Integer(slice);
            this.sliceForThread.put(Thread.currentThread(), number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSliceNumber() {
        Hashtable hashtable = this.sliceForThread;
        synchronized (hashtable) {
            Integer number = (Integer)this.sliceForThread.get(Thread.currentThread());
            return number == null ? -1 : number;
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        try {
            if (thread == this.previewThread) {
                this.runPreview();
            } else if (this.slicesForThread != null && this.slicesForThread.containsKey(thread)) {
                int[] range = (int[])this.slicesForThread.get(thread);
                this.processStack(range[0], range[1]);
            } else {
                IJ.error("PlugInFilterRunner internal error:\nunsolicited background thread");
            }
        }
        catch (Exception err) {
            IJ.beep();
            IJ.log("ERROR: " + err + "\nin " + thread.getName() + "\nat " + err.getStackTrace()[0] + "\nfrom " + err.getStackTrace()[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPreview() {
        if (IJ.debugMode) {
            IJ.log("preview thread started; imp=" + this.imp.getTitle());
        }
        Thread thread = Thread.currentThread();
        ImageProcessor ip = this.imp.getProcessor();
        Roi originalRoi = this.imp.getRoi();
        FloatProcessor fp = null;
        this.prepareProcessor(ip, this.imp);
        this.announceSliceNumber(this.imp.getCurrentSlice());
        if (!this.snapshotDone && (this.flags & 0x80) == 0) {
            ip.snapshot();
            this.snapshotDone = true;
        }
        boolean previewDataOk = false;
        while (this.bgPreviewOn) {
            if (this.previewCheckboxOn) {
                this.gd.previewRunning(true);
            }
            if (this.imp.getRoi() != originalRoi) {
                this.imp.setRoi(originalRoi);
                if (originalRoi != null && originalRoi.isArea()) {
                    ip.setRoi(originalRoi);
                } else {
                    ip.setRoi((Roi)null);
                }
            }
            if (this.ipChanged) {
                ip.reset();
            }
            this.ipChanged = false;
            previewDataOk = false;
            long startTime = System.currentTimeMillis();
            this.pass = 0;
            if (this.theFilter instanceof ExtendedPlugInFilter) {
                ((ExtendedPlugInFilter)this.theFilter).setNPasses(this.nPasses);
            }
            if (!thread.isInterrupted()) {
                this.processOneImage(ip, fp, true);
                IJ.showProgress(1.0);
                if (!thread.isInterrupted()) {
                    previewDataOk = true;
                    this.previewTime = System.currentTimeMillis() - startTime;
                    this.imp.updateAndDraw();
                    if (IJ.debugMode) {
                        IJ.log("preview processing done");
                    }
                }
            }
            this.gd.previewRunning(false);
            IJ.showStatus("");
            PlugInFilterRunner plugInFilterRunner = this;
            synchronized (plugInFilterRunner) {
                if (!this.bgPreviewOn) {
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    previewDataOk = false;
                }
            }
        }
        if (thread.isInterrupted()) {
            previewDataOk = false;
        }
        if (!previewDataOk || !this.bgKeepPreview) {
            this.imp.setRoi(originalRoi);
            if (this.ipChanged) {
                ip.reset();
                this.ipChanged = false;
            }
        }
        this.imp.updateAndDraw();
        this.sliceForThread.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killPreview() {
        if (this.previewThread == null) {
            return;
        }
        PlugInFilterRunner plugInFilterRunner = this;
        synchronized (plugInFilterRunner) {
            this.previewThread.interrupt();
            this.bgPreviewOn = false;
        }
        this.waitForPreviewDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPreviewDone() {
        if (this.previewThread.isAlive()) {
            try {
                this.previewThread.setPriority(Thread.currentThread().getPriority());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        PlugInFilterRunner e = this;
        synchronized (e) {
            this.bgPreviewOn = false;
            this.notify();
        }
        try {
            this.previewThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.previewThread = null;
    }

    public void setDialog(GenericDialog gd) {
        if (gd != null && this.imp != null) {
            this.previewCheckbox = gd.getPreviewCheckbox();
            if (this.previewCheckbox != null) {
                gd.addDialogListener(this);
                this.gd = gd;
            }
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (this.previewCheckbox == null || this.imp == null) {
            return true;
        }
        this.previewCheckboxOn = this.previewCheckbox.getState();
        if (this.previewCheckboxOn && this.previewThread == null) {
            this.bgPreviewOn = true;
            this.previewThread = new Thread((Runnable)this, this.command + " Preview");
            int priority = Thread.currentThread().getPriority() - 2;
            if (priority < 1) {
                priority = 1;
            }
            this.previewThread.setPriority(priority);
            this.previewThread.start();
            if (IJ.debugMode) {
                IJ.log(this.command + " Preview thread was started");
            }
            return true;
        }
        if (this.previewThread != null) {
            if (!this.previewCheckboxOn) {
                this.killPreview();
                return true;
            }
            this.previewThread.interrupt();
        }
        return true;
    }
}

