/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.util;

import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class BeanPropertyVerifier {
    Class bean;
    SimpleBeanInfo beanInfo;
    Map methods = new HashMap();

    public BeanPropertyVerifier(String string, String string2) throws Exception {
        this.bean = Class.forName(string);
        this.beanInfo = (SimpleBeanInfo)Class.forName(string2).newInstance();
        Method[] methodArray = this.bean.getMethods();
        String string3 = string + ".";
        for (int i = 0; i < methodArray.length; ++i) {
            this.methods.put(methodArray[i].getName(), methodArray[i]);
        }
    }

    public boolean verify() {
        return this.verifyProperties();
    }

    public String stripQualifier(String string) {
        if (string.lastIndexOf(".") == -1) {
            return string;
        }
        String string2 = string.substring(string.lastIndexOf("."));
        return string2;
    }

    public boolean verifyProperties() {
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        boolean bl = true;
        if (propertyDescriptorArray == null) {
            return true;
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string = null;
            String string2 = null;
            try {
                string = this.stripQualifier(propertyDescriptor.getReadMethod().getName());
                bl = bl && this.verifyReadMethod((Method)this.methods.get(string));
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
            try {
                string2 = this.stripQualifier(propertyDescriptor.getWriteMethod().getName());
                bl = bl && this.verifyWriteMethod((Method)this.methods.get(string2));
                continue;
            }
            catch (NullPointerException nullPointerException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean verifyReadMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 0) {
            System.out.println(this.bean.getName() + " does not have a " + method.getName() + " with 0 argument");
            return false;
        }
        return true;
    }

    public boolean verifyWriteMethod(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            System.out.println(this.bean.getName() + " does not have a " + method.getName() + " with 1 argument");
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = string + "BeanInfo";
        String string3 = "Verifying " + string;
        System.out.print(string3);
        for (int i = 0; i < 75 - string3.length(); ++i) {
            System.out.print(".");
        }
        if (new BeanPropertyVerifier(string, string2).verify()) {
            System.out.println("Ok");
            System.exit(0);
        }
        System.exit(1);
    }
}

