/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

public class BooleanSpectrumHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public BooleanSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.attribute = aAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    boolean[] getBooleanSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] blArray = deviceAttribute.extractBooleanArray();
        int n = deviceAttribute.getNbRead();
        if (n == blArray.length) {
            return blArray;
        }
        boolean[] blArray2 = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray2[i] = blArray[i];
        }
        return blArray2;
    }

    boolean[] getBooleanSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        boolean[] blArray = deviceAttribute.extractBooleanArray();
        int n2 = blArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getBooleanSpectrumValue(deviceAttribute);
        }
        boolean[] blArray2 = new boolean[n2];
        int n3 = 0;
        for (int i = n; i < blArray.length; ++i) {
            blArray2[n3] = blArray[i];
            ++n3;
        }
        return blArray2;
    }

    void fireSpectrumValueChanged(boolean[] blArray, long l) {
        this.propChanges.fireBooleanSpectrumEvent((IBooleanSpectrum)((Object)this.attribute), blArray, l);
    }

    void insert(boolean[] blArray) {
        this.attribute.getAttribute().insert(blArray, this.attribute.getXDimension(), this.attribute.getYDimension());
    }

    void addBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.propChanges.addBooleanSpectrumListener(iBooleanSpectrumListener);
    }

    void removeBooleanSpectrumListener(IBooleanSpectrumListener iBooleanSpectrumListener) {
        this.propChanges.removeBooleanSpectrumListener(iBooleanSpectrumListener);
    }

    public String getVersion() {
        return "$Id: BooleanSpectrumHelper.java 15105 2010-09-24 13:11:54Z poncet $";
    }
}

