/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.About;
import explorer.AdminMain;
import explorer.AttributePanel;
import explorer.AttributeTable;
import explorer.AttributeTableModel;
import explorer.CommandTable;
import explorer.CommandTableModel;
import explorer.DeviceList;
import explorer.FileManager;
import explorer.Preferences;
import explorer.Status;
import explorer.ViewerMain;
import explorer.ui.DTMenuBar;
import explorer.ui.Dialog;
import explorer.ui.EditUI;
import explorer.ui.FileHandler;
import explorer.ui.FileUI;
import explorer.ui.RefreshUI;
import explorer.ui.RunUI;
import explorer.ui.UIDialog;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.Splash;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public abstract class Main
implements Status,
FileHandler,
IStatusListener {
    protected static String done = "done";
    protected static String VERSION = "Device Tree 1.8";
    protected AttributePanel attributePanel;
    protected AttributeTable attributeTable;
    protected AttributeTableModel attributeTableModel;
    protected CommandTable commandTable;
    protected CommandTableModel commandTableModel;
    protected DTMenuBar menuBar;
    protected ErrorHistory errorHistory;
    protected ErrorPopup errorPopup;
    protected JFrame mainFrame;
    protected JToolBar refreshBar;
    protected JToolBar fileBar;
    protected File file;
    protected Preferences preferences;
    protected Dialog trendFrame;
    protected JPopupMenu entityPopup;
    protected JPopupMenu treePopup;
    protected JProgressBar progress;
    protected JLabel status;
    protected JSplitPane tableSplit;
    protected JSplitPane viewSplit;
    protected FileManager fileManager;
    protected JCheckBoxMenuItem synchroBox;
    protected Trend globalTrend;
    protected boolean isAdmin;
    protected Splash splash;
    protected boolean runningFromShell = true;
    protected int windowX;
    protected int windowY;
    protected int windowWidth;
    protected int windowHeight;
    protected int tableSplitWidth;
    protected int tableSplitHeight;
    protected int viewSplitDividerLocation;
    protected int tableSplitDividerLocation;
    protected int mainSplitDividerLocation;
    protected RefreshUI refreshui;
    protected boolean fileRecordable = true;
    protected DeviceList deviceList;
    public static final int DEFAULT_WINDOW_X = 50;
    public static final int DEFAULT_WINDOW_Y = 50;
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final int DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION = 200;
    public static final int DEFAULT_TABLE_SPLIT_WIDTH = 800;
    public static final int DEFAULT_TABLE_SPLIT_HEIGHT = 400;
    public static final int DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION = 400;
    public static final int DEFAULT_MAIN_SPLIT_DIVIDER_LOCATION = 290;
    public static final String MAIN_SPLIT_DIVIDER_LOCATION_KEY = "MAIN_SPLIT_DIVIDER_LOCATION";
    public static final String WINDOW_X_KEY = "MAIN_WINDOW_X";
    public static final String WINDOW_Y_KEY = "MAIN_WINDOW_Y";
    public static final String WINDOW_WIDTH_KEY = "MAIN_WINDOW_WIDTH";
    public static final String WINDOW_HEIGHT_KEY = "MAIN_WINDOW_HEIGHT";
    public static final String TABLE_SPLIT_DIVIDER_LOCATION_KEY = "TABLE_SPLIT_DIVIDER_LOCATION";
    public static final String VIEW_SPLIT_DIVIDER_LOCATION_KEY = "VIEW_SPLIT_DIVIDER_LOCATION";
    public static final String TABLE_SPLIT_WIDTH_KEY = "TABLE_SPLIT_WIDTH";
    public static final String TABLE_SPLIT_HEIGHT_KEY = "TABLE_SPLIT_HEIGHT";

    protected void initHelp() {
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up help...");
        }
        HelpWindow.getInstance().setTop("Explorer", this.getClass().getResource("/explorer/html/MainHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Device tree", this.getClass().getResource("/explorer/html/DeviceTreeHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Tool bar", this.getClass().getResource("/explorer/html/ToolBarHelp.html"));
        HelpWindow.getInstance().addCategory("Main", "Menu bar", this.getClass().getResource("/explorer/html/MenuBarHelp.html"));
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up help..." + done);
        }
    }

    protected void initTrend() {
        TitledBorder tb;
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up trend...");
        }
        this.globalTrend = new Trend();
        Font font = new Font("Arial", 0, 10);
        Color color = new Color(150, 0, 0);
        String title = "Trend Panel";
        TitledBorder border = tb = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, color), title, 2, 2, font, color);
        this.globalTrend.setBorder((Border)border);
        this.trendFrame = new Dialog((JComponent)this.globalTrend);
        this.globalTrend.setButtonBarVisible(false);
        this.globalTrend.disableButton("TIME");
        this.globalTrend.disableButton("LOAD");
        this.attributeTable.setGlobalTrend(this.globalTrend);
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up trend..." + done);
        }
        this.refreshui.setTrend(this.globalTrend);
    }

    protected void initFileManager() {
        this.fileManager = FileManager.getInstance();
        this.fileManager.addErrorListener((IErrorListener)this.errorHistory);
    }

    protected void initTables() {
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing components...");
        }
        this.attributeTableModel.addErrorListener((IErrorListener)this.errorHistory);
        this.attributeTableModel.addErrorListener((IErrorListener)this.errorPopup);
        this.commandTableModel.addErrorListener((IErrorListener)this.errorHistory);
        this.commandTableModel.addErrorListener((IErrorListener)this.errorPopup);
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing collections..." + done);
        }
    }

    protected void resetPreferences() {
        this.windowX = this.preferences.getInt(WINDOW_X_KEY, 50);
        this.windowY = this.preferences.getInt(WINDOW_Y_KEY, 50);
        this.windowWidth = this.preferences.getInt(WINDOW_WIDTH_KEY, 800);
        this.windowHeight = this.preferences.getInt(WINDOW_HEIGHT_KEY, 600);
        this.tableSplitHeight = this.preferences.getInt(TABLE_SPLIT_HEIGHT_KEY, 400);
        this.tableSplitWidth = this.preferences.getInt(TABLE_SPLIT_WIDTH_KEY, 800);
        this.tableSplitDividerLocation = this.preferences.getInt(TABLE_SPLIT_DIVIDER_LOCATION_KEY, 200);
        this.viewSplitDividerLocation = this.preferences.getInt(VIEW_SPLIT_DIVIDER_LOCATION_KEY, 400);
        this.mainSplitDividerLocation = this.preferences.getInt(MAIN_SPLIT_DIVIDER_LOCATION_KEY, 290);
    }

    protected void initPreferences() {
        if (this.runningFromShell) {
            this.splash.setMessage("Getting preferences...");
        }
        this.preferences = FileManager.getInstance().getPreferences();
        this.resetPreferences();
        if (this.runningFromShell) {
            this.splash.setMessage("Getting preferences..." + done);
        }
    }

    protected void initUI(boolean isAdmin) {
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing ui...");
        }
        this.deviceList = new DeviceList();
        Font font = new Font("Dialog", 0, 12);
        UIManager.put("Label.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("Button.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ProgressBar.font", font);
        this.errorPopup = ErrorPopup.getInstance();
        this.menuBar = new DTMenuBar(this.errorHistory);
        this.refreshBar = new JToolBar();
        this.fileBar = new JToolBar();
        this.mainFrame = new JFrame(VERSION);
        this.mainFrame.setIconImage(new ImageIcon(this.getClass().getResource("ui/dtree.gif")).getImage());
        this.status = new JLabel();
        this.status.setBorder(BorderFactory.createLoweredBevelBorder());
        this.status.setText("Ready...");
        this.progress = new JProgressBar();
        this.progress.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.setBounds(this.windowX, this.windowY, this.windowWidth, this.windowHeight);
        this.attributeTableModel = new AttributeTableModel(this, this.preferences);
        this.attributeTableModel.setDeviceList(this.deviceList);
        this.attributeTable = new AttributeTable(this.attributeTableModel, this.preferences, isAdmin);
        this.commandTableModel = new CommandTableModel(this, this.preferences);
        this.commandTableModel.setDeviceList(this.deviceList);
        this.commandTable = new CommandTable(this.commandTableModel, this.preferences, isAdmin);
        this.refreshui = new RefreshUI(this.attributeTableModel, this.refreshBar, this.menuBar);
        new FileUI(this, this.fileBar, this.menuBar, isAdmin, this.mainFrame);
        new EditUI(this.attributeTableModel, this.commandTableModel, this.fileBar, this.menuBar, isAdmin);
        new RunUI(this.fileBar, this.menuBar);
        this.attributeTable.setRefreshUI(this.refreshui);
        UIDialog.getInstance().addComponent(this.mainFrame);
        this.attributePanel = new AttributePanel();
        this.attributePanel.setTable(this.attributeTable);
        this.synchroBox = new JCheckBoxMenuItem("synchronized period");
        this.synchroBox.setToolTipText("Check this box to force the refreshers to resynchronize their period with the refresh interval");
        this.synchroBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Main.this.attributeTable.setSynchronizedPeriod(Main.this.synchroBox.isSelected());
                Main.this.attributeTableModel.setSynchronizedPeriod(Main.this.synchroBox.isSelected());
                Main.this.commandTableModel.setSynchronizedPeriod(Main.this.synchroBox.isSelected());
            }
        });
        this.menuBar.add2RefreshMenu(this.synchroBox);
        this.attributeTable.setSynchronizedPeriod(this.synchroBox.isSelected());
        this.attributeTableModel.setSynchronizedPeriod(this.synchroBox.isSelected());
        this.commandTableModel.setSynchronizedPeriod(this.synchroBox.isSelected());
        if (this.runningFromShell) {
            this.splash.setMessage("Initializing ui..." + done);
        }
    }

    protected void initComponents() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.this.exit();
            }
        });
        if (this.runningFromShell) {
            this.splash = new Splash();
            this.splash.setTitle(VERSION);
            this.splash.setMaxProgress(10);
            this.splash.progress(1);
        }
        DeviceFactory.setAutoStart((boolean)false);
        this.errorHistory = new ErrorHistory();
        this.initFileManager();
        this.initPreferences();
        if (this.runningFromShell) {
            this.splash.progress(2);
        }
        this.initUI(this.isAdmin);
        if (this.runningFromShell) {
            this.splash.progress(3);
        }
        this.initTables();
        if (this.runningFromShell) {
            this.splash.progress(4);
        }
        if (this.runningFromShell) {
            this.splash.progress(6);
        }
        this.initHelp();
        if (this.runningFromShell) {
            this.splash.progress(7);
        }
        this.initTrend();
        if (this.runningFromShell) {
            this.splash.progress(8);
        }
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up frame...");
        }
        this.tableSplit = new JSplitPane(0);
        this.tableSplit.setPreferredSize(new Dimension(this.tableSplitWidth, this.tableSplitHeight));
        this.tableSplit.setDividerSize(9);
        this.tableSplit.setTopComponent(this.attributePanel);
        this.tableSplit.setBottomComponent(this.commandTable);
        this.tableSplit.setOneTouchExpandable(true);
        this.tableSplit.setDividerLocation(200);
        this.tableSplit.setResizeWeight(0.5);
        this.viewSplit = new JSplitPane(0);
        this.viewSplit.setPreferredSize(new Dimension(800, 200));
        this.viewSplit.setDividerSize(9);
        this.viewSplit.setTopComponent(this.tableSplit);
        this.viewSplit.setBottomComponent(new JScrollPane((Component)this.globalTrend));
        this.viewSplit.setOneTouchExpandable(true);
        this.viewSplit.setDividerLocation(400);
        this.viewSplit.setResizeWeight(0.6666666666666666);
        this.mainFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 0.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.mainFrame.getContentPane().add((Component)this.refreshBar, constraints);
        constraints.gridx = 1;
        this.mainFrame.getContentPane().add((Component)this.fileBar, constraints);
        constraints.fill = 1;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        this.mainFrame.getContentPane().add((Component)new JLabel(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.gridx = 0;
        if (this.runningFromShell) {
            this.splash.setMessage("Setting up frame..." + done);
        }
        if (this.runningFromShell) {
            this.splash.progress(9);
        }
        this.specificSetup(constraints);
        if (this.runningFromShell) {
            this.splash.progress(10);
        }
        this.initStatus(constraints);
        this.menuBar.setAboutHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new About().setVisible(true);
            }
        });
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (Main.this.mainFrame.isVisible()) {
                    Main.this.quit();
                }
            }
        });
        if (this.runningFromShell) {
            this.splash.setVisible(false);
        }
        if (this.runningFromShell) {
            this.splash.dispose();
        }
    }

    protected void initStatus(GridBagConstraints constraints) {
        JPanel p = new JPanel();
        ++constraints.gridy;
        constraints.weightx = 0.1;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        constraints.gridx = 0;
        constraints.weightx = 0.9;
        this.mainFrame.getContentPane().add((Component)p, constraints);
        p.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        p.add((Component)this.progress, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        p.add((Component)this.status, constraints);
    }

    @Override
    public void open(File file) {
        this.file = file;
        this.fileRecordable = this.open(file.getAbsolutePath());
        this.attributeTable.setSynchronizedPeriod(this.synchroBox.isSelected());
        this.attributeTableModel.setSynchronizedPeriod(this.synchroBox.isSelected());
        this.commandTableModel.setSynchronizedPeriod(this.synchroBox.isSelected());
    }

    protected boolean open(String source) {
        int refInt = this.refreshui.getRefreshInterval();
        this.mainFrame.setTitle(VERSION + " - " + source);
        this.attributePanel.clear();
        this.progress.setIndeterminate(true);
        this.progress.setStringPainted(true);
        boolean success = false;
        String[] attrNames = new String[this.attributeTableModel.getRowCount()];
        for (int i = 0; i < attrNames.length; ++i) {
            attrNames[i] = this.attributeTableModel.getEntityAt(i).getName();
        }
        this.attributeTableModel.clear();
        String[] comNames = new String[this.commandTableModel.getRowCount()];
        for (int i = 0; i < comNames.length; ++i) {
            comNames[i] = this.commandTableModel.getEntityAt(i).getName();
        }
        this.commandTableModel.clear();
        AttributePolledList attrList = new AttributePolledList();
        if (this.globalTrend.getModel() != null) {
            int i;
            for (i = 0; i < this.globalTrend.getModel().getSize(); ++i) {
                attrList.add((IEntity)((IAttribute)this.globalTrend.getModel().get(i)));
            }
            for (i = 0; i < attrList.getSize(); ++i) {
                this.globalTrend.removeAttribute((INumberScalar)attrList.get(i));
            }
        }
        try {
            int i;
            success = this.fileManager.open(source);
            this.resetPreferences();
            this.tableSplit.setDividerLocation(this.tableSplitDividerLocation);
            this.tableSplit.setPreferredSize(new Dimension(this.tableSplitWidth, this.tableSplitHeight));
            this.mainFrame.setBounds(this.windowX, this.windowY, this.windowWidth, this.windowHeight);
            SwingUtilities.updateComponentTreeUI(this.mainFrame);
            this.viewSplit.setDividerLocation(this.viewSplitDividerLocation);
            AttributePolledList attributes = this.fileManager.getAttributeList();
            CommandList commands = this.fileManager.getCommandList();
            this.commandTable.setPreferences(this.preferences);
            this.attributeTableModel.setPreferences(this.preferences);
            this.commandTableModel.setPreferences(this.preferences);
            this.attributeTable.setPreferences(this.preferences);
            Hashtable<IEntity, Integer> trendTable = new Hashtable<IEntity, Integer>();
            Hashtable<String, JLDataView> trendDataViewTable = new Hashtable<String, JLDataView>();
            if (this.globalTrend.getModel() != null) {
                for (int i2 = 0; i2 < this.globalTrend.getModel().size(); ++i2) {
                    IEntity trendAttr = (IEntity)this.globalTrend.getModel().get(i2);
                    Integer axis = new Integer(this.globalTrend.getAxisForAttribute(trendAttr.getName()));
                    IEntity attr = attributes.get(trendAttr.getName());
                    if (attr != null) {
                        trendTable.put(attr, axis);
                        JLDataView data = this.globalTrend.getDataViewForAttribute(attr.getName());
                        if (data != null) {
                            JLDataView copy = new JLDataView();
                            copy.setBarWidth(data.getBarWidth());
                            copy.setColor(data.getColor());
                            copy.setFill(data.isFill());
                            copy.setFillColor(data.getFillColor());
                            copy.setFillMethod(data.getFillMethod());
                            copy.setFillStyle(data.getFillStyle());
                            copy.setLabelVisible(data.isLabelVisible());
                            copy.setLineWidth(data.getLineWidth());
                            copy.setMarker(data.getMarker());
                            copy.setMarkerColor(data.getMarkerColor());
                            copy.setMarkerSize(data.getMarkerSize());
                            copy.setName(data.getName());
                            copy.setStyle(data.getStyle());
                            copy.setUnit(data.getUnit());
                            copy.setUserFormat(data.getUserFormat());
                            copy.setViewType(data.getViewType());
                            copy.setClickable(data.isClickable());
                            copy.setA0(data.getA0());
                            copy.setA1(data.getA1());
                            copy.setA2(data.getA0());
                            trendDataViewTable.put(attr.getName(), copy);
                        }
                        data = null;
                        continue;
                    }
                    trendTable.put(trendAttr, axis);
                }
                this.globalTrend.clearModel();
                Set attrSet = trendTable.keySet();
                for (IEntity attribute : attrSet) {
                    Integer axis = (Integer)trendTable.get(attribute);
                    this.attributeTable.addTrend(attribute, axis);
                }
                trendTable.clear();
                trendTable = null;
                Set dataSet = trendDataViewTable.keySet();
                for (String attributeName : dataSet) {
                    JLDataView refData = (JLDataView)trendDataViewTable.get(attributeName);
                    JLDataView currentData = this.globalTrend.getDataViewForAttribute(attributeName);
                    if (currentData != null) {
                        currentData.setBarWidth(refData.getBarWidth());
                        currentData.setColor(refData.getColor());
                        currentData.setFill(refData.isFill());
                        currentData.setFillColor(refData.getFillColor());
                        currentData.setFillMethod(refData.getFillMethod());
                        currentData.setFillStyle(refData.getFillStyle());
                        currentData.setLabelVisible(refData.isLabelVisible());
                        currentData.setLineWidth(refData.getLineWidth());
                        currentData.setMarker(refData.getMarker());
                        currentData.setMarkerColor(refData.getMarkerColor());
                        currentData.setMarkerSize(refData.getMarkerSize());
                        currentData.setName(refData.getName());
                        currentData.setStyle(refData.getStyle());
                        currentData.setUnit(refData.getUnit());
                        currentData.setUserFormat(refData.getUserFormat());
                        currentData.setViewType(refData.getViewType());
                        currentData.setClickable(refData.isClickable());
                        currentData.setA0(refData.getA0());
                        currentData.setA1(refData.getA1());
                        currentData.setA2(refData.getA0());
                    }
                    refData = null;
                    currentData = null;
                }
                trendDataViewTable.clear();
                trendDataViewTable = null;
            }
            this.attributeTableModel.addEntities((AEntityList)attributes);
            this.commandTableModel.addEntities((AEntityList)commands);
            AttributeTableModel model = (AttributeTableModel)this.attributeTable.getModel();
            for (i = 0; i < model.getRowCount(); ++i) {
                String keyname;
                String st;
                String err;
                IEntity att = model.getEntityAt(i);
                if (!(att instanceof INumberSpectrum) || (err = this.attributePanel.setSpectrumGraphSettings(att, st = this.preferences.getString(keyname = att.getName() + ".GraphSettings", ""))).length() <= 0) continue;
                JOptionPane.showMessageDialog(null, "Failed apply trend configuration: " + err, "Error", 0);
                for (int j = 0; j < attrList.getSize(); ++j) {
                    this.globalTrend.getModel().add((IEntity)((IAttribute)attrList.get(j)));
                }
                break;
            }
            if (this.globalTrend.getModel() != null) {
                for (i = 0; i < this.globalTrend.getModel().getSize(); ++i) {
                    IAttribute attr = (IAttribute)this.globalTrend.getModel().get(i);
                    this.attributeTableModel.removeFromRefresher(attr);
                }
                if (!this.globalTrend.getModel().isEmpty()) {
                    this.refreshui.enableStopBit();
                    this.refreshui.enableStartAndRefreshBit();
                }
            }
            this.refreshui.setRefreshInterval(this.preferences.getInt("refreshInterval", refInt));
        }
        catch (Exception e) {
            int i;
            this.status("Could not open " + this.file, e);
            e.printStackTrace();
            for (i = 0; i < comNames.length; ++i) {
                this.commandTableModel.removeEntityAt(i);
            }
            for (i = 0; i < comNames.length; ++i) {
                try {
                    this.commandTableModel.load(comNames[i]);
                    continue;
                }
                catch (ConnectionException e1) {
                    JOptionPane.showMessageDialog(null, "Error with file.\nTried to restore former command configuration but failed:\nCould not connect to " + comNames[i], "Error", 0);
                }
            }
            for (i = 0; i < attrNames.length; ++i) {
                this.attributeTableModel.removeEntityAt(i);
            }
            for (i = 0; i < attrNames.length; ++i) {
                try {
                    this.attributeTableModel.load(attrNames[i]);
                    continue;
                }
                catch (ConnectionException e1) {
                    JOptionPane.showMessageDialog(null, "Error with file.\nTried to restore former attribute configuration but failed:\nCould not connect to " + attrNames[i], "Error", 0);
                }
            }
            for (i = 0; i < attrList.getSize(); ++i) {
                this.globalTrend.getModel().add((IEntity)((IAttribute)attrList.get(i)));
            }
            if (this.globalTrend.getModel() != null) {
                for (i = 0; i < this.globalTrend.getModel().getSize(); ++i) {
                    IAttribute attr = (IAttribute)this.globalTrend.getModel().get(i);
                    this.attributeTableModel.removeFromRefresher(attr);
                }
                if (!this.globalTrend.getModel().isEmpty()) {
                    this.refreshui.enableStopBit();
                    this.refreshui.enableStartAndRefreshBit();
                }
            }
            this.refreshui.setRefreshInterval(this.preferences.getInt("refreshInterval", refInt));
            return false;
        }
        this.progress.setIndeterminate(false);
        return success;
    }

    @Override
    public void status(String msg, Exception e) {
        Main.status(this.mainFrame, msg, e);
    }

    public static void status(Component comp, String msg, Exception e) {
        JOptionPane.showMessageDialog(comp, msg + " " + e.toString(), "Error", 0);
    }

    public void statusChange(StatusEvent evt) {
        this.status.setText(evt.getStatus());
    }

    @Override
    public void quit() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        if (this.runningFromShell) {
            System.exit(0);
        }
    }

    public void exit() {
        if (this.mainFrame.isVisible()) {
            this.quit();
        }
    }

    protected abstract void specificSetup(GridBagConstraints var1);

    public static void main(String[] args) {
        if (args.length == 0) {
            new AdminMain(args);
        } else {
            new ViewerMain(args);
        }
    }
}

