/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.AttributeTableModel;
import explorer.EntityTable;
import explorer.Preferences;
import explorer.SetDialog;
import explorer.ViewDialog;
import explorer.ui.Dialog;
import explorer.ui.PreferencesDialog;
import explorer.ui.RefreshUI;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.dnd.NumberScalarNode;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AttributeTable
extends EntityTable {
    protected JMenuItem set;
    protected JMenu globalTrendMenu;
    protected JMenuItem globalTrendY1MenuItem;
    protected JMenuItem globalTrendY2MenuItem;
    protected JMenuItem globalTrendXMenuItem;
    protected JMenuItem globalTrendNoneMenuItem;
    protected JMenuItem removeTrend;
    protected JMenuItem refresh;
    protected Trend trendPanel;
    protected Trend globalTrend;
    protected Dialog trendFrame;
    protected SetDialog setDialog;
    protected boolean synchronizedPeriod = false;
    private RefreshUI refreshui;

    public AttributeTable(AttributeTableModel model, Preferences prefs, boolean isAdmin) {
        this.setAdmin(isAdmin);
        this.refreshui = null;
        this.preferences = prefs;
        this.initComponents(model, isAdmin);
        this.table.setAutoResizeMode(0);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(this.table.getColumnName(i)).setPreferredWidth(87);
            this.table.getColumn(this.table.getColumnName(i)).setWidth(87);
        }
        this.flavor = NodeFactory.MIME_ATTRIBUTE;
        this.table.setTransferHandler((TransferHandler)new fr.esrf.tangoatk.widget.dnd.TransferHandler(){

            protected Transferable createTransferable(JComponent comp) {
                if (!(comp instanceof JTable)) {
                    return null;
                }
                IEntity entity = ((AttributeTableModel)AttributeTable.this.getModel()).getEntityAt(AttributeTable.this.getSelectedRow());
                if (!(entity instanceof INumberScalar)) {
                    return null;
                }
                INumberScalar scalar = (INumberScalar)entity;
                return new NumberScalarNode(scalar);
            }
        });
        this.table.setDragEnabled(true);
        this.setModel(model);
    }

    public JTable getMyTable() {
        return this.table;
    }

    public void setRefreshUI(RefreshUI ref) {
        this.refreshui = ref;
    }

    @Override
    protected void dtHandleDrop(String name, DataFlavor flavor) {
        String mimeType = flavor.getMimeType();
        if (mimeType.startsWith(NodeFactory.MIME_STRINGSCALAR)) {
            ((AttributeTableModel)this.model).addStringScalar(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERSCALAR)) {
            ((AttributeTableModel)this.model).addNumberScalar(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERSPECTRUM)) {
            ((AttributeTableModel)this.model).addNumberSpectrum(name);
            return;
        }
        if (mimeType.startsWith(NodeFactory.MIME_NUMBERIMAGE)) {
            ((AttributeTableModel)this.model).addNumberImage(name);
            return;
        }
    }

    protected void showSetDialog() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return;
        }
        IAttribute attribute = (IAttribute)this.model.getEntityAt(row);
        if (!attribute.isWritable()) {
            return;
        }
        if (attribute instanceof IBooleanScalar) {
            boolean val = ((IBooleanScalar)attribute).getValue();
            ((IBooleanScalar)attribute).setValue(!val);
            this.repaint();
        } else if (attribute instanceof IScalarAttribute) {
            this.setDialog = new SetDialog((IScalarAttribute)attribute);
            this.setDialog.setVisible(true);
        }
    }

    protected void refreshEntity() {
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            IAttribute attribute = (IAttribute)this.model.getEntityAt(rows[i]);
            attribute.refresh();
            attribute.getDevice().refresh();
        }
    }

    public void setGlobalTrend(Trend trend) {
        this.globalTrend = trend;
        if (this.globalTrend != null && this.globalTrend.getModel() != null) {
            this.globalTrend.getModel().setSynchronizedPeriod(this.synchronizedPeriod);
        }
    }

    protected void addGlobalTrend(int axis) {
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            IAttribute attr = (IAttribute)this.model.getEntityAt(rows[i]);
            if (!(attr instanceof INumberScalar)) continue;
            this.globalTrend.addToAxis((INumberScalar)attr, axis, true);
            ((AttributeTableModel)this.model).removeFromRefresher(attr);
        }
        if (this.globalTrend.getModel() != null) {
            if (!this.globalTrend.getModel().isEmpty() && !this.globalTrend.getModel().isRefresherStarted()) {
                this.globalTrend.getModel().startRefresher();
            }
            this.globalTrend.getModel().setSynchronizedPeriod(this.synchronizedPeriod);
        }
        if (this.refreshui != null) {
            this.refreshui.enableStopBit();
            this.refreshui.enableStartAndRefreshBit();
        }
    }

    public void addTrend(IEntity attr, int axis) {
        if (attr instanceof INumberScalar) {
            this.globalTrend.addToAxis((INumberScalar)attr, axis, true);
            ((AttributeTableModel)this.model).removeFromRefresher((IAttribute)attr);
        }
        if (this.globalTrend.getModel() != null) {
            if (!this.globalTrend.getModel().isEmpty() && !this.globalTrend.getModel().isRefresherStarted()) {
                this.globalTrend.getModel().startRefresher();
            }
            this.globalTrend.getModel().setSynchronizedPeriod(this.synchronizedPeriod);
        }
        if (this.refreshui != null) {
            this.refreshui.enableStopBit();
            this.refreshui.enableStartAndRefreshBit();
        }
    }

    protected void removeTrend() {
        int[] rows = this.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            IAttribute attr = (IAttribute)this.model.getEntityAt(rows[i]);
            if (!(attr instanceof INumberScalar)) continue;
            this.globalTrend.removeAttribute((INumberScalar)attr);
            ((AttributeTableModel)this.model).addToRefresher(attr);
        }
        if (this.refreshui != null && (this.globalTrend.getModel() == null || this.globalTrend.getModel().isEmpty())) {
            if (((AttributeTableModel)this.model).isRefresherStarted()) {
                this.refreshui.enableStopBit();
                this.refreshui.disableStartAndRefreshBit();
            } else {
                this.refreshui.disableStopBit();
                this.refreshui.enableStartAndRefreshBit();
            }
        }
        if (this.globalTrend.getModel() != null && this.globalTrend.getModel().isEmpty()) {
            this.globalTrend.getModel().stopRefresher();
        }
    }

    @Override
    protected void initHelp() {
        this.helpUrl = "/explorer/html/AttributeTableHelp.html";
        HelpWindow.getInstance().addCategory("Attribute Table", "Attribute table", this.getClass().getResource(this.helpUrl));
    }

    @Override
    protected void initMenus() {
        this.refresh = new JMenuItem("Refresh");
        this.set = new JMenuItem("Set last selected attribute...");
        this.globalTrendMenu = new JMenu("Add to trend");
        this.globalTrendY1MenuItem = new JMenuItem("set to Y1 axis");
        this.globalTrendY2MenuItem = new JMenuItem("set to Y2 axis");
        this.globalTrendXMenuItem = new JMenuItem("set to X axis");
        this.globalTrendNoneMenuItem = new JMenuItem("do not set to any axis");
        this.removeTrend = new JMenuItem("Remove from trend");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.refreshEntity();
            }
        });
        this.set.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.showSetDialog();
            }
        });
        this.globalTrendY1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.addGlobalTrend(2);
            }
        });
        this.globalTrendY2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.addGlobalTrend(3);
            }
        });
        this.globalTrendXMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.addGlobalTrend(1);
            }
        });
        this.globalTrendNoneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.addGlobalTrend(0);
            }
        });
        this.removeTrend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTable.this.removeTrend();
            }
        });
        this.globalTrendMenu.add(this.globalTrendY1MenuItem);
        this.globalTrendMenu.add(this.globalTrendY2MenuItem);
        this.globalTrendMenu.add(this.globalTrendXMenuItem);
        this.globalTrendMenu.add(this.globalTrendNoneMenuItem);
        this.popup.add(this.refresh);
        this.popup.add(new JSeparator());
        this.popup.add(this.globalTrendMenu);
        this.popup.add(this.removeTrend);
    }

    @Override
    protected void initPreferences() {
        PreferencesDialog.getInstance().addCategory("Attribute table", "visible fields", new ViewDialog(this.model));
    }

    @Override
    protected void showPopup(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        int[] rows = this.getSelectedRows();
        if (evt.isPopupTrigger()) {
            int i;
            if (evt.isControlDown()) {
                this.table.addRowSelectionInterval(row, row);
            } else if (evt.isShiftDown()) {
                int min = rows[0];
                for (i = 0; i < rows.length; ++i) {
                    if (rows[i] >= min) continue;
                    min = rows[i];
                }
                this.table.addRowSelectionInterval(min, row);
            } else {
                boolean isInSelection = false;
                for (i = 0; i < rows.length; ++i) {
                    if (rows[i] != row) continue;
                    isInSelection = true;
                    break;
                }
                if (!isInSelection) {
                    this.table.clearSelection();
                    this.table.setRowSelectionInterval(row, row);
                }
            }
            rows = this.getSelectedRows();
            boolean addTrend = false;
            boolean remTrend = false;
            for (int i2 = 0; i2 < rows.length; ++i2) {
                IAttribute attribute = (IAttribute)this.model.getEntityAt(rows[i2]);
                if (attribute instanceof INumberScalar && this.globalTrend.getModel() != null && this.globalTrend.getModel().contains((Object)attribute)) {
                    remTrend = true;
                }
                if (!(attribute instanceof INumberScalar) || this.globalTrend.getModel() != null && this.globalTrend.getModel().contains((Object)attribute)) continue;
                addTrend = true;
            }
            this.set.setEnabled(((IAttribute)this.model.getEntityAt(row)).isWritable());
            this.removeTrend.setEnabled(remTrend);
            this.globalTrendMenu.setEnabled(addTrend);
            this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    @Override
    protected void entityTableMouseClicked(MouseEvent evt) {
        int row = this.getRowAtPoint(evt.getPoint());
        if (row == -1) {
            return;
        }
        IAttribute attribute = (IAttribute)this.model.getEntityAt(row);
        if (this.model.isExecuteColumn(this.getColumnAtPoint(evt.getPoint())) && !evt.isPopupTrigger() && attribute.isWritable()) {
            this.showSetDialog();
        }
    }

    @Override
    protected TableColumn createTableColumn(String name, int i) {
        int tempcol = -1;
        try {
            tempcol = this.table.getColumnModel().getColumnIndex(name);
        }
        catch (Exception e) {
            tempcol = -1;
        }
        final int col = tempcol;
        if (AttributeTableModel.DEVICE == name) {
            return new TableColumn(i, 75, this.deviceRenderer, null);
        }
        if ("Value" == name) {
            return new TableColumn(i, 75, this.entityRenderer, null);
        }
        if ("Set" == name) {
            return new TableColumn(i, 75, new TableCellRenderer(){
                JButton renderer;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean select, boolean focus, int row, int column) {
                    if (this.renderer == null) {
                        this.renderer = new JButton(AttributeTable.this.getValueAt(row, col == -1 ? column : col).toString());
                    } else {
                        this.renderer.setText(AttributeTable.this.getValueAt(row, col == -1 ? column : col).toString());
                    }
                    JButton dummy = new JButton();
                    if (select) {
                        this.renderer.setBackground(Color.DARK_GRAY);
                        this.renderer.setForeground(Color.WHITE);
                    } else {
                        this.renderer.setBackground(dummy.getBackground());
                        this.renderer.setForeground(dummy.getForeground());
                    }
                    IAttribute attribute = (IAttribute)AttributeTable.this.model.getEntityAt(row);
                    this.renderer.setEnabled(attribute.isWritable());
                    return this.renderer;
                }
            }, null);
        }
        return new TableColumn(i, 75);
    }

    @Override
    public void setPreferences(Preferences preferences) {
        String err;
        super.setPreferences(preferences);
        String s = preferences.getString("globalGraphSettings", null);
        if (s != null && (err = this.globalTrend.setSetting(s)).length() > 0) {
            JOptionPane.showMessageDialog(null, "Failed apply trend configuration: " + err, "Error", 0);
        }
    }

    @Override
    public void storePreferences() {
        super.storePreferences();
        this.preferences.putString("globalGraphSettings", this.globalTrend.getSettings());
    }

    public void setSynchronizedPeriod(boolean synchro) {
        this.synchronizedPeriod = synchro;
        if (this.globalTrend != null && this.globalTrend.getModel() != null) {
            this.globalTrend.getModel().setSynchronizedPeriod(this.synchronizedPeriod);
        }
    }
}

