/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZThread {
    public static void start(IDetachedRunnable iDetachedRunnable, Object ... objectArray) {
        ShimThread shimThread = new ShimThread(iDetachedRunnable, objectArray);
        shimThread.start();
    }

    public static ZMQ.Socket fork(ZContext zContext, IAttachedRunnable iAttachedRunnable, Object ... objectArray) {
        ZMQ.Socket socket = zContext.createSocket(0);
        if (socket == null) {
            return null;
        }
        socket.bind(String.format("inproc://zctx-pipe-%d", socket.hashCode()));
        ZContext zContext2 = ZContext.shadow(zContext);
        ZMQ.Socket socket2 = zContext2.createSocket(0);
        if (socket2 == null) {
            return null;
        }
        socket2.connect(String.format("inproc://zctx-pipe-%d", socket.hashCode()));
        ShimThread shimThread = new ShimThread(zContext2, iAttachedRunnable, objectArray, socket2);
        shimThread.start();
        return socket;
    }

    private static class ShimThread
    extends Thread {
        private ZContext ctx;
        private IAttachedRunnable attachedRunnable;
        private IDetachedRunnable detachedRunnable;
        private Object[] args;
        private ZMQ.Socket pipe;

        protected ShimThread(ZContext zContext, IAttachedRunnable iAttachedRunnable, Object[] objectArray, ZMQ.Socket socket) {
            assert (zContext != null);
            assert (socket != null);
            assert (iAttachedRunnable != null);
            this.ctx = zContext;
            this.attachedRunnable = iAttachedRunnable;
            this.args = objectArray;
            this.pipe = socket;
        }

        public ShimThread(IDetachedRunnable iDetachedRunnable, Object[] objectArray) {
            assert (iDetachedRunnable != null);
            this.detachedRunnable = iDetachedRunnable;
            this.args = objectArray;
        }

        @Override
        public void run() {
            if (this.attachedRunnable != null) {
                block4: {
                    try {
                        this.attachedRunnable.run(this.args, this.ctx, this.pipe);
                    }
                    catch (ZMQException zMQException) {
                        if ((long)zMQException.getErrorCode() == ZMQ.ETERM()) break block4;
                        throw zMQException;
                    }
                }
                this.ctx.destroy();
            } else {
                this.detachedRunnable.run(this.args);
            }
        }
    }

    public static interface IDetachedRunnable {
        public void run(Object[] var1);
    }

    public static interface IAttachedRunnable {
        public void run(Object[] var1, ZContext var2, ZMQ.Socket var3);
    }
}

