/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;

public class ZMsg
implements Iterable<ZFrame>,
Deque<ZFrame> {
    private ArrayDeque<ZFrame> frames = new ArrayDeque();

    public void destroy() {
        if (this.frames == null) {
            return;
        }
        for (ZFrame zFrame : this.frames) {
            zFrame.destroy();
        }
        this.frames.clear();
    }

    public long contentSize() {
        long l = 0L;
        for (ZFrame zFrame : this.frames) {
            l += (long)zFrame.size();
        }
        return l;
    }

    public void addString(String string) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.add(new ZFrame(string));
    }

    public ZMsg duplicate() {
        if (this.frames != null) {
            ZMsg zMsg = new ZMsg();
            for (ZFrame zFrame : this.frames) {
                zMsg.add(zFrame.duplicate());
            }
            return zMsg;
        }
        return null;
    }

    public void wrap(ZFrame zFrame) {
        if (zFrame != null) {
            this.push(new ZFrame(""));
            this.push(zFrame);
        }
    }

    public ZFrame unwrap() {
        if (this.size() == 0) {
            return null;
        }
        ZFrame zFrame = this.pop();
        ZFrame zFrame2 = this.getFirst();
        if (zFrame2.hasData() && zFrame2.size() == 0) {
            zFrame2 = this.pop();
            zFrame2.destroy();
        }
        return zFrame;
    }

    public void send(ZMQ.Socket socket) {
        this.send(socket, false);
    }

    public void send(ZMQ.Socket socket, boolean bl) {
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        if (this.frames.size() == 0) {
            return;
        }
        Iterator<ZFrame> iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            ZFrame zFrame = iterator.next();
            zFrame.sendAndKeep(socket, iterator.hasNext() ? 2 : 0);
        }
        if (bl) {
            this.destroy();
        }
    }

    public static ZMsg recvMsg(ZMQ.Socket socket) {
        return ZMsg.recvMsg(socket, 0);
    }

    public static ZMsg recvMsg(ZMQ.Socket socket, int n) {
        ZFrame zFrame;
        if (socket == null) {
            throw new IllegalArgumentException("socket is null");
        }
        ZMsg zMsg = new ZMsg();
        do {
            if ((zFrame = ZFrame.recvFrame(socket, n)) == null) {
                zMsg.destroy();
                break;
            }
            zMsg.add(zFrame);
        } while (zFrame.hasMore());
        return zMsg;
    }

    public static boolean save(ZMsg zMsg, DataOutputStream dataOutputStream) {
        if (zMsg == null) {
            return false;
        }
        try {
            dataOutputStream.writeInt(zMsg.size());
            if (zMsg.size() > 0) {
                for (ZFrame zFrame : zMsg) {
                    dataOutputStream.writeInt(zFrame.size());
                    dataOutputStream.write(zFrame.getData());
                }
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static ZMsg load(DataInputStream dataInputStream) {
        if (dataInputStream == null) {
            return null;
        }
        ZMsg zMsg = new ZMsg();
        try {
            int n = dataInputStream.readInt();
            if (n > 0) {
                int n2 = 0;
                while (++n2 <= n) {
                    int n3 = dataInputStream.readInt();
                    byte[] byArray = new byte[n3];
                    dataInputStream.read(byArray);
                    zMsg.add(new ZFrame(byArray));
                }
            }
            return zMsg;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ZMsg newStringMsg(String ... stringArray) {
        ZMsg zMsg = new ZMsg();
        for (String string : stringArray) {
            zMsg.addString(string);
        }
        return zMsg;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ZMsg zMsg = (ZMsg)object;
        if (this.frames == null || zMsg.frames == null) {
            return false;
        }
        Iterator<ZFrame> iterator = this.frames.iterator();
        Iterator<ZFrame> iterator2 = zMsg.frames.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            ZFrame zFrame = iterator.next();
            ZFrame zFrame2 = iterator2.next();
            if (zFrame != null ? zFrame.equals(zFrame2) : zFrame2 == null) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    @Override
    public int hashCode() {
        if (this.frames == null || this.frames.size() == 0) {
            return 0;
        }
        int n = 1;
        for (ZFrame zFrame : this.frames) {
            n = 31 * n + (zFrame == null ? 0 : zFrame.hashCode());
        }
        return n;
    }

    public void dump(Appendable appendable) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("--------------------------------------\n", new Object[0]);
            for (ZFrame zFrame : this.frames) {
                printWriter.printf("[%03d] %s\n", zFrame.getData().length, zFrame.toString());
            }
            appendable.append(stringWriter.getBuffer());
            stringWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Message dump exception " + super.toString(), iOException);
        }
    }

    @Override
    public void addFirst(String string) {
        this.addFirst(new ZFrame(string));
    }

    @Override
    public void addFirst(byte[] byArray) {
        this.addFirst(new ZFrame(byArray));
    }

    @Override
    public void addLast(String string) {
        this.addLast(new ZFrame(string));
    }

    @Override
    public void addLast(byte[] byArray) {
        this.addLast(new ZFrame(byArray));
    }

    @Override
    public void push(String string) {
        this.push(new ZFrame(string));
    }

    @Override
    public void push(byte[] byArray) {
        this.push(new ZFrame(byArray));
    }

    @Override
    public boolean add(String string) {
        return this.add(new ZFrame(string));
    }

    @Override
    public boolean add(byte[] byArray) {
        return this.add(new ZFrame(byArray));
    }

    @Override
    public Iterator<ZFrame> iterator() {
        return this.frames.iterator();
    }

    @Override
    public boolean addAll(Collection<? extends ZFrame> collection) {
        return this.frames.addAll(collection);
    }

    @Override
    public void clear() {
        this.frames.clear();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.frames.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.frames.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.frames.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.frames.retainAll(collection);
    }

    @Override
    public Object[] toArray() {
        return this.frames.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.frames.toArray(TArray);
    }

    @Override
    public boolean add(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.add(zFrame);
    }

    @Override
    public void addFirst(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.addFirst(zFrame);
    }

    @Override
    public void addLast(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.addLast(zFrame);
    }

    @Override
    public boolean contains(Object object) {
        return this.frames.contains(object);
    }

    @Override
    public Iterator<ZFrame> descendingIterator() {
        return this.frames.descendingIterator();
    }

    @Override
    public ZFrame element() {
        return this.frames.element();
    }

    @Override
    public ZFrame getFirst() {
        try {
            return this.frames.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public ZFrame getLast() {
        try {
            return this.frames.getLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean offer(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offer(zFrame);
    }

    @Override
    public boolean offerFirst(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offerFirst(zFrame);
    }

    @Override
    public boolean offerLast(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        return this.frames.offerLast(zFrame);
    }

    @Override
    public ZFrame peek() {
        return this.frames.peek();
    }

    @Override
    public ZFrame peekFirst() {
        try {
            return this.frames.peekFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public ZFrame peekLast() {
        try {
            return this.frames.peekLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public ZFrame poll() {
        return this.frames.poll();
    }

    @Override
    public ZFrame pollFirst() {
        return this.frames.pollFirst();
    }

    @Override
    public ZFrame pollLast() {
        return this.frames.pollLast();
    }

    @Override
    public ZFrame pop() {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        try {
            return this.frames.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public String popString() {
        ZFrame zFrame = this.pop();
        if (zFrame == null) {
            return null;
        }
        return zFrame.toString();
    }

    @Override
    public void push(ZFrame zFrame) {
        if (this.frames == null) {
            this.frames = new ArrayDeque();
        }
        this.frames.push(zFrame);
    }

    @Override
    public ZFrame remove() {
        return this.frames.remove();
    }

    @Override
    public boolean remove(Object object) {
        return this.frames.remove(object);
    }

    @Override
    public ZFrame removeFirst() {
        try {
            return this.frames.removeFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.frames.removeFirstOccurrence(object);
    }

    @Override
    public ZFrame removeLast() {
        try {
            return this.frames.removeLast();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        return this.frames.removeLastOccurrence(object);
    }

    @Override
    public int size() {
        return this.frames.size();
    }
}

