/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.CodeSetInfoInterceptor;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.slf4j.Logger;

public class IORInterceptorInitializer
extends LocalObject
implements ORBInitializer {
    @Override
    public void post_init(ORBInitInfo info) {
        ORB orb = ((ORBInitInfoImpl)info).getORB();
        Configuration config = orb.getConfiguration();
        Logger logger = config.getLogger("org.jacorb.interceptors.ior_init");
        try {
            int giop_minor = config.getAttributeAsInteger("jacorb.giop_minor_version", 2);
            if (giop_minor > 0) {
                info.add_ior_interceptor(new CodeSetInfoInterceptor(orb));
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception in IORInterceptorInitializer", e);
            throw new INTERNAL(e.toString());
        }
    }

    @Override
    public void pre_init(ORBInitInfo info) {
    }
}

