/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.diop.DIOPFactories;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;
import org.slf4j.Logger;

public class TransportManager
implements Configurable {
    private Configuration configuration = null;
    private Logger logger = null;
    private List<String> factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private final SocketFactoryManager socketFactoryManager;
    private boolean useNonBlockingIIOPTransport = false;
    private Map<Integer, Factories> factoriesMap = null;
    private List<Factories> factoriesList = null;
    private TransportListener listener = null;

    public TransportManager(ORB orb) {
        this.socketFactoryManager = new SocketFactoryManager(orb);
    }

    @Override
    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("jacorb.orb.giop");
        this.useNonBlockingIIOPTransport = this.configuration.getAttributeAsBoolean("jacorb.connection.nonblocking", false);
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public synchronized Factories getFactories(int tag) {
        if (tag == 1413566212) {
            return DIOPFactories.getDIOPFactory();
        }
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return this.factoriesMap.get(tag);
    }

    public synchronized List<Factories> getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames may not be null");
        }
        this.factoriesMap = new HashMap<Integer, Factories>();
        this.factoriesList = new ArrayList<Factories>();
        for (String className : this.factoryClassNames) {
            Factories factories = this.instantiateFactories(className);
            this.factoriesMap.put(factories.profile_tag(), factories);
            this.factoriesList.add(factories);
        }
    }

    private Factories instantiateFactories(String className) {
        try {
            Class<?> clazz;
            Object instance;
            if (this.useNonBlockingIIOPTransport && "org.jacorb.orb.iiop.IIOPFactories".equals(className)) {
                className = "org.jacorb.orb.nio.NIOFactories";
            }
            if ((instance = (clazz = ObjectUtil.classForName(className)).newInstance()) instanceof Configurable) {
                Configurable configurable = (Configurable)instance;
                configurable.configure(this.configuration);
            }
            this.logger.debug("created org.omg.ETF.Factories: " + className);
            return (Factories)instance;
        }
        catch (Exception e) {
            throw new BAD_PARAM("could not instantiate Factories class " + className + ", exception: " + e);
        }
    }

    public void notifyTransportListeners(GIOPConnection giopc) {
        if (this.listener != null) {
            this.listener.transportSelected(new TransportListener.Event(giopc));
        }
    }

    public void addTransportListener(TransportListener tl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Transport listener to add: " + tl);
        }
        if (tl != null) {
            this.addTransportListenerImpl(tl);
        }
    }

    private synchronized void addTransportListenerImpl(final TransportListener tl) {
        this.listener = this.listener == null ? tl : new TransportListener(){
            private final TransportListener next_;
            {
                this.next_ = TransportManager.this.listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transportSelected(TransportListener.Event event) {
                try {
                    tl.transportSelected(event);
                }
                finally {
                    this.next_.transportSelected(event);
                }
            }
        };
    }
}

