/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.MARSHAL;
import org.omg.IOP.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeSet {
    private static final CodeSet ISO8859_1_CODESET = new Iso8859_1CodeSet();
    private static final CodeSet ISO8859_15_CODESET = new Iso8859_15CodeSet();
    private static final CodeSet UTF8_CODESET = new Utf8CodeSet();
    private static final CodeSet UTF16_CODESET = new Utf16CodeSet();
    private static final CodeSet UCS2_CODESET = new Ucs2CodeSet();
    private static final CodeSet NULL_CODE_SET = new CodeSet(-1, "NO SUCH CODESET");
    private static CodeSet[] KNOWN_ENCODINGS = new CodeSet[]{ISO8859_1_CODESET, ISO8859_15_CODESET, UTF16_CODESET, UTF8_CODESET, UCS2_CODESET};
    private static Logger logger = LoggerFactory.getLogger("jacorb.codeset");
    private static boolean isConfigured = false;
    private static CodeSet nativeCodeSetChar = null;
    private static CodeSet nativeCodeSetWchar = UTF16_CODESET;
    private static volatile CodeSetComponentInfo localCodeSetComponentInfo;
    private int id;
    private String name;
    private static final String CODESET_PREFIX = "0x00000000";

    public static String csName(int cs) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (cs != KNOWN_ENCODINGS[i].getId()) continue;
            return KNOWN_ENCODINGS[i].getName();
        }
        return "Unknown TCS: 0x" + Integer.toHexString(cs);
    }

    public static synchronized void configure(Configuration config) throws ConfigurationException {
        if (!isConfigured) {
            CodeSet codeset;
            String ncsc = config.getAttribute("jacorb.native_char_codeset", "");
            String ncsw = config.getAttribute("jacorb.native_wchar_codeset", "");
            if (ncsc != null && !"".equals(ncsc)) {
                codeset = CodeSet.getCodeSet(ncsc);
                if (codeset != NULL_CODE_SET) {
                    nativeCodeSetChar = codeset;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSC to " + ncsc);
                }
                logger.info("Set default native char codeset to " + codeset);
            }
            if (ncsw != null && !"".equals(ncsw)) {
                codeset = CodeSet.getCodeSet(ncsw);
                if (codeset != NULL_CODE_SET) {
                    nativeCodeSetWchar = codeset;
                } else if (logger.isErrorEnabled()) {
                    logger.error("Cannot set default NCSW to " + ncsw);
                }
                logger.info("Set default native wchar codeset to " + codeset);
            }
            logger = config.getLogger("jacorb.codeset");
            isConfigured = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("CodeSet is already configured; further attempts to reconfigure will be ignored!");
        }
    }

    public static CodeSet getCodeSet(String name) {
        String ucName = name.toUpperCase();
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeset = KNOWN_ENCODINGS[i];
            if (!codeset.getName().equals(ucName)) continue;
            return codeset;
        }
        try {
            int id = Integer.parseInt(name, 16);
            for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
                CodeSet codeset = KNOWN_ENCODINGS[i];
                if (id != codeset.getId()) continue;
                return codeset;
            }
            return NULL_CODE_SET;
        }
        catch (NumberFormatException ex) {
            return NULL_CODE_SET;
        }
    }

    public static CodeSet getCodeSet(int id) {
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeset = KNOWN_ENCODINGS[i];
            if (id != codeset.id) continue;
            return codeset;
        }
        return NULL_CODE_SET;
    }

    public static CodeSet getTCSDefault() {
        if (nativeCodeSetChar != null) {
            return nativeCodeSetChar;
        }
        String sysenc = CodeSet.getDefaultEncoding();
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            CodeSet codeset = KNOWN_ENCODINGS[i];
            if (!codeset.supportsCharacterData(false) || !sysenc.equals(codeset.getName())) continue;
            return CodeSet.setNativeCodeSetChar(codeset);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Warning - unknown codeset (" + sysenc + ") - defaulting to ISO-8859-1");
        }
        return CodeSet.setNativeCodeSetChar(ISO8859_1_CODESET);
    }

    private static CodeSet setNativeCodeSetChar(CodeSet codeset) {
        nativeCodeSetChar = codeset;
        if (logger.isDebugEnabled()) {
            logger.debug("TCS set to " + codeset.getName());
        }
        return codeset;
    }

    private static String getDefaultEncoding() {
        OutputStreamWriter defaultStream = new OutputStreamWriter(new ByteArrayOutputStream());
        String sysenc = defaultStream.getEncoding();
        try {
            defaultStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sysenc;
    }

    public static CodeSet getTCSWDefault() {
        return nativeCodeSetWchar;
    }

    public static CodeSetContext getCodeSetContext(ServiceContext[] contexts) {
        for (int i = 0; i < contexts.length; ++i) {
            if (contexts[i].context_id != 1) continue;
            CDRInputStream is = new CDRInputStream(contexts[i].context_data);
            is.openEncapsulatedArray();
            return CodeSetContextHelper.read(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodeSetComponentInfo getLocalCodeSetComponentInfo() {
        if (localCodeSetComponentInfo != null) return localCodeSetComponentInfo;
        Class<CodeSet> clazz = CodeSet.class;
        synchronized (CodeSet.class) {
            if (localCodeSetComponentInfo != null) return localCodeSetComponentInfo;
            localCodeSetComponentInfo = new CodeSetComponentInfo();
            CodeSet.localCodeSetComponentInfo.ForCharData = CodeSet.createCodeSetComponent(false, CodeSet.getTCSDefault());
            CodeSet.localCodeSetComponentInfo.ForWcharData = CodeSet.createCodeSetComponent(true, CodeSet.getTCSWDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localCodeSetComponentInfo;
        }
    }

    private static CodeSetComponent createCodeSetComponent(boolean wide, CodeSet nativeCodeSet) {
        ArrayList<CodeSet> codeSets = new ArrayList<CodeSet>();
        codeSets.add(nativeCodeSet);
        for (int i = 0; i < KNOWN_ENCODINGS.length; ++i) {
            if (!KNOWN_ENCODINGS[i].supportsCharacterData(wide) || codeSets.contains(KNOWN_ENCODINGS[i])) continue;
            codeSets.add(KNOWN_ENCODINGS[i]);
        }
        int nativeSet = ((CodeSet)codeSets.remove(0)).getId();
        int[] conversionSets = new int[codeSets.size()];
        for (int i = 0; i < conversionSets.length; ++i) {
            conversionSets[i] = ((CodeSet)codeSets.get(i)).getId();
        }
        return new CodeSetComponent(nativeSet, conversionSets);
    }

    public static CodeSet getNegotiatedCodeSet(CodeSetComponentInfo serverCodeSetInfo, boolean wide) {
        return CodeSet.getMatchingCodeSet(CodeSet.getSelectedComponent(CodeSet.getLocalCodeSetComponentInfo(), wide), CodeSet.getSelectedComponent(serverCodeSetInfo, wide), wide);
    }

    public static CodeSet getMatchingCodeSet(CodeSetComponent local, CodeSetComponent remote, boolean wide) {
        CodeSet codeSet = CodeSet.getCodeSetIfMatched(local.native_code_set, remote);
        if (codeSet != null) {
            return codeSet;
        }
        for (int i = 0; i < local.conversion_code_sets.length; ++i) {
            codeSet = CodeSet.getCodeSetIfMatched(local.conversion_code_sets[i], remote);
            if (codeSet == null) continue;
            return codeSet;
        }
        return CodeSet.reportNegotiationFailure(local, remote, wide);
    }

    public static CodeSet getCodeSetIfMatched(int localCodeSetId, CodeSetComponent remote) {
        if (localCodeSetId == remote.native_code_set) {
            return CodeSet.getCodeSet(localCodeSetId);
        }
        for (int i = 0; i < remote.conversion_code_sets.length; ++i) {
            if (localCodeSetId != remote.conversion_code_sets[i]) continue;
            return CodeSet.getCodeSet(localCodeSetId);
        }
        return null;
    }

    private static CodeSet reportNegotiationFailure(CodeSetComponent local, CodeSetComponent remote, boolean wide) {
        StringBuffer sb = new StringBuffer("No matching ");
        if (wide) {
            sb.append("wide ");
        }
        sb.append("code set found. Client knows {");
        CodeSet.appendCodeSetList(sb, local);
        sb.append("}. Server offered {");
        CodeSet.appendCodeSetList(sb, remote);
        sb.append('}');
        throw new CODESET_INCOMPATIBLE(sb.toString());
    }

    private static void appendCodeSetList(StringBuffer sb, CodeSetComponent remote) {
        int code_set = remote.native_code_set;
        sb.append(CodeSet.toCodeSetString(code_set));
        for (int i = 0; i < remote.conversion_code_sets.length; ++i) {
            sb.append(',').append(CodeSet.toCodeSetString(remote.conversion_code_sets[i]));
        }
    }

    private static String toCodeSetString(int code_set) {
        String rawString = Integer.toHexString(code_set);
        return CODESET_PREFIX.substring(0, CODESET_PREFIX.length() - rawString.length()) + rawString;
    }

    private static CodeSetComponent getSelectedComponent(CodeSetComponentInfo info, boolean wide) {
        return wide ? info.ForWcharData : info.ForCharData;
    }

    public CodeSet(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean supportsCharacterData(boolean wide) {
        return false;
    }

    public boolean supportsWideCharacterData() {
        return false;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean write_bom(boolean configuredForBom) {
        return false;
    }

    public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public String read_wstring(InputBuffer buffer, int lengthIndicator, int giop_minor, boolean littleEndian) {
        throw new MARSHAL("Bad wide char codeSet: " + this.getName());
    }

    public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length, int giop_minor) {
        throw new CODESET_INCOMPATIBLE("Bad codeset: " + this.getName());
    }

    public int get_wstring_size(String string, int startPos, int currentPos) {
        return 0;
    }

    protected final String readGiop12WString(InputBuffer buffer, int size, int giop_minor) {
        char[] buf = new char[size];
        int endPos = buffer.get_pos() + size;
        boolean wchar_litte_endian = buffer.readBOM();
        int i = 0;
        while (buffer.get_pos() < endPos) {
            buf[i++] = this.read_wchar(buffer, giop_minor, wchar_litte_endian);
        }
        return new String(buf, 0, i);
    }

    public static void main(String[] args) {
        if (!(args == null || args.length <= 0 || args[0].equals("-h") || args[0].equals("-a") || args[0].equals("-l"))) {
            System.out.println("Usage: org.jacorb.orb.connection.CodeSet [-a | -l <codeset>] ");
            System.exit(1);
        }
        Properties props = System.getProperties();
        String osName = (String)props.get("os.name");
        System.out.println("Operating system name: " + osName);
        System.out.println("Operating system version: " + props.get("os.version"));
        System.out.println("Operating system architecture: " + props.get("os.arch"));
        System.out.println("User region: " + System.getProperty("user.region"));
        System.out.println("JVM: " + props.get("java.vm.version"));
        System.out.println("JacORB: 3.1, 19-Aug-2012");
        System.out.println("System file encoding property: " + System.getProperty("file.encoding"));
        String defaultIOEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        System.out.println("Cannonical encoding: " + defaultIOEncoding);
        System.out.println("Default WChar encoding: " + nativeCodeSetWchar.getName());
        if (osName.toLowerCase().indexOf("windows") == -1) {
            String line;
            BufferedReader buffer;
            Process locale;
            System.out.println("Locale is:");
            try {
                locale = Runtime.getRuntime().exec("locale");
                buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                while ((line = buffer.readLine()) != null) {
                    System.out.println("    " + line);
                }
                buffer.close();
            }
            catch (IOException e) {
                System.err.println("Caught exception " + e);
            }
            if (args != null && args.length == 1 && args[0].equals("-a")) {
                System.out.println("All available locales are:");
                try {
                    locale = Runtime.getRuntime().exec("locale -a");
                    buffer = new BufferedReader(new InputStreamReader(locale.getInputStream()));
                    while ((line = buffer.readLine()) != null) {
                        System.out.println("        " + line);
                    }
                    buffer.close();
                }
                catch (IOException e) {
                    System.err.println("Caught exception " + e);
                }
            } else if (args != null && args.length == 2 && args[0].equals("-l")) {
                CodeSet c = CodeSet.getCodeSet(args[1]);
                System.out.println("Codeset " + args[1] + " is " + c.getName());
            }
        }
    }

    private static class Ucs2CodeSet
    extends TwoByteCodeSet {
        private Ucs2CodeSet() {
            super(65792, "UCS2");
        }

        @Override
        public boolean write_bom(boolean configuredForBom) {
            return true;
        }
    }

    private static class Utf16CodeSet
    extends TwoByteCodeSet {
        private Utf16CodeSet() {
            super(65801, "UTF16");
        }

        @Override
        public boolean write_bom(boolean configuredForBom) {
            return false;
        }
    }

    private static abstract class TwoByteCodeSet
    extends CodeSet {
        protected TwoByteCodeSet(int id, String name) {
            super(id, name);
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return wide;
        }

        @Override
        public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
            if (littleEndian) {
                return (char)(buffer.readByte() & 0xFF | buffer.readByte() << 8);
            }
            return (char)(buffer.readByte() << 8 | buffer.readByte() & 0xFF);
        }

        @Override
        public String read_wstring(InputBuffer source, int lengthIndicator, int giop_minor, boolean little_endian) {
            if (giop_minor == 2) {
                return this.readGiop12WString(source, lengthIndicator, giop_minor);
            }
            char[] buf = new char[lengthIndicator];
            int endPos = source.get_pos() + 2 * lengthIndicator;
            int i = 0;
            while (source.get_pos() < endPos) {
                buf[i++] = this.read_wchar(source, giop_minor, little_endian);
            }
            if (i != 0 && buf[i - 1] == '\u0000') {
                return new String(buf, 0, i - 1);
            }
            return new String(buf, 0, i);
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            if (giop_minor < 2) {
                buffer.write_short((short)c);
            } else {
                if (write_length_indicator) {
                    buffer.write_byte((byte)2);
                }
                if (write_bom) {
                    buffer.write_byte((byte)-2);
                    buffer.write_byte((byte)-1);
                }
                buffer.write_byte((byte)(c >> 8 & 0xFF));
                buffer.write_byte((byte)(c & 0xFF));
            }
        }

        @Override
        public int get_wstring_size(String s, int startPos, int currentPos) {
            return s.length() + 1;
        }
    }

    private static class Utf8CodeSet
    extends CodeSet {
        private Utf8CodeSet() {
            super(0x5010001, "UTF8");
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return true;
        }

        @Override
        public char read_wchar(InputBuffer buffer, int giop_minor, boolean littleEndian) {
            if (giop_minor < 2) {
                throw new MARSHAL("GIOP 1." + giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
            }
            short value = (short)(0xFF & buffer.readByte());
            if ((value & 0x80) == 0) {
                return (char)value;
            }
            if ((value & 0xE0) == 192) {
                return (char)((value & 0x1F) << 6 | buffer.readByte() & 0x3F);
            }
            short b2 = (short)(0xFF & buffer.readByte());
            return (char)((value & 0xF) << 12 | (b2 & 0x3F) << 6 | buffer.readByte() & 0x3F);
        }

        @Override
        public String read_wstring(InputBuffer source, int lengthIndicator, int giop_minor, boolean little_endian) {
            if (giop_minor < 2) {
                throw new MARSHAL("Bad wide char codeSet: " + this.getName());
            }
            return this.readGiop12WString(source, lengthIndicator, giop_minor);
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            if (c <= '\u007f') {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)1);
                }
                buffer.write_byte((byte)c);
            } else if (c > '\u07ff') {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)3);
                }
                buffer.write_byte((byte)(0xE0 | c >> 12 & 0xF));
                buffer.write_byte((byte)(0x80 | c >> 6 & 0x3F));
                buffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                if (giop_minor == 2 && write_length_indicator) {
                    buffer.write_byte((byte)2);
                }
                buffer.write_byte((byte)(0xC0 | c >> 6 & 0x1F));
                buffer.write_byte((byte)(0x80 | c >> 0 & 0x3F));
            }
        }

        @Override
        public int get_wstring_size(String s, int startPos, int currentPos) {
            return currentPos - startPos - 4;
        }
    }

    private static class Iso8859_15CodeSet
    extends Iso8859_1CodeSet {
        private Iso8859_15CodeSet() {
            super(65551, "ISO8859_15");
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            switch (c) {
                case '\u20ac': {
                    buffer.write_byte((byte)-92);
                    break;
                }
                case '\u0160': {
                    buffer.write_byte((byte)-90);
                    break;
                }
                case '\u0161': {
                    buffer.write_byte((byte)-88);
                    break;
                }
                case '\u017d': {
                    buffer.write_byte((byte)-76);
                    break;
                }
                case '\u017e': {
                    buffer.write_byte((byte)-72);
                    break;
                }
                case '\u0152': {
                    buffer.write_byte((byte)-68);
                    break;
                }
                case '\u0153': {
                    buffer.write_byte((byte)-67);
                    break;
                }
                case '\u0178': {
                    buffer.write_byte((byte)-66);
                    break;
                }
                default: {
                    super.write_char(buffer, c, write_bom, write_length_indicator, giop_minor);
                }
            }
        }
    }

    private static class Iso8859_1CodeSet
    extends CodeSet {
        private Iso8859_1CodeSet() {
            super(65537, "ISO8859_1");
        }

        protected Iso8859_1CodeSet(int i, String name) {
            super(i, name);
        }

        @Override
        public boolean supportsCharacterData(boolean wide) {
            return !wide;
        }

        @Override
        public void write_char(OutputBuffer buffer, char c, boolean write_bom, boolean write_length_indicator, int giop_minor) {
            buffer.write_byte((byte)c);
        }
    }

    public static interface OutputBuffer {
        public void write_byte(byte var1);

        public void write_short(short var1);
    }

    public static interface InputBuffer {
        public byte readByte();

        public int get_pos();

        public boolean readBOM();
    }
}

