/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;
import org.slf4j.Logger;

public class ExceptionHolderImpl
extends ExceptionHolder
implements Configurable {
    private Logger logger = null;
    private final ORB orb;

    public ExceptionHolderImpl(ORB orb) {
        this.orb = orb;
        try {
            this.configure(orb.getConfiguration());
        }
        catch (ConfigurationException ex) {
            throw new INTERNAL("Caught configuration exception." + ex);
        }
    }

    public ExceptionHolderImpl(ORB orb, ReplyInputStream inputStream) {
        this(orb);
        int status = inputStream.getStatus().value();
        if (status == 1) {
            this.is_system_exception = false;
        } else if (status == 2) {
            this.is_system_exception = true;
        } else {
            throw new BAD_PARAM("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = inputStream.getLittleEndian();
        this.marshaled_exception = inputStream.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionHolderImpl(ORB orb, SystemException exception) {
        this(orb);
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream out = new CDROutputStream(orb);
        try {
            SystemExceptionHelper.write(out, exception);
            this.marshaled_exception = out.getBufferCopy();
        }
        finally {
            out.close();
        }
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("jacorb.orb.exc_holder");
    }

    @Override
    public void raise_exception_with_list(TypeCode[] exc_list) throws UserException {
        throw new NO_IMPLEMENT("NYI");
    }

    @Override
    public void raise_exception() throws UserException {
        CDRInputStream input = new CDRInputStream((org.omg.CORBA.ORB)this.orb, this.marshaled_exception, this.byte_order);
        try {
            UserException result;
            if (this.is_system_exception) {
                throw SystemExceptionHelper.read(input);
            }
            input.mark(0);
            String id = input.read_string();
            try {
                input.reset();
            }
            catch (IOException e) {
                this.logger.error("Unexpected IOException: ", e);
                throw new INTERNAL("Unexpected IOException: " + e);
            }
            try {
                result = this.exceptionFromHelper(id, input);
            }
            catch (Exception e) {
                this.logger.error("error reading exception", e);
                throw new UnknownUserException();
            }
            throw result;
        }
        catch (Throwable throwable) {
            input.close();
            throw throwable;
        }
    }

    public void raise_exception_with_list(ExceptionList exc_list) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            result.append(this.marshaled_exception[i]);
            result.append('(');
            result.append((char)this.marshaled_exception[i]);
            result.append(")  ");
        }
        return result.toString();
    }

    public UserException exceptionFromHelper(String repositoryID, InputStream input) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String helperClassName = RepositoryID.className(repositoryID, "Helper", null);
        try {
            Class<?> helperClazz = ObjectUtil.classForName(helperClassName);
            return this.exceptionFromHelper(input, helperClazz);
        }
        catch (ClassNotFoundException e) {
            String repositoryIDWithoutPragmaPrefix = this.stripPragmaPrefix(repositoryID);
            if (!repositoryIDWithoutPragmaPrefix.equals(repositoryID)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("unable to locate class " + helperClassName + " for repository ID " + repositoryID + ". Retrying without pragma prefix: " + repositoryIDWithoutPragmaPrefix);
                }
                return this.exceptionFromHelper(repositoryIDWithoutPragmaPrefix, input);
            }
            throw e;
        }
    }

    private String stripPragmaPrefix(String original) {
        int index = original.indexOf(46, 4);
        int versionIndex = original.lastIndexOf(58);
        if (index > 0 && index < versionIndex) {
            return "IDL:" + original.substring(original.indexOf(47) + 1);
        }
        return original;
    }

    private UserException exceptionFromHelper(InputStream input, Class<?> helperClazz) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Method readMethod = helperClazz.getMethod("read", InputStream.class);
        return (UserException)readMethod.invoke(null, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] marshal() {
        CDROutputStream out = new CDROutputStream(this.orb);
        try {
            out.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
            byte[] byArray = out.getBufferCopy();
            return byArray;
        }
        finally {
            out.close();
        }
    }
}

