/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import org.jacorb.collection.CollectionImpl;
import org.jacorb.collection.KeyNode;
import org.jacorb.collection.KeySortedCollectionImpl;
import org.jacorb.collection.OrderedIteratorImpl;
import org.jacorb.collection.util.ObjectInvalid;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosCollection.AnySequenceHolder;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.KeyInvalid;
import org.omg.CosCollection.KeySortedIteratorOperations;
import org.omg.CosCollection.LowerBoundStyle;
import org.omg.CosCollection.UpperBoundStyle;

class KeySortedIteratorImpl
extends OrderedIteratorImpl
implements KeySortedIteratorOperations {
    KeyNode test_key = new KeyNode();
    KeySortedCollectionImpl key_collection;

    KeySortedIteratorImpl(KeySortedCollectionImpl collection) {
        super(collection);
        this.key_collection = collection;
    }

    KeySortedIteratorImpl(KeySortedCollectionImpl collection, boolean read_only) {
        super(collection, read_only);
        this.key_collection = collection;
    }

    KeySortedIteratorImpl(KeySortedCollectionImpl collection, boolean read_only, boolean reverse) {
        super(collection, read_only, reverse);
        this.key_collection = collection;
    }

    @Override
    public boolean set_to_element_with_key(Any key) throws KeyInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.key_collection.check_key(key);
            this.test_key.key = key;
            try {
                int pos = this.key_collection.keys.indexOf((Object)key);
                if (pos >= 0) {
                    KeyNode node = (KeyNode)this.key_collection.keys.elementAt(pos);
                    this.set_pos(node.start_position);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    @Override
    public boolean set_to_next_element_with_key(Any key) throws IteratorInvalid, KeyInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            this.key_collection.check_key(key);
            this.test_key.key = key;
            try {
                int pos = this.key_collection.keys.indexOf((Object)key);
                if (pos >= 0) {
                    int start_pos;
                    KeyNode node = (KeyNode)this.key_collection.keys.elementAt(pos);
                    int n = start_pos = this.is_in_between() ? this.get_pos() : this.get_pos() + 1;
                    if (start_pos <= node.start_position || start_pos < node.start_position + node.count) {
                        this.set_pos(start_pos);
                        this.set_in_between(false);
                        return true;
                    }
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    @Override
    public boolean set_to_next_element_with_different_key() throws IteratorInBetween, IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            Any key;
            this.check_iterator();
            this.test_key.key = key = this.collection.ops.key((Any)this.collection.data.elementAt(this.get_pos()));
            try {
                int pos = this.key_collection.keys.indexOf((Object)key);
                if (pos >= 0 && pos < this.key_collection.keys.size() - 1) {
                    KeyNode node = (KeyNode)this.key_collection.keys.elementAt(++pos);
                    this.set_pos(node.start_position);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retrieve_key(AnyHolder key) throws IteratorInBetween, IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_iterator();
            key.value = this.collection.ops.key((Any)this.collection.data.elementAt(this.get_pos()));
            return true;
        }
    }

    @Override
    public boolean retrieve_next_n_keys(AnySequenceHolder keys) throws IteratorInBetween, IteratorInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean set_to_first_element_with_key(Any key, LowerBoundStyle style) throws KeyInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean set_to_last_element_with_key(Any key, UpperBoundStyle style) throws KeyInvalid {
        throw new NO_IMPLEMENT();
    }

    @Override
    public boolean set_to_previous_element_with_key(Any key) throws IteratorInvalid, KeyInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            this.check_invalid();
            this.key_collection.check_key(key);
            this.test_key.key = key;
            try {
                int pos = this.key_collection.keys.indexOf((Object)key);
                if (pos >= 0) {
                    KeyNode node = (KeyNode)this.key_collection.keys.elementAt(pos);
                    int start_pos = this.get_pos() - 1;
                    if (start_pos <= node.start_position || start_pos < node.start_position + node.count) {
                        this.set_pos(start_pos);
                        this.set_in_between(false);
                        return true;
                    }
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    @Override
    public boolean set_to_previous_element_with_different_key() throws IteratorInBetween, IteratorInvalid {
        CollectionImpl collectionImpl = this.collection;
        synchronized (collectionImpl) {
            Any key;
            this.check_iterator();
            this.test_key.key = key = this.collection.ops.key((Any)this.collection.data.elementAt(this.get_pos()));
            try {
                int pos = this.key_collection.keys.indexOf((Object)key);
                if (pos > 0) {
                    KeyNode node = (KeyNode)this.key_collection.keys.elementAt(--pos);
                    this.set_pos(node.start_position);
                    this.set_in_between(false);
                    return true;
                }
                this.invalidate();
                return false;
            }
            catch (ObjectInvalid e) {
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        }
    }

    @Override
    public boolean retrieve_previous_n_keys(AnySequenceHolder keys) throws IteratorInBetween, IteratorInvalid {
        throw new NO_IMPLEMENT();
    }
}

