/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoAppender;
import fr.esrf.TangoDs.TangoConsoleAppender;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TangoDeviceAppender;
import fr.esrf.TangoDs.TangoRollingFileAppender;
import fr.esrf.TangoDs.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Logging
implements TangoConst {
    private static Logging _instance = null;
    private static Logger _core_logger = null;
    private String logging_path = null;
    private long rft = 2048L;
    private int cmd_line_level = 0;
    final String _DefaultTargetName = "default";

    public static Logging instance() {
        if (_instance == null) {
            System.err.println("Logging is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static Logger core_logger() {
        return _core_logger;
    }

    public static Logging init(String string, int n, Database database) {
        if (_instance == null) {
            _instance = new Logging(string, n, database);
        }
        return _instance;
    }

    protected Logging(String string, int n, Database database) {
        String string2;
        this.cmd_line_level = n;
        String string3 = "dserver/" + string;
        this.verbose("Initializing logging for " + string3);
        Logger logger = Logger.getLogger((String)string3.toLowerCase());
        if (logger == null) {
            this.verbose("\tFailed to instanciate the TANGO core-logger");
            this.verbose("\tAborting logging intialization");
            return;
        }
        this.verbose("\tTANGO core-logger instanciated");
        logger.setAdditivity(false);
        String string4 = "/tmp/tango";
        try {
            string2 = System.getProperty("os.name");
            this.verbose("\tRunning on " + string2);
            if (string2.toLowerCase().indexOf("windows") != -1) {
                string4 = "c:/tango";
            }
        }
        catch (Exception exception) {
            this.verbose("\tException caught while trying to get <os.name> system property");
            this.verbose("\tAborting logging intialization");
            return;
        }
        string2 = System.getProperty("TANGO_LOG_PATH");
        if (string2 == null || string2.length() == 0) {
            this.logging_path = string4;
            this.verbose("\tEnv. variable TANGO_LOG_PATH not set");
        } else {
            this.logging_path = string2;
        }
        this.logging_path = this.logging_path + "/" + string;
        this.verbose("\tDefault logging directory set to " + this.logging_path);
        boolean bl = this.cmd_line_level != 0;
        Level level = Level.WARN;
        if (bl) {
            level = this.cmd_line_level <= 2 ? Level.INFO : Level.DEBUG;
        }
        logger.setLevel(level);
        this.verbose("\tTANGO core-logger intial level is " + level.toString());
        if (database == null) {
            this.verbose("\tNot using the database. Logging Intialization complete");
            return;
        }
        this.verbose("\tReading logging properties from database");
        LoggingProperties loggingProperties = this.get_logging_properties(logger, database);
        if (loggingProperties == null) {
            this.verbose("\tFailed to obtain logging properties from database");
            this.verbose("\tAborting logging intialization");
            return;
        }
        if (loggingProperties.logging_path != null) {
            this.logging_path = loggingProperties.logging_path;
            this.verbose("\tLogging path changed to " + this.logging_path);
        }
        if (!bl) {
            logger.setLevel(loggingProperties.logging_level);
            this.verbose("\tLogging level set to " + loggingProperties.logging_level.toString());
        }
        if (this.rft != loggingProperties.logging_rft) {
            this.rft = loggingProperties.logging_rft;
            this.verbose("\tRolling threshold changed to " + String.valueOf(this.rft));
        }
        this.verbose("\tAdding initial targets to TANGO core-logger");
        if (bl) {
            try {
                this.add_logging_target(logger, "console");
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        if (loggingProperties.logging_targets != null) {
            for (String string5 : loggingProperties.logging_targets) {
                try {
                    this.add_logging_target(logger, string5);
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
        }
        _core_logger = logger;
    }

    public LoggingProperties get_logging_properties(Logger logger, Database database) {
        LoggingProperties loggingProperties = new LoggingProperties();
        if (logger == null) {
            return loggingProperties;
        }
        try {
            if (database == null) {
                return loggingProperties;
            }
            String[] stringArray = new String[]{"logging_path", "logging_rft", "logging_level", "logging_target"};
            DbDatum[] dbDatumArray = database.get_device_property(logger.getName(), stringArray);
            if (!dbDatumArray[0].is_empty()) {
                loggingProperties.logging_path = dbDatumArray[0].extractString();
            }
            if (!dbDatumArray[1].is_empty()) {
                loggingProperties.logging_rft = dbDatumArray[1].extractLong();
            }
            if (loggingProperties.logging_rft < 500L) {
                loggingProperties.logging_rft = 500L;
            } else if (loggingProperties.logging_rft > 20480L) {
                loggingProperties.logging_rft = 20480L;
            }
            if (!dbDatumArray[2].is_empty()) {
                String string = dbDatumArray[2].extractString();
                loggingProperties.logging_level = this.tango_to_log4j_level(string);
            }
            if (!dbDatumArray[3].is_empty()) {
                loggingProperties.logging_targets = dbDatumArray[3].extractStringArray();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return loggingProperties;
    }

    public void add_logging_target(String[] stringArray) throws DevFailed {
        String string;
        this.kill_zombie_appenders();
        if (stringArray.length % 2 != 0) {
            string = "Incorrect number of arguments";
            Except.throw_exception("API_MethodArgument", string, "Logging::add_logging_target");
        }
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n++].toLowerCase();
            Vector vector = Util.instance().get_device_list(string);
            if (vector.size() == 0) {
                String string2 = "No device matching pattern <" + string + ">";
                Except.throw_exception("API_DeviceNotFound", string2, "Logging::add_logging_target");
            }
            for (Object e : vector) {
                Logger logger = ((DeviceImpl)e).get_logger();
                this.add_logging_target(logger, stringArray[n++]);
            }
        }
    }

    public void add_logging_target(Logger logger, String string, String string2) throws DevFailed {
        this.add_logging_target(logger, string + "::" + string2);
    }

    public void add_logging_target(Logger logger, String string) throws DevFailed {
        String string2;
        Object object;
        String string3;
        if (logger == null) {
            return;
        }
        string = string.toLowerCase();
        String string4 = this.get_target_type(string);
        String string5 = this.get_target_name(string);
        int n = -1;
        if ("file".equals(string4)) {
            n = 0;
        } else if ("device".equals(string4)) {
            n = 1;
        } else if ("console".equals(string4)) {
            n = 2;
        } else {
            string3 = "Invalid logging target type specified (" + string4 + ")";
            Except.throw_exception("API_MethodArgument", string3, "Logging::add_logging_target");
        }
        string3 = null;
        String string6 = string4 + "::";
        switch (n) {
            case 0: {
                if (string5.equals("default")) {
                    string3 = this.logging_path + "/";
                    string3 = string3 + this.device_to_file_name(logger.getName()) + ".log";
                } else {
                    string3 = string5.indexOf(47) != -1 ? string5 : this.logging_path + "/" + string5;
                }
                object = new File(string3);
                File file = new File(((File)object).getParent());
                if (!file.isDirectory()) {
                    try {
                        file.mkdirs();
                    }
                    catch (Exception exception) {
                        String string7 = "Failed to create directory " + file.getPath();
                        Except.throw_exception("API_SystemException", string7, "Logging::add_logging_target");
                    }
                }
                string5 = string3;
                string6 = string6 + string5;
                break;
            }
            case 1: {
                if (string5.equals("default")) {
                    string2 = "Device target name must be specified (no default value)";
                    Except.throw_exception("API_MethodArgument", string2, "Logging::add_logging_target");
                }
                string6 = string6 + string5;
                break;
            }
            case 2: {
                string6 = string6 + "console";
            }
        }
        object = logger.getAppender(string6);
        if (object != null) {
            Util.out4.println("Target " + string6 + " is already attached to " + logger.getName());
            return;
        }
        try {
            Util.out4.println("Adding " + string6 + " to " + logger.getName());
            switch (n) {
                case 0: {
                    try {
                        object = new TangoRollingFileAppender(string6, string3, this.rft);
                    }
                    catch (IOException iOException) {
                        string2 = "Could not open logging file " + string3;
                        Util.out4.println(string2);
                        Except.throw_exception("API_CannotOpenFile", string2, "Logging::add_logging_target");
                    }
                    break;
                }
                case 1: {
                    object = new TangoDeviceAppender(logger.getName(), string6, string5);
                    break;
                }
                case 2: {
                    object = new TangoConsoleAppender(string6);
                }
            }
            logger.addAppender((Appender)object);
            Util.out4.println("Added logging target " + string6 + " to " + logger.getName());
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            string2 = "System exception caugth while trying to add target " + string + " to " + logger.getName();
            Except.throw_exception("API_SystemException", string2, "Logging::add_logging_target");
        }
    }

    public void remove_logging_target(String[] stringArray) throws DevFailed {
        Object object;
        this.kill_zombie_appenders();
        if (stringArray.length % 2 != 0) {
            object = "Incorrect number of arguments";
            Except.throw_exception("API_MethodArgument", (String)object, "Logging::remove_logging_target");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2 = stringArray[n++].toLowerCase();
            object = Util.instance().get_device_list(string2);
            if (((Vector)object).size() == 0) {
                string = "No device matching pattern <" + string2 + ">";
                Except.throw_exception("API_DeviceNotFound", string, "Logging::remove_logging_target");
            }
            string = this.get_target_type(stringArray[n]).toLowerCase();
            String string3 = this.get_target_name(stringArray[n++]).toLowerCase();
            int n2 = -1;
            if ("file".equals(string)) {
                n2 = 0;
            } else if ("device".equals(string)) {
                n2 = 1;
            } else if ("console".equals(string)) {
                n2 = 2;
                string3 = "console";
            } else {
                String string4 = "Invalid logging target type specified (" + string + ")";
                Except.throw_exception("API_MethodArgument", string4, "Logging::remove_logging_target");
            }
            boolean bl = string3.equals("*");
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object e = iterator.next();
                Logger logger = ((DeviceImpl)e).get_logger();
                if (!bl) {
                    object2 = string + "::";
                    if (n2 == 0) {
                        if (string3.equals("default")) {
                            object2 = this.logging_path + "/";
                            object2 = (String)object2 + this.device_to_file_name(logger.getName()) + ".log";
                        } else {
                            object2 = string3.indexOf(47) != -1 ? string3 : this.logging_path + "/" + string3;
                        }
                    } else {
                        object2 = (String)object2 + string3;
                    }
                    Util.out4.println("Removing target " + (String)object2 + " from " + logger.getName());
                    logger.removeAppender((String)object2);
                    continue;
                }
                Util.out4.println("Removing ALL <" + string + "> targets from " + logger.getName());
                object2 = logger.getAllAppenders();
                String string5 = string + "::";
                while (object2.hasMoreElements()) {
                    Appender appender = (Appender)object2.nextElement();
                    if (appender.getName().indexOf(string5) == -1) continue;
                    logger.removeAppender(appender.getName());
                }
            }
        }
    }

    public void set_logging_level(DevVarLongStringArray devVarLongStringArray) throws DevFailed {
        if (devVarLongStringArray.svalue.length != devVarLongStringArray.svalue.length) {
            String string = "Imcompatible command argument type, long and string arrays must have the same length";
            Except.throw_exception("API_IncompatibleCmdArgumentType", string, "Logging::set_logging_level");
        }
        for (int i = 0; i < devVarLongStringArray.svalue.length; ++i) {
            Level level = this.tango_to_log4j_level(devVarLongStringArray.lvalue[i]);
            String string = devVarLongStringArray.svalue[i].toLowerCase();
            Vector vector = Util.instance().get_device_list(string);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Logger logger = ((DeviceImpl)iterator.next()).get_logger();
                if (logger == null) {
                    String string2 = "Internal error. Got invalid logger for device " + logger.getName();
                    Except.throw_exception("API_InternalError", string2, "Logging::set_logging_level");
                }
                logger.setLevel(level);
                Util.out4.println("Logging level set to " + level.toString() + " for device " + logger.getName());
            }
        }
    }

    public DevVarLongStringArray get_logging_level(String[] stringArray) throws DevFailed {
        Object object;
        Serializable serializable;
        int n;
        Vector<String> vector = new Vector<String>();
        Vector<Level> vector2 = new Vector<Level>();
        for (n = 0; n < stringArray.length; ++n) {
            serializable = Util.instance().get_device_list(stringArray[n].toLowerCase());
            Iterator iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                object = (DeviceImpl)iterator.next();
                vector.addElement(((DeviceImpl)object).get_name());
                vector2.addElement(((DeviceImpl)object).get_logger().getLevel());
            }
        }
        serializable = new DevVarLongStringArray();
        ((DevVarLongStringArray)serializable).lvalue = new int[vector2.size()];
        ((DevVarLongStringArray)serializable).svalue = new String[vector.size()];
        n = 0;
        object = vector.iterator();
        Iterator iterator = vector2.iterator();
        while (object.hasNext() && iterator.hasNext()) {
            ((DevVarLongStringArray)serializable).svalue[n] = (String)object.next();
            ((DevVarLongStringArray)serializable).lvalue[n] = this.log4j_to_tango_level((Level)iterator.next());
            ++n;
        }
        return serializable;
    }

    public String[] get_logging_target(String string) throws DevFailed {
        DeviceImpl deviceImpl = Util.instance().get_device_by_name(string);
        Enumeration enumeration = deviceImpl.get_logger().getAllAppenders();
        int n = 0;
        Enumeration enumeration2 = deviceImpl.get_logger().getAllAppenders();
        while (enumeration2.hasMoreElements()) {
            ++n;
            enumeration2.nextElement();
        }
        String[] stringArray = new String[n];
        n = 0;
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            stringArray[n++] = appender.getName();
        }
        return stringArray;
    }

    public void stop_logging() {
        Vector vector = Util.instance().get_device_list("*");
        for (Object e : vector) {
            ((DeviceImpl)e).stop_logging();
        }
    }

    public void start_logging() {
        Vector vector = Util.instance().get_device_list("*");
        for (Object e : vector) {
            ((DeviceImpl)e).start_logging();
        }
    }

    public void kill_zombie_appenders() {
        Vector vector = Util.instance().get_device_list("*");
        for (Object e : vector) {
            DeviceImpl deviceImpl = (DeviceImpl)e;
            Logger logger = deviceImpl.get_logger();
            if (logger == null) continue;
            Enumeration enumeration = logger.getAllAppenders();
            while (enumeration.hasMoreElements()) {
                Appender appender = (Appender)enumeration.nextElement();
                if (((TangoAppender)appender).isValid()) continue;
                Util.out4.println("Removing zombie appender " + deviceImpl.get_name() + "::" + appender.getName());
                logger.removeAppender(appender);
            }
        }
    }

    private String get_target_type(String string) {
        String[] stringArray;
        try {
            stringArray = string.split("::");
        }
        catch (Exception exception) {
            return "unknown";
        }
        return stringArray[0];
    }

    private String get_target_name(String string) {
        String[] stringArray;
        try {
            stringArray = string.split("::");
        }
        catch (Exception exception) {
            return "default";
        }
        return stringArray.length > 1 ? stringArray[1] : "default";
    }

    private String device_to_file_name(String string) {
        return string.replace('/', '_');
    }

    private void verbose(String string) {
        if (this.cmd_line_level >= 4) {
            System.out.println(string);
        }
    }

    public Level tango_to_log4j_level(int n) throws DevFailed {
        switch (n) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.FATAL;
            }
            case 2: {
                return Level.ERROR;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.INFO;
            }
            case 5: {
                return Level.DEBUG;
            }
        }
        String string = "Invalid logging level specified (out of range)";
        Except.throw_exception("API_MethodArgument", string, "Logging::tango_to_log4j_level");
        return Level.WARN;
    }

    public Level tango_to_log4j_level(String string) {
        if ((string = string.toUpperCase()).equals(LOGGING_LEVELS[0])) {
            return Level.OFF;
        }
        if (string.equals(LOGGING_LEVELS[1])) {
            return Level.FATAL;
        }
        if (string.equals(LOGGING_LEVELS[2])) {
            return Level.ERROR;
        }
        if (string.equals(LOGGING_LEVELS[4])) {
            return Level.INFO;
        }
        if (string.equals(LOGGING_LEVELS[5])) {
            return Level.DEBUG;
        }
        return Level.WARN;
    }

    public int log4j_to_tango_level(Level level) {
        if (level.equals((Object)Level.OFF)) {
            return 0;
        }
        if (level.equals((Object)Level.FATAL)) {
            return 1;
        }
        if (level.equals((Object)Level.ERROR)) {
            return 2;
        }
        if (level.equals((Object)Level.WARN)) {
            return 3;
        }
        if (level.equals((Object)Level.INFO)) {
            return 4;
        }
        return 5;
    }

    public void set_rolling_file_threshold(Logger logger, long l) {
        if (logger == null) {
            return;
        }
        if (l < 500L) {
            l = 500L;
        } else if (l > 20480L) {
            l = 20480L;
        }
        String string = "file::";
        Enumeration enumeration = logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            if (appender.getName().indexOf(string) == -1) continue;
            TangoRollingFileAppender tangoRollingFileAppender = (TangoRollingFileAppender)appender;
            tangoRollingFileAppender.setMaximumFileSize(l * 1024L);
        }
    }

    public class LoggingProperties {
        public String logging_path = null;
        public String[] logging_targets = null;
        public Level logging_level = Level.WARN;
        public long logging_rft = 2048L;
    }
}

