/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoPeriodic
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoPeriodic(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoPeriodicListener(ITangoPeriodicListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoPeriodicListener.class, listener);
        this.event_identifier = this.subscribe_periodic_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoPeriodicListener(ITangoPeriodicListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoPeriodicListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoPeriodic tangoPeriodic = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoPeriodic.this.fireTangoPeriodicEvent(tangoPeriodic, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoPeriodicEvent(tangoPeriodic, eventData);
        }
    }

    private void fireTangoPeriodicEvent(TangoPeriodic tangoPeriodic, EventData eventData) {
        TangoPeriodicEvent tangoPeriodicEvent = new TangoPeriodicEvent(tangoPeriodic, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoPeriodicListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoPeriodicListener)eventListener).periodic(tangoPeriodicEvent);
        }
    }
}

