/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoDataReadyListener;
import fr.esrf.TangoApi.events.TangoDataReadyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoDataReady
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoDataReady(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoDataReadyListener(ITangoDataReadyListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoDataReadyListener.class, listener);
        this.event_identifier = this.subscribe_data_ready_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoDataReadyListener(ITangoDataReadyListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoDataReadyListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoDataReady tangoDataReady = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoDataReady.this.fireTangoDataReadyEvent(tangoDataReady, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoDataReadyEvent(tangoDataReady, eventData);
        }
    }

    private void fireTangoDataReadyEvent(TangoDataReady tangoDataReady, EventData eventData) {
        TangoDataReadyEvent data_ready_event = new TangoDataReadyEvent(tangoDataReady, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoDataReadyListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoDataReadyListener)eventListener).data_ready(data_ready_event);
        }
    }
}

